#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <assert.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef WIN32
#include <io.h>
#include <direct.h>

#define open _open
#define read _read
#define lseek _lseek
#define close _close
#endif

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "file.h"


Cfile			*Cfile::g_hash[FHASHSIZE] = {0};
unsigned int	Cfile::g_hash_cnt        = 0;

static unsigned int
hash(const char *nameP)
{
	int		ret  = 0;
	int		c;
	const	char *P;

	for (P = nameP; (c = *P) ; ++P) {
		ret  += c;
		ret <<= 1;
		if (ret & FHASHSIZE) {
			ret |= 1;
	}	}
	return(ret & (FHASHSIZE-1));
}

Cfile::Cfile(char *nameP)
{
	if (nameP) {
		m_nameP = dupstring(nameP);
	}

	m_hashP    = 0;
	m_sourcePP = 0;
}

Cfile *
Cfile::exists(char *nameP)
{
	Cfile	 		*fileP;
	unsigned int	index;

	index = hash(nameP);
	for (fileP = g_hash[index]; fileP; fileP = fileP->m_hashP) {
		if (!strcmp(fileP->m_nameP, nameP)) {
			return(fileP);
	}	}
	return(0);
}

Cfile *
Cfile::locate(char *nameP)
{
	Cfile	 		*fileP, **filePP;
	unsigned int	index;

	index = hash(nameP);
	for (filePP = g_hash + index; (fileP = *filePP); filePP = &fileP->m_hashP) {
		if (!strcmp(fileP->m_nameP, nameP)) {
			return(fileP);
	}	}
	*filePP = fileP = new Cfile(nameP);
	return(fileP);
}

void
Cfile::load_source(void)
{
	struct stat buf;

	char	*filenameP;
	int		lineno;
	int		fileno;
	char	**sourcePP;
	char	*source_codeP, *atP, *eolP, *endP;
	int		source_lth, source_code_lth;
	int		ret, segment;
	
	if (!m_sourcePP) {
		m_sourcePP     = (char **) -1;
		m_source_lines = 0;
	
		filenameP = m_nameP;
		fileno    = open(filenameP, O_RDONLY, 0);
	
		if (fileno < 0) {
			fprintf(stderr, "Can't open %s\n", filenameP);
			perror("");
			return;
		}
		// We have to scan the input more than once so read the entire input
		// into memory
	
		ret = fstat(fileno, &buf);
		if (ret != 0) {
			fprintf(stderr,"Fstat %s returned %d\n", filenameP, ret);
			perror("");
			goto bad_source;
		}
	
		// Allocate a large enough memory buffer
	
		source_code_lth = buf.st_size;
		if (!source_code_lth) {
			fprintf(stderr, "%s is empty\n", filenameP);
			goto bad_source;
		}
	
		source_codeP = atP = (char *) Xmalloc(source_code_lth + 2);
		if (!source_codeP) {
			outofmemory();
		}
		for (endP = atP + source_code_lth; atP < endP; atP += ret) {
			segment = endP - atP;
			if (segment > SSIZE_MAX) {
				segment = SSIZE_MAX;
			}
			ret = read(fileno, atP, segment);
			if (ret <= 0) {
				fprintf(stderr, "Read %s returned %d\n", m_nameP, ret);
				perror("");
bad_source:		close(fileno);
				return;
		}	}
		assert(atP == endP);
		if (atP == source_codeP || atP[-1] != '\n') {
			*atP++ = '\n';
		}
		Xcheck(source_codeP, source_code_lth, atP);
		*atP = 0;
	
		close(fileno);
	
		lineno = 0;
		for (atP = source_codeP; (eolP = strchr(atP, '\n')); atP = eolP + 1) {
			++lineno;
		}
	
		source_lth     = (lineno + 1) * sizeof(char *);
		m_sourcePP     = sourcePP = (char **) Xmalloc(source_lth);
		if (!sourcePP) {
			outofmemory();
		}	
		m_source_lines = lineno;
	
		lineno = 0;
		for (atP = source_codeP; (eolP = strchr(atP, '\n')); atP = eolP + 1) {
			sourcePP[lineno++] = atP;
			*eolP = 0;
		}
		Xcheck(m_sourcePP, source_lth, (sourcePP+lineno));
		sourcePP[lineno] = atP;
		assert(lineno == m_source_lines);
	}

	return;
}

void
Cfile::showline(FILE *F, const Cfile **defaultPP, int lineno)
{
	const Cfile *defaultP;

	if (!m_sourcePP) {
		load_source();
	}
	if (lineno > 0 && lineno <= m_source_lines) {
		defaultP = *defaultPP;
		if (this != defaultP) {
			fprintf(F, "<b>%s</b>\n<br>\n", m_nameP);
			*defaultPP = this;
		}
		fprintf(F, "%d] ", lineno);
		put_html(m_sourcePP[--lineno], F);
	}
}
