#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <assert.h>
#include <string.h>

#include "object.h"
#include "xmalloc.h"
#include "match.h"


int					Cmatch::m_matches_lth         = 0;
matchesT **			Cmatch::m_matchesPP           = 0;
block_matchesT *	Cmatch::m_head_block_matchesP = 0;
block_matchesT *	Cmatch::m_block_matchesP      = 0;
matchesT *	    	Cmatch::m_matches_cacheP      = 0;
matchesT *	        Cmatch::m_matches_endP        = 0;
long long			Cmatch::m_comparisons         = 0;

extern int	g_max_function_lth;

void
Cmatch::init(void)
{
	m_matches_lth     = sizeof(matchesT *) * g_max_function_lth;
	m_matchesPP       = (matchesT **)  Xmalloc(m_matches_lth);
	if (!m_matchesPP) {
		outofmemory();
	}
}

void
Cmatch::setup(int lth)
{
	assert(lth <= g_max_function_lth);
	memset(m_matchesPP, 0, lth * sizeof(matchesT *));
}
			
void
Cmatch::add(int offset, void *code2P)
{
	static	block_matchesT	*next_blockP;
	static	matchesT		**matchPP;

	if (m_matches_cacheP == m_matches_endP) {
		if (m_block_matchesP) {
			next_blockP = m_block_matchesP->m_nextP;
		} else {
			next_blockP = 0;
		}
		if (!next_blockP) {
			next_blockP = (block_matchesT *) Xmalloc(sizeof(block_matchesT));
			if (!next_blockP) {
				outofmemory();
			}
			next_blockP->m_nextP = 0;
			if (m_block_matchesP) {
				m_block_matchesP->m_nextP = next_blockP;
			} else {
				m_head_block_matchesP = next_blockP;
		}	}
		m_block_matchesP = next_blockP;

		m_matches_cacheP = m_block_matchesP->m_cache;
		m_matches_endP   = m_matches_cacheP + 8192;
	}
	m_matches_cacheP->m_codeP = code2P;
	matchPP                   = m_matchesPP + offset;
	Xcheck(m_matchesPP, m_matches_lth, matchPP);
	m_matches_cacheP->m_nextP = *matchPP;
	*matchPP                  = m_matches_cacheP++;
}

int
Cmatch::test(int offset, void *code2P)
{
	static	matchesT		*matchesP, **matchesPP;

	for (matchesPP = m_matchesPP + offset; (matchesP = *matchesPP); matchesPP = &(matchesP->m_nextP)) {
		++m_comparisons;
		if (matchesP->m_codeP == code2P) {
			*matchesPP = matchesP->m_nextP;
			return(1);
	}	}
	return(0);
}

void
Cmatch::clear(void)
{
	m_block_matchesP = m_head_block_matchesP;
	if (m_block_matchesP) {
		m_matches_cacheP = m_block_matchesP->m_cache;
		m_matches_endP   = m_matches_cacheP + 8192;
}	}
