#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS

// #define DEBUG_HASH

#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <direct.h>
#include <stdlib.h>

#define F_OK 0

#include "util.h"
#include "xmalloc.h"
#include "object.h"
#include "label.h"
#include "location.h"
#include "file.h"
#include "fileref.h"
#include "code.h"
#include "function.h"
#include "directory.h"
#include "source.h"
#include "read_assembler.h"

#define HASH_SIZE 0x100000

#ifdef DEBUG_HASH
static codeT	*hash_table[HASH_SIZE] = {0};
#endif

static codeT	**hash_tailPP[HASH_SIZE] = {0};

static void
hash_assembler(codeT *codeP)
{
	char		*P;
	int			hash;
	int			c;
	codeT		**hashPP;

	hash = 0;
	P    = codeP->m_codeP;
	if (P) {
		if (*P == 'j') {
			for (; (c = *P) && c != ' '; ++P) {
				hash <<= 1;
				hash  ^= *P;
			}
		} else {
			for (; (c = *P); ++P) {
				hash <<= 1;
				hash  ^= *P;
		}	}
		hash &= (HASH_SIZE - 1);
	}
	
	if ((hashPP = hash_tailPP[hash])) {
		*hashPP = codeP; 
	}
#ifdef DEBUG_HASH
  	  else {
		hash_table[hash] = codeP;
	}
#endif

	hash_tailPP[hash] = &(codeP->m_hashP);
}

extern	int		g_use_frame_address;
extern	int		g_match_lines;
extern	int		g_max_function_lth;
extern	int		g_read;
extern	int		g_hypertext_cnt;
extern	FILE 	*taF;
extern	FILE	*tempF;

extern int	g_stdin_lineno;

extern labelT	*g_labelsP;

static int
convert_to_string(char **atPP, int *linenoP)
{
	char	*startP  = *atPP;
	char	*stringP = startP;
	char	*atP     = stringP;
	char	*P;
	char	c;
	int		val, state;

	for (state = 0;;) {
		switch ((c = *atP)) {
		case '\n':
			++(*linenoP);
		case ' ':
			++atP;
			continue;
		case ',':
			if (state != 2) {
				break;
			}
			state = 1;
			++atP;
			continue;
		case 'D':
			if (state == 1) {
				break;
			}
			if (!strncmp(atP, "DB ", 3)) {
				atP += 3;
				state = 1;
				continue;
			}
		case '\'':
			if (state != 1) {
				break;
			}
			*stringP++ = c;
			for (;;) {
				*stringP++ = c = *(++atP);
				if (c == '\'') {
					c = *(++atP);
					if (c != '\'') {
						break;
					}
					*stringP++ = c;
			}	}
			state = 2;
			continue;
		default:
			if (state != 1) {
				break;
			}
			P = atP;
			for (val = 0;; ) {
				if (c >= '0' && c <= '9') {
					c -= '0';
				} else if (c >= 'a' && c <= 'f') {
					c += 10 - 'a';
				} else if (c >= 'A' && c <= 'F') {
					c += 10 - 'A';
				} else {
					if (P == atP) {
						break;
					}
					if (c == 'h' || c == 'H') {
						++atP;
						break;
					}
					assert(0);
				}
				val = (val * 16) + c;
				c   = *(++atP);
			}
			if (P == atP) {
				break;
			}
			assert(val >= 0 && val < 256);
			stringP += sprintf(stringP, "%02x", val);
			state = 2;
			continue;
		}
		break;
	}
	*stringP = 0;
	if (atP[-1] != '\n') {
		atP = strchr(atP, '\n') + 1;
		++(*linenoP);
	}
	*atPP    = atP;
	return(stringP - startP);
}

int
Csource::load(char *assemblerP)
{
	static	int		g_labels_cnt = 0;

	char		*atP, *startP;
	int			labels_seen, codes_seen;
	codeT		*codeP, *end_codesP;
	int			*linenosP;
	labelT		*labelP;
	int			lth, lth1, lth2, segment, source_lineno;
	int			lineno, ret, const_seg, text_seg, function_seen;

	Cfunction	*functionP, **functionsPP;
	char		*P, *P1;
	char		c, c1, quote;

	Cfile		*fileP, *last_fileP;
	int			last_lineno, load;

	ret = load_assembler(assemblerP);
	if (ret) {
		return(ret);
	}

	// Remove comments from assembler
	// Remove needless blanks

	++g_read;
	quote = 0;
	for (atP = P = startP = m_assemblerP; (c = *atP); ++atP) {
		if (quote) {
			switch (c) {
			case 0:
				fprintf(stderr, "** Line %d: unterminated quote in %s\n", g_stdin_lineno, assemblerP);
				return -1;
			case '\n':
				fprintf(stderr, "** Line %d: quoted newline character in %s\n", g_stdin_lineno, assemblerP);
				return -1;
			case '\'':
			case '"':
				if (quote == c) {
					quote = 0;
				}
				break;
			case '\\':
				c = *(++atP);
				switch (c) {
				case 0:
				case '\n':
					// Ignore the backslash
					--atP;
					continue;
				}
				*P++ = '\\';
				break;
			}
		} else {
			switch (c) {
			case '\r':
				if (atP[1] == '\n') {
					continue;
				}
				c = '\n';
				goto end_of_line;
			case ';':
				if (!strcmp(atP, "; File") || !strcmp(atP, "; Line")) {
					break;
				}
				if (atP[1] == ' ' && ((c1 = atP[2]) >= '0' && c1 <= '9')) {
					// This is a line number when source is included
					break;
				}
				atP = strchr(atP, '\n');
				c   = *atP;
			case '\n':
end_of_line:
				if (P > startP && P[-1] == ' ') {
					--P;
				}
				break;
			case '\t':
				c = ' ';
			case ' ':
				if (P > startP && ((c1 = P[-1]) == ' ' || c1 == ',')) {
					continue;
				}
				break;
			case ',':
				if (P > startP && P[-1] == ' ') {
					--P;
				}
				break;
			case '\\':
				c = *(++atP);
				switch (c) {
				case 0:
				case '\n':
					// Ignore the backslash
					--atP;
					continue;
				}
				*P++ = '\\';
				break;
			case '/':
				if (atP[1] == '*') {
					for (atP += 2; ; ++atP) {
						switch (*atP) {
						case 0:
							atP  -= 2;
							break;
						case '*':
							if (atP[1] == '/') {
								++atP;
								break;
							}
						default:
							continue;
						}
						break;
					}
					continue;
				}
				break;
			case '"':
			case '\'':
				quote = c;
		}	}
		*P++ = c;
	}	
	*P = 0;
	m_assembler_size = P - startP;

	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;

	functionP   = 0;
	functionsPP = &m_functionsP;


	// Now count labels and assembler lines
	// and then load these

	labels_seen = 0;
	codes_seen  = 0;

	for (load = 0; ; ) {
		const_seg     = 0;
		text_seg      = 0;
		function_seen = 0;
		lineno        = 0;
		for (atP = startP; ; ) {
			switch (c = *atP++) {
			case 0:
				goto end_of_file;
			case 'C':
				if (!strncmp(atP, "ONST ", 5)) {
					P = atP + 5;
					if (!strncmp(P, "SEGMENT", 7)) {
						const_seg = 1;
					} else if (!strncmp(P, "ENDS", 4)) {
						const_seg = 0;
					} else {
						assert(0);
				}	}
				break;
			case '_':
				if (!strncmp(atP, "TEXT ", 5)) {
					P = atP + 5;
					if (!strncmp(P, "SEGMENT", 7)) {
						text_seg = 1;
					} else if (!strncmp(P, "ENDS", 4)) {
						text_seg = 0;
					} else {
						assert(0);
					}
					break;
				}
				if (!text_seg) {
					break;
				}
			case '?':
				if (const_seg || text_seg) {
					for (P = atP; label_char[(int) (c = *P)]; ++P);
					if (c == ' ') {
						if (strncmp(P, " PROC", 5)) {
							if (!load) {
								++labels_seen;
							} else {
								*P++            = 0;
								labelP->labelP  = atP;
								labelP->lineno  = codeP - m_codesP;
								if (const_seg) {
									labelP->stringP = P;
									labelP->lth     = convert_to_string(&P, &lineno);
									++labelP;
									atP = P;
							}	}
						} else if (text_seg) {
							function_seen = 1;
							if (load) {
								if (functionP) {
									lth = functionP->m_end_code - functionP->m_start_code;
									if (lth > g_max_function_lth) {
										g_max_function_lth = lth;
								}	}
								functionP = new Cfunction(atP, this);
								if (!functionP) {
									outofmemory();
								}
								functionP->m_start_code = codeP - m_codesP;
								functionP->m_end_code   = functionP->m_start_code;
								*functionsPP            = functionP;
								functionsPP             = &(functionP->m_nextP);
							}
				}	}	}
				break;
			case '$':
				if (text_seg) {
					for (P = atP; label_char[(int) (c = *P)]; ++P);
					if (c == ':') {
						if (!load) {
							++labels_seen;
							++P;
						} else {
							*P++            = 0;
							labelP->labelP  = atP;
							labelP->lineno  = codeP - m_codesP;
							labelP->stringP = 0;
							++labelP;
						}
						atP = P;
				}	}
				break;
			case ';':
				if (load) {
					if (!strncmp(atP, "; File ", 7)) {
						for (P = atP + 7; *P == ' '; ++P);
						P1  = strchr(P, '\n');
						c   = *P1;
						*P1 = 0;
						fileP  = Cfile::locate(P);
						*P1 = c;
					} else if (!strncmp(atP, "; Line ", 7)) {
						for (P = atP + 7; *P == ' '; ++P);
						source_lineno = strtol(P, &P1, 10);
						if (functionP && functionP->m_source_lineno < 0 && fileP == m_fileP) {
							functionP->m_source_lineno = source_lineno;
						}
					} else if (atP[1] == ' ' && atP[2] >= '0' && atP[2] <= '9') {
						// Linenumber in the show source format
						source_lineno = strtol(atP + 2, &P1, 10);
						if (functionP && functionP->m_source_lineno < 0 && fileP == m_fileP) {
							functionP->m_source_lineno = source_lineno;
				}	}	}
				break;
			case ' ':
				if (!text_seg) {
					if (load && !const_seg && !m_fileP && !strncmp(atP, "TITLE ", 6)) {
						for (P = atP+6; *P == ' '; ++P);
						P1  = strchr(P, '\n');
						c   = *P1;
						*P1 = 0;
						set_filename(P);
						fileP = m_fileP;
						*P1   = c;
						atP   = P1;
					}
					break;
				}
				if (!function_seen) {
					break;
				}
				c = *atP;
				if (c < 'a' || c > 'z') {
					break;
				}
				if (!load) {
					++codes_seen;
					break;
				}
				memset(codeP, 0, sizeof(codeT));
				codeP->m_functionP     = functionP;
				codeP->m_fileP         = fileP;
				codeP->m_source_lineno = source_lineno;
				codeP->m_codeP         = atP;
				P                      = strchr(P, '\n');
				*P                     = 0;
				atP                    = P+1;
				++codeP;
				functionP->m_end_code  = (codeP - m_codesP);
					
				if (linenosP) {
					*linenosP++ = lineno;
				}
			case '\n':
				++lineno;
				continue;
			}
			atP = strchr(atP,'\n');
			if (!atP) {
				break;
			}
			++atP;
			++lineno;
		}
end_of_file:
		if (load) {
			break;
		}
		++load;
	
		allocate_codes(codes_seen);
		codeP      = m_codesP;
		linenosP   = m_code_linenosP;
		end_codesP = codeP + codes_seen;

		if (g_labels_cnt < labels_seen) {
			Xfree(g_labelsP);
			g_labelsP = (labelT *) Xmalloc((labels_seen + 1) * sizeof(labelT));
			if (!g_labelsP) {
				outofmemory();
			}
			g_labels_cnt = labels_seen;
		}
		labelP        = g_labelsP;
		source_lineno = 0;
		lineno        = 0;
		assert(!const_seg);
		assert(!text_seg);
		const_seg     = 0;
		text_seg      = 0;
		atP           = startP;
	}

	if (functionP) {
		lth = functionP->m_end_code - functionP->m_start_code;
		if (lth > g_max_function_lth) {
			g_max_function_lth = lth;
	}	}
	labelP->labelP = 0;
	assert(labelP - g_labelsP == labels_seen);
	m_codes = codeP - m_codesP;
	assert(m_codes <= codes_seen);
	end_codesP  = codeP;

	for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
		atP = codeP->m_codeP;
		if (*atP != 'j') {
			P = strchr(atP, '?');
			if (P && label_char[(int) *++P] > 1) {
				labelP = find_label(P);
				if (labelP && labelP->stringP) {
					lth  = strlen(labelP->labelP);
					lth1 = labelP->lth;
					if (lth1 <= lth) {
						memcpy(P, labelP->stringP, lth1);
						P += lth1;
						if (lth1 < lth) {
							strcpy(P, P + lth - lth1);
						}
					} else {
						segment = strlen(atP);
						codeP->m_codeP = P1 = (char *) Xmalloc(segment + lth1 - lth + 1);
						if (!P1) {
							outofmemory();
						}
						lth2 = P - atP;
						memcpy(P1, atP, lth2);
						P1 += lth2;
						memcpy(P1, labelP->stringP, lth1);
						P1 += lth1;
						strcpy(P1, P + lth);
			}	}	}		
		} else {
			for (++atP; (c = *atP) && c != ' '; ++atP);
			if (!c) {
				assert(0);
				continue;
			}
			for (++atP; (c = *atP) && c == ' '; ++atP);
			if (!c) {
				assert(0);
				continue;
			}
			labelP = find_label(atP);
			if (labelP) {
				// Make jump relative
				// Otherwise this is something like jmp *%eax
				codeP->m_jumpP       = m_codesP + labelP->lineno;
	}	}	}

	// Do after any name changing
	if (!g_match_lines) {
		for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
			hash_assembler(codeP);
		}
	} else {
		last_fileP  = 0;
		last_lineno = 0;
		for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
			if ((fileP = codeP->m_fileP)) {
				if (fileP == last_fileP) {
					if (codeP->m_source_lineno == last_lineno) {
						continue;
					}
				} else {
					last_fileP = fileP;
			}	}
			last_lineno = codeP->m_source_lineno;
			hash_assembler(codeP);
	}	}
#ifdef DEBUG_HASH
	dump_hash();
#endif
	return 0;
}

#if 0
extern int	g_skip_compile;
extern int	g_unlink;
extern int	g_verbose;
extern int	g_stdin_lineno;
extern char	**g_envPP;

#include <process.h>

static int
call_cc(char *argv[])
{
	int		ret;
	int 	i;
	char	*P;

	if (g_verbose) {
		fprintf(stderr, "%4d: ", g_stdin_lineno);
		for (i = 0; (P = argv[i]); ++i) {
			fputs(P, stderr);
			fputc(' ', stderr);
		}
		fputc('\n', stderr);
	}
	
	ret = _spawnvpe(_P_WAIT, argv[0], argv+1, g_envPP);
	if (ret) {
		if (!g_verbose) {
			for (i = 0; P = argv[i]; ++i) {
				fputs(P, stderr);
				fputc(' ', stderr);
		}	}
		fprintf(stderr, "returned %d\n", ret);
	} 
	return(ret);
}

#define SUFFIX_s 	0
#define SUFFIX_S    1
#define SUFFIX_c 	2
#define SUFFIX_C 	3
#define SUFFIX_cc 	4
#define SUFFIX_cxx	5
#define SUFFIX_cpp	6
#define SUFFIX_cpp1 7
#define SUFFIX_none 8

/* Must agree with SUFFIX_* */

static const char *suffixes[] =
{
	"s",
	"S",
	"c",
	"C",
	"cc",
	"cxx",
	"cpp",
	"c++",
	0
};

static int
process_command(int argc2, char **argv1P)
{
	extern int	g_compiled_ok;
	extern int	g_compiled_bad;

	static char	filename1[1024];
	static char	*compilePP[2048];

	struct stat	source_stat;
	struct stat assembler_stat;

	int			compile;

	char 	*programP, *compileP, *targetP, *assemblerP, *absolute_pathP;
	char	*P, *P1;
	const char	*suffixP;
	int		i, suffix, unlink_me, lth, ret, argc1;
	int		seen_dash_S, seen_dash_E, running_as, skip_compile;
	int		c2;
	Csource	*sourceP;

	/* Find the source and target files */

	seen_dash_S = 0;
	seen_dash_E = 0;
	targetP     = 0;
	assemblerP  = 0;
	compile     = 0;
	running_as  = 0;
	skip_compile= g_skip_compile;
	programP    = argv1P[0];
	lth         = strlen(programP);
	if (lth > 3) {
		if (!strcmp(programP+lth-3, "/as")) {
			running_as = 1;
		} else if (lth > 4 && !strcmp(programP+lth-4, "/gas")) {
			running_as = 1;
	}	}
	
	if (running_as) {
		for (argc1 = i = 1; (P = argv1P[argc1]); ++argc1) {
			if (argc1 >= argc2) {
				fprintf(stderr, "** lineno %d: Can't scan args for %s\n", g_stdin_lineno, programP);
				return(-1);
			}
			if (*P != '-') {	
				if (!strcmp(P, "/dev/null")) {
					return(0);
				}
				compilePP[compile++] = P;
				continue;		// Discard (to add back in later)
			}
			switch(P[1]) {
			case '-':
				if (!strcmp(P,"--defsym")) {
					++argc1;	// Discard two arguments
				}
				continue;
			case 'I':
			case 'o':
				if (!P[2]) {
					++argc1;
				}
			case 'a':
			case 'D':
			case 'f':
			case 'g':
			case 'J':
			case 'K':
			case 'L':
			case 'n':
			case 'R':
			case 'v':
			case 'W':
			case 'w':
			case 'x':
			case 'Z':
				continue;
			}
			fprintf(stderr, "** Line %d: Unknown %s option '%s'\n", g_stdin_lineno, programP, P);
			goto bad;
		}
	} else {
		for (argc1 = i = 1; (P = argv1P[argc1]); ++argc1) {
			if (argc1 >= argc2) {
				fprintf(stderr, "** lineno %d: Can't scan args for %s\n", g_stdin_lineno, programP);
				return(-1);
			}
			if (*P != '-') {	
				if (!strcmp(P, "/dev/null")) {
					return(0);
				}
				compilePP[compile++] = P;
				continue;		// Discard (to add back in later)
			}
			c2 = P[2];
			switch(P[1]) {
			case 'a':
				if (!strcmp(P, "-aux-info")) { 		// Discard 2 args
					++argc1;
					continue;
				}
			case 'B':
			case 'n':
			case 't':
			case 'Y':
				argv1P[i++] = P;
				continue;
			case 'f':
				// Need frame pointers for dwarf
				if (strcmp(P,"-fomit-frame-pointer")) {
					argv1P[i++] = P;
				}
				continue;
			case 'D':
			case 'I':
			case 'U':
				if (!c2) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'b':
				if (!c2) {
					++argc1;						// Discard 2 args
					continue;
				}
				argv1P[i++] = P;
			case 'c':
			case 'C':
			case 'g':
			case 'h':
			case '-':
			case 'M':
			case 'O':
			case 'P':
			case 'Q':
			case 'r':
			case 'v':
			case 'w':
			case 'l':
			case 'L':
				continue;							// Discard
			case 'd':
				if (c2 == 'D' || c2 == 'I' || c2 == 'M' || c2 == 'N') {
					argv1P[i++] = P;
				}
				continue;
			case 'E':
				if (!c2) {
					seen_dash_E = 1;
					continue;
				}
				argv1P[i++] = P;
				continue;
			case 'G':
			case 'm':
				if (!c2) {
					++argc1;
				}
				continue;
			case 'i':
				if (!strcmp(P, "-idirafter")     ||
					!strcmp(P, "-imacros")       ||
					!strcmp(P, "-include")       ||
					!strcmp(P, "-iprefix")       ||
					!strcmp(P, "-iwithprefix")   ||
					!strcmp(P, "-isystem")) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'o':	// <file>
				if (!c2) {
					targetP = argv1P[++argc1];	// Discard parameter
					continue;
				}
				targetP = P + 2;
				continue;
			case 'p':
				if (strcmp(P, "-print")) {		// Not -print
					argv1P[i++] = P;
				} else {
					if (!strcmp(P, "-print-file-name")) {
						return(0);
				}	}
				continue;
			case 'S':
				if (!c2) {
					seen_dash_S = 1;
					continue;	
				}
				break;
			case 's':
				if (!strcmp(P, "-std")) {
					argv1P[i++] = P;
				}
				continue;
			case 'u':
			case 'V':
				if (!c2) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'W':
				if (!strcmp(P, "-Wp,")) {
					if (!strcmp(P, "-Wp,-M")) {
						argv1P[i++] = P;
				}	}
				continue;
			case 'x':
				if (c2) {
					argv1P[i++] = P;
					continue;
				}
			case 'X':
				argv1P[i++] = P;
				argv1P[i++] = argv1P[++argc1];
				continue;
			case '#':
				if (!strcmp(P, "-###")) {
					continue;
				}
				break;
			}
			/* If the compiler was not compiling we shouldn't */
			fprintf(stderr, "** Line %d: Unknown compiler option '%s'\n", g_stdin_lineno, P);
			goto bad;
		}
	}

	argc1 = i;

	compilePP[compile] = 0;

	if (seen_dash_S) {
		assemblerP = targetP;
	}

	for (compile = 0; (compileP = compilePP[compile]); ++compile) {
		P1 = strrchr(compileP, '.');
		if (!P1) {
			suffix = SUFFIX_none;
		} else {
			++P1;
			for (suffix= 0;; ++suffix) {
			
				if (!(suffixP = suffixes[suffix])) {
					goto next_command;
				}
				if (!strcmp(P1, suffixP)) {
					break;
		}	}	}
	
		unlink_me  = 0;
		if (suffix == SUFFIX_S && running_as) {
			suffix = SUFFIX_s;
		}
		switch (suffix) {
		case SUFFIX_cxx:
		case SUFFIX_cpp:
		case SUFFIX_cpp1:
		case SUFFIX_c:
		case SUFFIX_C:
		case SUFFIX_cc:
			if (seen_dash_E) {
				goto next_command;
			}
		case SUFFIX_S:
			if (!assemblerP) {
				lth = P1-compileP;
				memcpy(filename1, compileP, lth);
				strcpy(filename1+lth, "s");
				assemblerP = filename1;
			}
			argv1P[argc1++] = compileP;
			argv1P[argc1]   = 0;
			argv1P         -= 4;
			argv1P[0]       = argv1P[4];
			argv1P[1]       = "-o";
			argv1P[2]       = assemblerP;
			argv1P[3]       = "-g";
			if (suffix == SUFFIX_S) {
				argv1P[4]   = "-E";
			} else {
				argv1P[4]   = "-S";
			}
		
			if (g_unlink || skip_compile) {
				if (_access(assemblerP, F_OK)) {
					// Looks like file does not exist
					unlink_me    = g_unlink;
					skip_compile = 0;
				} else if (skip_compile) {
					if (!_access(compileP, F_OK)) {
						// Looks like the source exists
						if (stat(compileP, &source_stat) ||
                            stat(assemblerP, &assembler_stat) ||
							source_stat.st_mtime >= assembler_stat.st_mtime) {
							skip_compile = 0;
			}	}	}	}
	
			if (!skip_compile) {
				ret = call_cc(argv1P);
				if (ret) {
					++g_compiled_bad;
					fprintf(stderr, "** Line %d: Failed to compile %s\n", g_stdin_lineno, compileP);
					unlink_me = 0;
					goto next_command;
				}
				++g_compiled_ok;
			}
			goto read_assembler;
	
		case SUFFIX_s:
			assemblerP     = compileP;
read_assembler:
			absolute_pathP = absolute_path(compileP);
			sourceP        = new Csource();
			if (!sourceP) {
				outofmemory();
				goto bad;
			}
			sourceP->set_filename(absolute_pathP);
	
			absolute_pathP = absolute_path(assemblerP);
			if (sourceP->load(absolute_pathP)) {
				goto next_command;
			}
	
			if (!unlink_me) {
				break;
			}
	
			unlink_me = 0;
	
			/* Sanity checks follow */
			if (assemblerP != filename1) {
				break;
			} 
			lth = strlen(assemblerP);
			if (lth < 3 || assemblerP[lth-2] != '.' || assemblerP[lth-1] != 's') {
				fprintf(stderr, "Line %d: May not delete %s\n", g_stdin_lineno, assemblerP);
				error_exit(5);
				goto bad;
			}
	
			/* Discard this assembly file when done */
	
			if (_unlink(assemblerP)) {
				fprintf(stderr, "Line %d: Can't delete %s\n", g_stdin_lineno, assemblerP);
				perror("");
				break;
			}
			break;
		}
next_command:
		continue;
	}
	return(0);
bad:
	return(-1);
}

void
read_assembler(char *commandP)
{
	Csource	*sourceP;

	sourceP = new Csource();

// Leave room for -g -S -o filename
#define ExtraSlots 4

	static char	*argv1[2048];
	char	**argv1P;
	char	*startP, *endP, *nextP;
	int		i, c;

	argv1P = argv1 + ExtraSlots;
	startP = commandP;
	if (*startP != '"') {
		fprintf(stderr, "** Line %d: Missing cwd start '\"' >%s\n", g_stdin_lineno, startP);
		return;
	}

	for (i = -1; startP; ++i) {
		for (endP = nextP = ++startP; (c = *nextP) != '"'; ++nextP) {
			switch (c) {
			case 0:
				fprintf(stderr, "** Line %d: Missing end '\" >%s'\n", g_stdin_lineno, startP);
				return;
			case '\\':
				c = *(++nextP);
			default:
				*endP++ = c;
		}	}
		*endP = 0;
		if (i < 0) {
			cwdP = startP;
			if (_chdir(cwdP)) {
				fprintf(stderr,"** Line %d: Can't change directory to %s\n", g_stdin_lineno, cwdP);
				perror("");
				return;
			}
		} else {
			argv1P[i] = startP;
		}
		startP = strchr(nextP+1, '"');
	}
	if (i < 1) {
		fprintf(stderr, "** Line %d: Missing cmd '\" >%s'\n", g_stdin_lineno, commandP);
		return;
	}
	argv1P[i]   = 0;

	process_command(i, argv1P);
}
#endif

void
read_assembler(char *commandP)
{
	Csource	*sourceP;

	sourceP = new Csource();
	if (!sourceP) {
		outofmemory();
	}
	sourceP->load(commandP);
}
#endif

