#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#define alloca _alloca
#endif

// #define DEBUG_HASH

#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef WIN32
#include <io.h>
#include <direct.h>

#define open _open
#define read _read
#define close _close
#define O_RDONLY _O_RDONLY
#else
#include <unistd.h>
#include <fcntl.h>

#define _O_BINARY 0
#endif
#include <stdlib.h>

#include "util.h"
#include "xmalloc.h"
#include "object.h"
#include "label.h"
#include "location.h"
#include "dwarf.h"
#include "file.h"
#include "fileref.h"
#include "code.h"
#include "function.h"
#include "directory.h"
#include "source.h"

#ifdef WIN32
#define read _read
#endif

#if 0
#define HASH_SIZE 0x100000

#ifdef DEBUG_HASH
static codeT	*hash_table[HASH_SIZE] = {0};
#endif

static codeT	**hash_tailPP[HASH_SIZE] = {0};

static void
hash_assembler(codeT *codeP)
{
	char		*P;
	int			hash;
	int			c;
	codeT		**hashPP;

	hash = 0;
	P    = codeP->m_codeP;
	if (P) {
		if (*P == 'j') {
			for (; (c = *P) && c != ' '; ++P) {
				hash <<= 1;
				hash  ^= *P;
			}
		} else {
			for (; (c = *P); ++P) {
				hash <<= 1;
				hash  ^= *P;
		}	}
		hash &= (HASH_SIZE - 1);
	}
	
	if ((hashPP = hash_tailPP[hash])) {
		*hashPP = codeP; 
	}
#ifdef DEBUG_HASH
  	  else {
		hash_table[hash] = codeP;
	}
#endif

	hash_tailPP[hash] = &(codeP->m_hashP);
}
#endif

#ifdef DEBUG_HASH
static void
dump_hash(void)
{
	codeT *codeP;
	int i;

	for (i = 0; i < HASH_SIZE; ++i) {
		if ((codeP = hash_table[i])) {
			fprintf(stderr, "%d: ", i);
			for (; codeP; codeP = codeP->m_hashP) {
				fprintf(stderr, "%s/", codeP->m_codeP);
			}
			fprintf(stderr, "\n");
	}	}
	fprintf(stderr, "End of hash\n");
}
#endif

Csource			*Csource::g_headP     = 0;
Csource			*Csource::g_tailP     = 0;

extern	int		g_use_frame_address;
extern	int		g_match_lines;
extern	int		g_max_function_lth;
extern	int		g_read;
extern	int		g_hypertext_cnt;
extern	FILE 	*taF;
extern	FILE	*tempF;

/* Source is preserved in the order visited */

Csource::Csource(void)
{
	static int	number = 0;

	memset(this, 0, sizeof(Csource));
	m_number         = number++;
}

void
Csource::set_filename(char *nameP)
{
	m_fileP = Cfile::locate(nameP);
	if (taF) {
		m_parentP = Cdirectory::locate(nameP);
}	}

extern int	g_stdin_lineno;
extern char	*g_clics_file1P;

int
Csource::load_assembler(char *assemblerP)
{
	struct stat buf;
	int			fileno;
	int			ret, lth, segment, lineno;
	char		*startP, *atP, *endP;
	int			*offsetsP;

	if (g_clics_file1P) {
		m_assembler_fileP = dupstring(assemblerP);
	}
	fileno = open(assemblerP, O_RDONLY | _O_BINARY, 0);
	if (fileno < 0) {
		fprintf(stderr, "Line %d: Can't open %s\n", g_stdin_lineno, assemblerP);
		perror("");
		return -1;
	}
	// We have to scan the input more than once so read the entire input
	// into memory

	ret = fstat(fileno, &buf);
	if (ret != 0) {
		fprintf(stderr,"** Line %d: fstat %s returned %d\n", g_stdin_lineno, assemblerP, ret);
		perror("");
		goto bad_source;
	}

	// Allocate a large enough memory buffer

	lth = buf.st_size;
	if (!lth) {
		fprintf(stderr, "** Line %d: %s is empty\n", g_stdin_lineno, assemblerP);
		goto bad_source;
	}

	m_assemblerP     = atP = startP = (char *) Xmalloc(lth + 2);
	if (!startP) {
		outofmemory();
	}
	m_assembler_size = lth;
	
	// Read the assembler into memory

	for (endP = atP + lth; atP < endP; atP += ret) {
		segment = endP - atP;
		if (segment > SSIZE_MAX) {
			segment = SSIZE_MAX;
		}
		ret = read(fileno, atP, segment);
		if (ret <= 0) {
			fprintf(stderr, "** Line %d: read %s returned %d\n", g_stdin_lineno, assemblerP, ret);
			perror("");
bad_source:
			close(fileno);
			return -1;
	}	}
	assert(atP == endP);
	if (atP[-1] != '\n') {
		*endP++ = '\n';
	}
	*endP = 0;
	close(fileno);

	if (g_clics_file1P) {
		lineno = 0;
		for (atP = startP; (atP = strchr(atP, '\n')); ++atP) {
			++lineno;
		}
		if (!(offsetsP = (int *) Xmalloc((lineno + 2) * sizeof(int)))) {
			outofmemory();
		}
		*offsetsP++     = lineno;
		m_line_offsetsP = offsetsP;
		lineno = 0;
		for (atP = startP; ;) {
			offsetsP[lineno++] = atP - startP;
			atP = strchr(atP, '\n');
			if (!atP) {
				break;
			}
			atP++;
	}	}
	return(0);
}

void
Csource::allocate_codes(int codes_seen)
{
	if (!(m_codesP  = (codeT *) Xmalloc(codes_seen * sizeof(codeT)))) {
		outofmemory();
	}
	m_codes   = codes_seen;

	if (g_clics_file1P) {
		if (!(m_code_linenosP = (int *) Xmalloc(codes_seen * sizeof(int)))) {
			outofmemory();
}	}	}

Cfileref *
Csource::locate_fileref(int number) const
{
	Cfileref	*filerefP;

	for (filerefP = m_filerefsP; filerefP; filerefP = filerefP->m_nextP) {
		if (filerefP->m_number == number) {
			break;
	}	}
	return(filerefP);
}

void
Csource::emit_ta(void) const
{
	Cdirectory	*parentP;
	char		*nameP, *P;

	parentP = m_parentP;

	if (parentP) {
		// Making the count 2 causes automatic directory to treat as must
		// not be collapsed
		parentP->has_clones(2);
	}
	fprintf(taF, "$INSTANCE S%p S\n", this);
	if (parentP) {
		fprintf(taF, "contain D%p S%p\n", parentP, this);
	}
	nameP = m_fileP->m_nameP;
	P     = strrchr(nameP, '/');
	if (P && P[1]) {
		nameP = P+1;
	}
	fprintf(tempF, "S%p {label=\"%s\" file=\"./%s\"}\n", this, nameP, nameP);
}

