
class Cfileref;
class Cfunction;
class Cdirectory;

class Csource : public Cobject {
public:
	static Csource	*g_headP;		// Linked list of sources
	static Csource	*g_tailP;
	Csource			*m_nextP;

	int				m_number;
	int				m_assembler_size;
	char			*m_assemblerP;	// Assembler source

	int				m_codes;
	codeT			*m_codesP;		// Pcodes extracted from source
	int				*m_line_offsetsP;
	int				*m_code_linenosP;

	Cfunction		*m_functionsP;	// Linked list of functions
	Cfileref		*m_filerefsP;	// Linked list of filerefs
	Cfile			*m_fileP;		// File for this source
	char			*m_assembler_fileP;
	Cdirectory		*m_parentP;		// Directory containing this source
	int				m_has_clones;	// 0 if no clones under this

	unsigned int	m_source_cnt;	// HTML page number for this source

	Csource(void);
	void			set_filename(char *nameP);
	Cfileref		*locate_fileref(int number) const;
	int				load_assembler(char *assemblerP);
	void			allocate_codes(int codes_seen);

	int				load(char *assemblerP);	// Loads the assembler
	void			emit_ta(void) const;

};



