#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <malloc.h>
#include <stdio.h>
#include "xmalloc.h"
#include "util.h"

void
outofmemory(void)
{
	fprintf(stderr, "Out of memory\n");
	error_exit(4);
}

#ifdef TEST_MALLOC

#include <assert.h>
#include <string.h>

#define MARKER 654321
#define TRAILER "xmalloc"

unsigned int	g_memory = 0;

void *
xmalloc2(unsigned int size, char *fileP, int lineno)
{
	headerT			*headerP;

	assert(size >= 0);
	headerP = (headerT *) malloc(sizeof(headerT) + size + 8);
	if (!headerP) {
		return(0);
	}
	g_memory         += size;
	headerP->fileP    = fileP;
	headerP->lineno   = lineno;
	headerP->trailerP = (char *) (headerP+1) + size;
	headerP->marker   = MARKER;
	strcpy(headerP->trailerP, TRAILER);
	return(headerP+1);
}

void *
xrealloc2(void *oldP, unsigned int size, char *fileP, int lineno)
{
	headerT	*headerP;

	assert(size >= 0);
	if (!oldP) {
		headerP   = (headerT *) oldP;
	} else {
		headerP   = ((headerT *) oldP)-1;
		g_memory -= headerP->trailerP - (char *) oldP;
		if (headerP->marker != MARKER) {
			fprintf(stderr, "xrealloc2: marker corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		if (strcmp(headerP->trailerP, TRAILER)) {
			fprintf(stderr, "xrealloc2: trailer corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		strcpy(headerP->trailerP, "bad1");
	}

	headerP   = (headerT *) realloc(headerP, sizeof(headerT) + size + 8);
	if (!headerP) {
		return(0);
	}
	g_memory         += size;
	headerP->fileP    = fileP;
	headerP->lineno   = lineno;
	headerP->trailerP = (char *) (headerP+1) + size;
	headerP->marker   = MARKER;
	strcpy(headerP->trailerP, TRAILER);
	return(headerP+1);
}

void
xfree2(void **oldPP)
{
	headerT	*headerP;
	void	*oldP;

	if ((oldP = *oldPP)) {
		headerP = ((headerT *) oldP) - 1;
		if (headerP->marker != MARKER) {
			fprintf(stderr, "xfree2: marker corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		if (strcmp(headerP->trailerP, TRAILER)) {
			fprintf(stderr, "xrealloc2: trailer corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		strcpy(headerP->trailerP, "bad2");
		g_memory -= headerP->trailerP - (char *) oldP;

		free(headerP);
		*oldPP = 0;
}	}

#else

void *
xmalloc1(unsigned int size)
{
	void *P;

	P = malloc(size);
	return(P);
}

void *
xrealloc1(void *oldP, unsigned int size)
{
	void *P;

	P = realloc(oldP, size);
	return(P);
}

void
xfree1(void **oldPP)
{
	free(*oldPP);
	*oldPP = 0;
}

#endif
