void outofmemory(void);

#ifndef NDEBUG
//#define XCHECK
//#define TEST_MALLOC
//#define MALLOC_CHECK_ 2
#endif

#ifdef TEST_MALLOC

typedef struct {
	char		*trailerP;
	char		*fileP;
	int			lineno;
	int			marker;
} headerT;

void *xmalloc2(unsigned int size, char *fileP, int lineno);
void *xrealloc2(void *P, unsigned int size, char *fileP, int lineno);
void xfree2(void **PP);

#define Xmalloc(X) xmalloc2(X, __FILE__, __LINE__)
#define Xrealloc(X,Y) xrealloc2(X, Y, __FILE__, __LINE__)
#define Xfree(X) xfree2((void **) &X)

#define Xcheck1(X, L) \
	assert(L == (((headerT *) X)[-1].trailerP - ((char *) X)));

#else

void *xmalloc1(unsigned int size);
void *xrealloc1(void *P, unsigned int size);
void xfree1(void **PP);

#define Xmalloc(X) xmalloc1(X)
#define Xrealloc(X,Y) xrealloc1(X,Y)
#define Xfree(X) xfree1((void **) &X)
#define Xcheck1(X,L)
#endif

#ifdef Xcheck
#define Xcheck(X, L, Y) \
	assert(X); \
	assert(((void *) X) <= ((void *) Y)); \
	XCheck1(X, L); \
	assert(((char *) (Y+1)) <= (((char *) X) + L));
#else
#define Xcheck(X, L, Y)
#endif
