#define _CRT_SECURE_NO_WARNINGS

#include <assert.h>
#include <stdio.h>
#include <string.h>

#ifdef WIN32
#define snprintf _snprintf
#endif

#include "object.h"
#include "util.h"
#include "directory.h"
#include "location.h"
#include "code.h"
#include "file.h"
#include "function.h"
#include "source.h"
#include "clics_output.h"

extern char	*g_clics_fileP;
extern char *g_clics_file1P;
extern char *g_html_dirP;

extern FILE *indexF;
extern FILE	*clicsF;
extern FILE	*clics1F;

void
clics_header(int argc, char **argv)
{
	char	*P;
	int		i, ret;

	if (g_clics_fileP || g_clics_file1P) {
		fprintf(indexF, "<h3>CLICS Output</h3>\n<p>\n");
		if (g_clics_fileP) {
			P = strchr(g_clics_fileP, '/');
			if (!P && g_html_dirP) {
				ret = snprintf(g_filename, FILENAME_MAX, "%s/%s", g_html_dirP, g_clics_fileP);
				if (ret < 0 || FILENAME_MAX <= ret) {
					fprintf(stderr, "Clics filename too long\n");
					error_exit(1);
				}
			
				P = g_filename;
				fprintf(indexF, "<a href=\"%s\">%s</a> (Source)\n<p>\n", g_clics_fileP, g_clics_fileP);
			} else {
				P = g_clics_fileP;
			}
			clicsF = open_file(P);

			fprintf(clicsF, "#ACD Version " VERSION " Compiled " __DATE__ ":"  __TIME__ " Source\n#");
			for (i = 0; i < argc; ++i) {
				fprintf(clicsF,"%s ", argv[i]);
			}
			fputc('\n', clicsF);
		}
		if (g_clics_file1P) {
			P = strchr(g_clics_file1P, '/');
			if (!P && g_html_dirP) {
				ret = snprintf(g_filename, FILENAME_MAX, "%s/%s", g_html_dirP, g_clics_file1P);
				if (ret < 0 || FILENAME_MAX <= ret) {
					fprintf(stderr, "Clics file1 name too long\n");
					error_exit(1);
				}
				P = g_filename;
				fprintf(indexF, "<a href=\"%s\">%s</a> (Assembler)\n<p>\n", g_clics_file1P, g_clics_file1P);
			} else {
				P = g_clics_file1P;
			}
			clics1F = open_file(P);

			fprintf(clics1F, "#ACD Version " VERSION " Compiled " __DATE__ ":"  __TIME__ " Assembler\n#");
			for (i = 0; i < argc; ++i) {
				fprintf(clics1F,"%s ", argv[i]);
			}
			fputc('\n', clics1F);
		}
	}
}

void
clics_sources(void)
{
	Csource	*sourceP;
	Cfile	*fileP;

	if (clicsF) {
		fputs("start{files}\n", clicsF);
		for (sourceP = Csource::g_headP; sourceP; sourceP = sourceP->m_nextP) {
			fileP = sourceP->m_fileP;
			fileP->load_source();
			fprintf(clicsF, "%d\t%d\t%s\n", sourceP->m_number, fileP->m_source_lines, fileP->m_nameP);
		}
		fputs("end{files}\nstart{clones}\n", clicsF);
	}

	if (clics1F) {
		fputs("start{files}\n", clics1F);
		for (sourceP = Csource::g_headP; sourceP; sourceP = sourceP->m_nextP) {
			fprintf(clics1F, "%d\t%d\t%s\n", sourceP->m_number, sourceP->m_line_offsetsP[-1], sourceP->m_assembler_fileP);
		}
		fputs("end{files}\nstart{clones}\n", clics1F);
}	}

static void
dump_clics_clone(codeT *start_codeP, codeT *best_endP)
{
	Cfunction	*functionP;
	Csource		*sourceP;
	Cfile		*fileP;
	char		**sourcePP;
	int			clone_start_lineno, clone_start_offset, clone_end_lineno, clone_end_column, clone_end_offset;
	char		*start_sourceP, *last_charP;

	functionP = start_codeP->m_functionP;
	assert(functionP);
	sourceP   = functionP->m_sourceP;
	assert(sourceP);
	fileP     = sourceP->m_fileP;
	assert(fileP);
	fileP->load_source();
	sourcePP  = fileP->m_sourcePP;
	if (sourcePP == (char **) -1) {
		clone_start_lineno = 0;
		clone_start_offset = 0;
		clone_end_lineno   = 0;
		clone_end_column   = 0;
		clone_end_offset   = 0;
	} else {
		functionP->compute_lineno(start_codeP, best_endP, &clone_start_lineno, &clone_end_lineno);
		start_sourceP      = sourcePP[0];
		assert(clone_start_lineno <= fileP->m_source_lines);
		clone_start_offset = sourcePP[clone_start_lineno] - start_sourceP;
		assert(clone_end_lineno <= fileP->m_source_lines);
		last_charP         = sourcePP[clone_end_lineno] - 1;
		clone_end_offset   = last_charP - start_sourceP;
		--clone_end_lineno;
		clone_end_column   = last_charP - sourcePP[clone_end_lineno]; 
	}
	fprintf(clicsF, "%d\t%d,0,%d\t%d,%d,%d\t", 
		sourceP->m_number, 
		clone_start_lineno, 
		clone_start_offset,
		clone_end_lineno,
		clone_end_column,
		clone_end_offset);
}

static void
dump_clics_clone1(codeT *start_codeP, codeT *best_endP)
{
	Cfunction	*functionP;
	Csource		*sourceP;
	codeT		*codesP;
	int			*linenosP;
	int			lines;
	int			*offsetsP;
	int			offset;
	int			clone_start_lineno, clone_start_offset, clone_end_lineno, clone_end_column, clone_end_offset;

	functionP = start_codeP->m_functionP;
	sourceP   = functionP->m_sourceP;
	codesP    = sourceP->m_codesP;
	linenosP  = sourceP->m_code_linenosP;
	lines     = linenosP[sourceP->m_codes];
	offsetsP  = sourceP->m_line_offsetsP;

	clone_start_lineno = linenosP[start_codeP - codesP];
	assert(0 <= clone_start_lineno);
	assert(clone_start_lineno < lines);
	clone_start_offset = offsetsP[clone_start_lineno];
	offset             = best_endP - codesP;
	clone_end_lineno   = linenosP[offset - 1];
	assert(0 <= clone_end_lineno && clone_end_lineno < lines);
	clone_end_offset   = linenosP[offset] - 1;
	clone_end_column   = clone_end_offset - offsetsP[clone_end_lineno]; 

	fprintf(clics1F, "%d\t%d,0,%d\t%d,%d,%d\t", 
		sourceP->m_number, 
		clone_start_lineno, 
		clone_start_offset,
		clone_end_lineno,
		clone_end_column,
		clone_end_offset);
}

void
clics_entry(codeT *start_code1P, codeT *best_end1P, codeT *start_code2P, codeT *best_end2P)
{
	int weight = best_end1P - start_code1P + best_end2P - start_code2P;

	if (clicsF) {
		dump_clics_clone(start_code1P, best_end1P);
		dump_clics_clone(start_code2P, best_end2P);
		fprintf(clicsF, "%d\n", weight);
	}
	if (clics1F) {
		dump_clics_clone1(start_code1P, best_end1P);
		dump_clics_clone1(start_code2P, best_end2P);
		fprintf(clics1F, "%d\n", weight);
	}
}

void
clics_trailer(void)
{
	if (clicsF) {
		fputs("end{clones}\n", clicsF);
		fclose(clicsF);
	}
	if (clics1F) {
		fputs("end{clones}\n", clics1F);
		fclose(clics1F);
	}
}

