#define _CRT_SECURE_NO_WARNINGS

#include <assert.h>
#include <stdio.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "directory.h"

Cdirectory		*Cdirectory::g_headP     = 0;
Cdirectory		*Cdirectory::g_tailP     = 0;

Cdirectory::Cdirectory(Cdirectory *parentP, const char *nameP)
{
	char	*name1P;

	m_nextP      = 0;
	m_has_clones = 0;
	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;

	m_parentP  = parentP;

	assert(nameP);
	m_nameP = name1P = (char *) Xmalloc(strlen(nameP) + 1);
	if (!name1P) {
		outofmemory();
	}
	strcpy(name1P, nameP);
}

/* Find the directory at the bottom of  the directory path pathP, occuring
 * whose root directory occurs under rootP
 */

Cdirectory *
Cdirectory::locate(char *pathP)
{
	Cdirectory	*leafP;
	char		*dirnameP;
	char		*endP;
	Cdirectory	*fromP;

	leafP    = 0;
	dirnameP = pathP;
descend:
	endP = strchr(dirnameP, '/');
	if (!endP) {
		goto done;
	}
	*endP = 0;
	for (fromP = g_headP; fromP; fromP = fromP->m_nextP) {
		if (fromP->m_parentP == leafP  && !strcmp(fromP->m_nameP, dirnameP)) {
			leafP    = fromP;
			*endP    = '/';
			dirnameP = endP+1;
			goto descend;
	}	}

	// Directory not found

	for (;;) {
		leafP = new Cdirectory(leafP, dirnameP);
		*endP    = '/';
		dirnameP = endP+1;
		endP     = strchr(dirnameP, '/');
		if (!endP) {
			break;
		}
		*endP = 0;
	}
done:
	return(leafP);
}

void
Cdirectory::has_clones(int increment)
{
	Cdirectory	*parentP;


	if (!m_has_clones) {
		m_has_clones = increment;
		parentP      = m_parentP;
		if (parentP) {
			parentP->has_clones(1);
		}
	} else { 
		m_has_clones += increment;
}	}

int
Cdirectory::collapse(char *bufferP) const
{
	const Cdirectory	*parentP;
	const char			*nameP;
	int					lth;

	nameP   = m_nameP;
	parentP = m_parentP;
	if (parentP && parentP->m_has_clones < 2) {
		lth = parentP->collapse(bufferP);
	} else {
		lth = 0;
		if (!nameP) {
			nameP = "";
	}	}
	strcpy(bufferP+lth, nameP);
	lth += strlen(nameP);
	bufferP[lth++] = '/';
	return(lth);
}

void
Cdirectory::emit_ta(void) const
{
	extern FILE	*taF;
	extern FILE *tempF;

	static char	buffer[2048];

	Cdirectory	*parentP;
	const char	*nameP;
	const char	*prefixP;
	int			lth;

	if (m_has_clones < 2) {
		return;
	}

	fprintf(taF, "$INSTANCE D%p D\n", this);

	for (parentP = m_parentP; parentP && parentP->m_has_clones < 2; parentP = parentP->m_parentP);

	nameP = m_nameP;
	if (!*m_nameP) {
		nameP = "/";
	}

	if (parentP) {
		fprintf(taF, "contain D%p D%p\n", parentP, this);
	}
	if (parentP != m_parentP) {
		buffer[sizeof(buffer)-1] = 0;
		lth = m_parentP->collapse(buffer);
		strcpy(buffer+lth, nameP);
		assert(buffer[sizeof(buffer)-1] == 0);
		nameP = buffer;
	}

	if (*nameP == '/') {
		prefixP = "";
	} else {
		prefixP = "./";
	}
	fprintf(tempF, "D%p {label=\"%s\" file=\"%s%s\"}\n", this, nameP, prefixP, nameP);
}
