typedef unsigned long long 	uint64T;
typedef signed   long long 	sint64T;
typedef unsigned int	 	uint32T;
typedef signed   int	 	sint32T;
typedef unsigned short		uint16T;
typedef unsigned char		uint8T;

#ifndef DWARF64
typedef uint32T urefT;
typedef sint32T srefT;
#else
typedef uint64T urefT;
typedef sint64T srefT;
#endif

typedef struct {
	urefT	unit_length;
	uint16T	version;
	urefT	debug_abbrev_offset;
	uint8T	address_size;
} dwarf_headerT;

typedef enum {
	DW_CHILDREN_no =		0x00,
	DW_CHILDREN_yes =		0x01
} dw_childrenE;

typedef enum {
	DW_OP_addr=0x03,
	DW_OP_deref=0x06,
	DW_OP_const1u=0x08,
	DW_OP_const1s=0x09,
	DW_OP_const2u=0x0a,
	DW_OP_const2s=0x0b,
	DW_OP_const4u=0x0c,
	DW_OP_const4s=0x0d,
	DW_OP_const8u=0x0e,
	DW_OP_const8s=0x0f,
	DW_OP_constu=0x10,
	DW_OP_consts=0x11,
	DW_OP_dup=0x12,
	DW_OP_drop=0x13,
	DW_OP_over=0x14,
	DW_OP_pick=0x15,
	DW_OP_swap=0x16,
	DW_OP_rot=0x17,
	DW_OP_xderef=0x18,
	DW_OP_abs=0x19,
	DW_OP_and=0x1a,
	DW_OP_div=0x1b,
	DW_OP_minus=0x1c,
	DW_OP_mod=0x1d,
	DW_OP_mul=0x1e,
	DW_OP_neg=0x1f,
	DW_OP_not=0x20,
	DW_OP_or=0x21,
	DW_OP_plus=0x22,
	DW_OP_plus_uconst=0x23,
	DW_OP_shl=0x24,
	DW_OP_shr=0x25,
	DW_OP_shra=0x26,
	DW_OP_xor=0x27,
	DW_OP_bra=0x28,
	DW_OP_eq=0x29,
	DW_OP_ge=0x2a,
	DW_OP_gt=0x2b,
	DW_OP_le=0x2c,
	DW_OP_lt=0x2d,
	DW_OP_ne=0x2e,
	DW_OP_skip=0x2f,
	DW_OP_lit0=0x30,
	DW_OP_lit1=0x31,
	DW_OP_lit2=0x32,
	DW_OP_lit3=0x33,
	DW_OP_lit4=0x34,
	DW_OP_lit5=0x35,
	DW_OP_lit6=0x36,
	DW_OP_lit7=0x37,
	DW_OP_lit8=0x38,
	DW_OP_lit9=0x39,
	DW_OP_lit10=0x3a,
	DW_OP_lit11=0x3b,
	DW_OP_lit12=0x3c,
	DW_OP_lit13=0x3d,
	DW_OP_lit14=0x3e,
	DW_OP_lit15=0x3f,
	DW_OP_lit16=0x40,
	DW_OP_lit17=0x41,
	DW_OP_lit18=0x42,
	DW_OP_lit19=0x43,
	DW_OP_lit20=0x44,
	DW_OP_lit21=0x45,
	DW_OP_lit22=0x46,
	DW_OP_lit23=0x47,
	DW_OP_lit24=0x48,
	DW_OP_lit25=0x49,
	DW_OP_lit26=0x4a,
	DW_OP_lit27=0x4b,
	DW_OP_lit28=0x4c,
	DW_OP_lit29=0x4d,
	DW_OP_lit30=0x4e,
	DW_OP_lit31=0x4f,
	DW_OP_reg0=0x50,
	DW_OP_reg1=0x51,
	DW_OP_reg2=0x52,
	DW_OP_reg3=0x53,
	DW_OP_reg4=0x54,
	DW_OP_reg5=0x55,
	DW_OP_reg6=0x56,
	DW_OP_reg7=0x57,
	DW_OP_reg8=0x58,
	DW_OP_reg9=0x59,
	DW_OP_reg10=0x5a,
	DW_OP_reg11=0x5b,
	DW_OP_reg12=0x5c,
	DW_OP_reg13=0x5d,
	DW_OP_reg14=0x5e,
	DW_OP_reg15=0x5f,
	DW_OP_reg16=0x60,
	DW_OP_reg17=0x61,
	DW_OP_reg18=0x62,
	DW_OP_reg19=0x63,
	DW_OP_reg20=0x64,
	DW_OP_reg21=0x65,
	DW_OP_reg22=0x66,
	DW_OP_reg23=0x67,
	DW_OP_reg24=0x68,
	DW_OP_reg25=0x69,
	DW_OP_reg26=0x6a,
	DW_OP_reg27=0x6b,
	DW_OP_reg28=0x6c,
	DW_OP_reg29=0x6d,
	DW_OP_reg30=0x6e,
	DW_OP_reg31=0x6f,
	DW_OP_breg0=0x70,
	DW_OP_breg1=0x71,
	DW_OP_breg2=0x72,
	DW_OP_breg3=0x73,
	DW_OP_breg4=0x74,
	DW_OP_breg5=0x75,
	DW_OP_breg6=0x76,
	DW_OP_breg7=0x77,
	DW_OP_breg8=0x78,
	DW_OP_breg9=0x79,
	DW_OP_breg10=0x7a,
	DW_OP_breg11=0x7b,
	DW_OP_breg12=0x7c,
	DW_OP_breg13=0x7d,
	DW_OP_breg14=0x7e,
	DW_OP_breg15=0x7f,
	DW_OP_breg16=0x80,
	DW_OP_breg17=0x81,
	DW_OP_breg18=0x82,
	DW_OP_breg19=0x83,
	DW_OP_breg20=0x84,
	DW_OP_breg21=0x85,
	DW_OP_breg22=0x86,
	DW_OP_breg23=0x87,
	DW_OP_breg24=0x88,
	DW_OP_breg25=0x89,
	DW_OP_breg26=0x8a,
	DW_OP_breg27=0x8b,
	DW_OP_breg28=0x8c,
	DW_OP_breg29=0x8d,
	DW_OP_breg30=0x8e,
	DW_OP_breg31=0x8f,
	DW_OP_regx=0x90,
	DW_OP_fbreg=0x91,
	DW_OP_bregx=0x92,
	DW_OP_piece=0x93,
	DW_OP_deref_size=0x94,
	DW_OP_xderef_size=0x95,
	DW_OP_nop=0x96,
	DW_OP_push_object_address=0x97,
	DW_OP_call2=0x98,
	DW_OP_call4=0x99,
	DW_OP_call_ref=0x9a,
	DW_OP_form_tls_address=0x9b,
	DW_OP_call_frame_cfa=0x9c,
	DW_OP_bit_piece=0x9d,
	DW_OP_lo_user=0xe0,
	DW_OP_hi_user=0xff
} dw_opE;

typedef enum {
	DW_AT_sibling =			0x01,	// reference	
	DW_AT_location =		0x02,	// block, loclistptr
	DW_AT_name = 			0x03,	// string
	DW_AT_ordering =		0x09,	// constant
	DW_AT_byte_size =		0x0b,	// block, constant, reference
	DW_AT_bit_offset =		0x0c,	// block, constant, reference
	DW_AT_bit_size =		0x0d,	// block, constant, reference
	DW_AT_stmt_list =		0x10,	// lineptr
	DW_AT_low_pc =			0x11,	// address
	DW_AT_high_pc =			0x12,	// address
	DW_AT_language =		0x13,	// constant
	DW_AT_discr =			0x15,	// reference
	DW_AT_discr_value =		0x16,	// constant
	DW_AT_visibility =		0x17,	// constant
	DW_AT_import =			0x18,	// reference
	DW_AT_string_length =	0x19,	// block, loclistptr
	DW_AT_common_reference= 0x1a, // reference
	DW_AT_comp_dir =		0x1b,	// string
	DW_AT_const_value =		0x1c,	// block, constant, string
	DW_AT_containing_type =	0x1d,	// reference
	DW_AT_default_value =	0x1e,	// reference
	DW_AT_inline =			0x20,	// constant
	DW_AT_is_optional =		0x21,	// flag
	DW_AT_lower_bound =		0x22,	// block, constant, reference
	DW_AT_producer	=		0x25,	// string
	DW_AT_prototyped =		0x27,	// flag
	DW_AT_return_addr =		0x2a,	// block, loclistptr
	DW_AT_start_scope =		0x2c,	// constant
	DW_AT_bit_stride =		0x2e,	// constant
	DW_AT_upper_bound =		0x2f,	// block, constant, reference
	DW_AT_abstract_origin = 0x31,	// reference
	DW_AT_accessibility =	0x32,	// constant
	DW_AT_address_class =	0x33,	// constant
	DW_AT_artificial =		0x34,	// flag
	DW_AT_base_types =		0x35,	// reference
	DW_AT_calling_convention=0x36, // constant
	DW_AT_count =			0x37,	// block, constant, reference
	DW_AT_data_member_location =0x38, // block, constant, loclistptr
	DW_AT_decl_column =		0x39,	// constant
	DW_AT_decl_file =		0x3a,	// constant
	DW_AT_decl_line =		0x3b,	// constant
	DW_AT_declaration =		0x3c,	// flag
	DW_AT_discr_list =		0x3d,	// block
	DW_AT_encoding =		0x3e,	// constant
	DW_AT_external =		0x3f,	// flag
	DW_AT_frame_base =		0x40,	// block, loclistptr
	DW_AT_friend =			0x41,	// reference
	DW_AT_identifier_case = 0x42,	// constant
	DW_AT_macro_info =		0x43,	// macptr
	DW_AT_namelist_item =	0x44,	// block
	DW_AT_priority =		0x45,	// reference
	DW_AT_segment =			0x46,	// block, loclistptr
	DW_AT_specification =	0x47,	// reference
	DW_AT_static_link =		0x48,	// block, loclistpr
	DW_AT_type =			0x49,	// reference
	DW_AT_use_location =	0x4a,	// block, loclistptr
	DW_AT_variable_parameter=0x4b,	// flag
	DW_AT_virtuality =		0x4c,	// constant
	DW_AT_vtable_elem_location=0x4d, // block, loclistptr
	DW_AT_allocated	=		0x4e,	// block, constant, reference
	DW_AT_associated =		0x4f,	// block, constant, reference
	DW_AT_data_location =	0x50,	// block
	DW_AT_byte_stride =		0x51,	// block, constant, reference
	DW_AT_entry_pc =		0x52,	// address
	DW_AT_use_UTF8 =		0x53,	// flag
	DW_AT_extension =		0x54,	// reference
	DW_AT_ranges =			0x55,	// rangelistptr
	DW_AT_trampoline =		0x56,	// address, flag, reference, string
	DW_AT_call_column =		0x57,	// constant
	DW_AT_call_file =		0x58,	// constant
	DW_AT_call_line =		0x59,	// constant
	DW_AT_description =		0x5a,	// string
	DW_AT_binary_scale =	0x5b,	// constant
	DW_AT_decimal_scale =	0x5c,	// constant
	DW_AT_small =			0x5d,	// reference
	DW_AT_decimal_sign =	0x5e,	// constant
	DW_AT_digit_count =		0x5f,	// constant
	DW_AT_picture_string =	0x60,	// string
	DW_AT_mutable =			0x61,	// flag
	DW_AT_threads_scaled =	0x62,	// flag
	DW_AT_explicit =		0x63,	// flag
	DW_AT_object_pointer =	0x64,	// reference
	DW_AT_endianity =		0x65,	// constant
	DW_AT_elemental =		0x66,	// flag
	DW_AT_pure =			0x67,	// flag
	DW_AT_recursive =		0x68,	// flag

	DW_AT_signature =       0x2007 

} dw_atE;

#define DW_AT_lo_user		0x2000	// --
#define DW_AT_hi_user		0x3fff	// --

typedef enum {
	DW_FORM_null =			0x00,
	DW_FORM_addr =			0x01,	// address
	DW_FORM_block2 =		0x03,	// block
	DW_FORM_block4 =		0x04,	// block
	DW_FORM_data2 =			0x05,	// constant
	DW_FORM_data4 =			0x06,	// constant, lineptr, loclistptr, macptr, rangelistptr
	DW_FORM_data8 =			0x07,	// constant, lineptr, loclistptr, macptr, rangelistptr
	DW_FORM_string =		0x08,	// string
	DW_FORM_block =			0x09,	// block
	DW_FORM_block1 =		0x0a,	// block
	DW_FORM_data1 =			0x0b,	// constant
	DW_FORM_flag =			0x0c,	// flag
	DW_FORM_sdata =			0x0d,	// constant
	DW_FORM_strp =			0x0e,	// string
	DW_FORM_udata =			0x0f,	// constant
	DW_FORM_ref_addr =		0x10,	// reference
	DW_FORM_ref1 =			0x11,	// reference
	DW_FORM_ref2 =			0x12,	// reference
	DW_FORM_ref4 =			0x13,	// reference
	DW_FORM_ref8 =			0x14,	// reference
	DW_FORM_ref_udata =		0x15,	// reference
	DW_FORM_indirect =		0x16	// (see Section 7.5.3)
} dw_formE;

typedef enum {
	DW_TAG_null = 					0x00,
	DW_TAG_array_type =				0x01,
	DW_TAG_class_type =				0x02,
	DW_TAG_entry_point =			0x03,
	DW_TAG_enumeration_type =		0x04,
	DW_TAG_formal_parameter =		0x05,
	DW_TAG_imported_declaration =	0x08,
	DW_TAG_label =					0x0a,
	DW_TAG_lexical_block =			0x0b,
	DW_TAG_member =					0x0d,
	DW_TAG_pointer_type =			0x0f,
	DW_TAG_reference_type =			0x10,
	DW_TAG_compile_unit =			0x11,
	DW_TAG_string_type =			0x12,
	DW_TAG_structure_type =			0x13,
	DW_TAG_subroutine_type =		0x15,
	DW_TAG_typedef =				0x16,
	DW_TAG_union_type =				0x17,
	DW_TAG_unspecified_parameters =	0x18,
	DW_TAG_variant =				0x19,
	DW_TAG_common_block = 			0x1a,
	DW_TAG_common_inclusion =		0x1b,
	DW_TAG_inheritance =			0x1c,
	DW_TAG_inlined_subroutine =		0x1d,
	DW_TAG_module =					0x1e,
	DW_TAG_ptr_to_member_type =		0x1f,
	DW_TAG_set_type =				0x20,
	DW_TAG_subrange_type =			0x21,
	DW_TAG_with_stmt =				0x22,
	DW_TAG_access_declaration =		0x23,
	DW_TAG_base_type =				0x24,
	DW_TAG_catch_block =			0x25,
	DW_TAG_const_type =				0x26,
	DW_TAG_constant =				0x27,
	DW_TAG_enumerator =				0x28,
	DW_TAG_file_type =				0x29,
	DW_TAG_friend =					0x2a,
	DW_TAG_namelist =				0x2b,
	DW_TAG_namelist_item =			0x2c,
	DW_TAG_packed_type =			0x2d,
	DW_TAG_subprogram =				0x2e,
	DW_TAG_template_type_parameter =0x2f,
	DW_TAG_template_value_parameter=0x30,
	DW_TAG_thrown_type =			0x31,
	DW_TAG_try_block =				0x32,
	DW_TAG_variant_part =			0x33,
	DW_TAG_variable =				0x34,
	DW_TAG_volatile_type =			0x35,
	DW_TAG_dwarf_procedure =		0x36,
	DW_TAG_restrict_type =			0x37,
	DW_TAG_interface_type =			0x38,
	DW_TAG_namespace =				0x39,
	DW_TAG_imported_module =		0x3a,
	DW_TAG_unspecified_type =		0x3b,
	DW_TAG_partial_unit =			0x3c,
	DW_TAG_imported_unit =			0x3d,
	DW_TAG_condition =				0x3f,
	DW_TAG_shared_type =			0x40
} dw_tagE;

#define DW_TAG_lo_user				0x4080
#define DW_TAG_hi_user				0xffff

// Schema typedef
typedef struct {
	dw_atE		name;
	dw_formE	form;
} dwarf_abbrev_attrT;

typedef struct dwalf_abbrevS {
	dw_tagE				tag;
	dw_childrenE		children;
	int					attributes;
	dwarf_abbrev_attrT	*attributesP;	// Points to an array terminated by 0,0
} dwarf_abbrevT;

// Tree typedefs

typedef union {
	uint64T			uint64;
	sint64T			sint64;
	uint32T			uint32;
	sint32T			sint32;
	urefT			uref;
	char			*P;		// stringP or (aligned 4byte lth) + block
} dw_valueT;

typedef struct dwalf_attrS {
	struct	dwalf_attrS *next_attrP;
	dw_atE				name;
	dw_formE			form;
	dw_valueT			value;
} dwarf_attrT;

typedef struct dwarf_nodeS {
	dw_tagE				tag;
	int					offset;
	int					attributes;
	dwarf_attrT			*attributesP;	// Array of attributes
	struct dwarf_nodeS	*next_siblingP;
	struct dwarf_nodeS	*first_childP;
} dwarf_nodeT;

class Cdwarf : public Cobject {
public:
	labelT			*m_labelsP;

	dwarf_headerT	m_header;
	unsigned int	m_abbrev_max;		// Maximum abbrev_code
	dwarf_abbrevT	*m_abbrevP;			// Points to an array indexed into by abbrev_code (empty entries have code == 0)
	dwarf_nodeT		*m_nodeP;
	unsigned int	m_depth;
	uint32T			m_strings_lth;
	uint32T			m_strings_max;
	char			*m_stringsP;

	Cdwarf(void);
	~Cdwarf(void);
	int				load_label(char **atPP, urefT *valueP);
	int				load_uint64(char **atPP, uint64T *valueP);
	int				load_uint32(char **atPP, uint32T *valueP);
	int				load_addr(char **atPP, urefT *valueP);
	int				load_uint12(char **atPP, urefT *valueP);
	int				load_block(char **atPP, char **bufferPP, int load, int lth);
	int				load_string_table(labelT *labelsP, char *debug_strP);
	int				load_header(char **atPP);
	int				load_debug_abbrev(char *debug_abbrevP);
	int				load_node(char **atPP, char **bufferPP, dwarf_nodeT **nodePP);
	int				load_debug_info(char *debug_infoP);
	void			load(labelT *labelsP, char *debug_abbrevP, char *debug_infoP, char *debug_strP);
	void			load_locations1(dwarf_nodeT *nodeP, locationT **locationsPP, int load);
	void			load_locations(char *signatureP, char *function_nameP, locationT **locationsPP, int load);
};
