#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <assert.h>
#include <stdio.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <stdlib.h>

#ifndef WIN32
#include "demangle.h"
#endif

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "location.h"
#include "file.h"
#include "code.h"
#include "clone.h"
#include "function.h"
#include "fileref.h"
#include "source.h"

/*
static void trap(void)
{
}
*/

extern int	g_functions;

Cfunction::Cfunction(const char *signatureP, Csource *sourceP)
{
	char	*demangleP;

#ifdef CORRELATE
	m_number        = g_functions;
	m_type          = 0;
#endif
	m_sourceP       = sourceP;
	m_nextP         = 0;
	m_clonesP       = 0;
	m_source_lineno = -1;

	++g_functions;

	if (!signatureP) {
		m_nameP = m_signatureP = 0;
	} else {
		demangleP = 0;
#ifndef WIN32
		if (signatureP[0] == '_') {

			demangleP = cplus_demangle(signatureP, DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3);
		}
#endif
		m_signatureP = dupstring(signatureP);
		if (!demangleP) {
			m_nameP = m_signatureP;
		} else {
			m_nameP = dupstring(demangleP);
		}
	}
}

void
Cfunction::compute_lineno(codeT *startP, codeT *endP, int *P, int *P1)
{
	Csource	*sourceP;
	Cfile	*fileP;
	codeT	*codesP, *codeP;
	codeT	*function_startP;
	int		start, end;

	sourceP = m_sourceP;
	fileP = sourceP->m_fileP;
	start = 0x7FFFFFFF;
	end   = -1;

	for (codeP = startP; codeP < endP; ++codeP) {
		if (codeP->m_fileP == fileP) {
			if (codeP->m_source_lineno < start) {
				start = codeP->m_source_lineno;
			}
			if (codeP->m_source_lineno > end) {
				end = codeP->m_source_lineno;
	}	}	}

	if (end < start) {
		codesP = sourceP->m_codesP;
		codeP  = startP;
		for (function_startP = sourceP->m_codesP + m_start_code; --codeP >= function_startP; ) {
			if (codeP->m_fileP == fileP) {
				start = end = codeP->m_source_lineno;
				break;
		}	}
	
		if (end < start) {
			start = end = m_source_lineno;
	}	}
	*P  = start;
	*P1 = end;	
}

#ifndef WIN32
void 
Cfunction::update_names(int locations, locationT *locationsP, codeT *codesP)
{
	extern	int		g_debug_code;
	extern	int		g_use_temp_address;

	static	int		memory_left = 0;
	static	char	*memoryP    = 0;
	static  int		memory_lth  = 0;
	static	char	*memory1P;
	static	char	buffer[256];

	static	int	temp_addresses     = 0;
	static	int	max_temp_addresses = 0;
	static	int	*temp_addressesP   = 0;

	int			start_code, end_code;
	locationT	*locationP, *end_locationsP;
	codeT		*code1P, *end_codesP;
	char		*P, *startP, *numberP, *nameP, *P1;
	char		c;
	int			state, frame_offset, location_offset, line, need;
	int			frame_adjust;
	int			lth0, lth, lth1, lth2;
	int			*temp_addresses1P;
	int			i, last_lineno;

	start_code = m_start_code;
	end_code   = m_end_code;
	locationP  = locationsP;
	if (g_debug_code) {
		printf("Function %s\n", m_nameP);
	}
	for (end_locationsP = locationP + locations; locationP < end_locationsP; ++locationP) {
		if (locationP->from_address < 0) {
			locationP->from_address = start_code;
		}
		if (locationP->to_address < 0) {
			locationP->to_address   = end_code;
		}
		if (g_debug_code) {
			switch (locationP->type) {
			case LOCATION_parameter:
				printf("par");
				break;
			case LOCATION_variable:
				printf("var");
				break;
			case LOCATION_array_parameter:
				printf("par[]");
				break;
			case LOCATION_array_variable:
				printf("var[]");
				break;
			}
			printf(" %d-%d %%%d %s (size %d)\n",
				locationP->from_address, locationP->to_address,
				locationP->frame_offset, locationP->nameP, locationP->size);
		}
	}

	last_lineno    = 0;
	temp_addresses = 0;
	code1P = codesP + start_code;
	for (end_codesP = codesP + end_code; code1P < end_codesP; ++code1P) {
		if (code1P->m_source_lineno != last_lineno) {
			temp_addresses = 0;
			last_lineno    = code1P->m_source_lineno;
		}
		state  = 0;
		startP = code1P->m_codeP;
		if (startP) {
			// Not a label
			for (P = startP; (c = *P); ++P) {
				switch (c) {
				case '"':
					while ((c = *(++P)) != '"') {
						if (c == '\\') {
							++P;
					}	}
					state = 0;
					break;
				case ' ':
				case ',':
					state = 1;
					break;
				case '-':
					if (state == 1) {
						numberP = P;
						state   = 2;
						break;
					}
					state = 0;
					break;
				case '(':
					if (state != 3) {
						state = 0;
						break;
					}
					state = 0;
					if (!strncmp(P, "(%ebp)", 6)) {
						frame_adjust = 8;
					} else if (!strncmp(P, "(%rbp)", 6)) {
						frame_adjust = -16;
					} else {
						break;
					}

					line  = code1P - codesP;
					if (*numberP == '-') {
						frame_offset = -frame_offset;
					}
					frame_offset += frame_adjust;
					for (locationP = end_locationsP; ; ) {
						if (--locationP < locationsP) {
							// Not found
							if (g_use_temp_address) {
								break;
							}
							// Make up a tempory name
							for (i = 0; ; ++i) {
								if (i >= temp_addresses) {
									if (temp_addresses >= max_temp_addresses) {
										if (!max_temp_addresses) {
											max_temp_addresses = 64;
										} else {
											max_temp_addresses <<= 1;
										}
										temp_addresses1P = (int *) Xmalloc(sizeof(int) * max_temp_addresses);
										if (!temp_addresses1P) {
											outofmemory();
										}
										if (temp_addresses) {
											memcpy(temp_addresses1P, temp_addressesP, sizeof(int) * temp_addresses);
										}
										Xfree(temp_addressesP);
										temp_addressesP = temp_addresses1P;
									}
									temp_addressesP[temp_addresses++] = frame_offset;
									break;
								}
								if (temp_addressesP[i] == frame_offset) {
									break;
							}	}
							sprintf(buffer, "t.%d",i);
							nameP = buffer;
							goto have_name;
						}
	
						location_offset = locationP->frame_offset;
						if (location_offset != frame_offset) {
							if (location_offset > frame_offset) {
								continue;
							}
							if ((location_offset+locationP->size) <= frame_offset) {
								continue;
						}	}
						if (line < locationP->from_address || line > locationP->to_address) {
							continue;
						}
						if (locationP->type == LOCATION_parameter ||
							locationP->type == LOCATION_array_parameter) {
							P[2] += 'A' - 'a';	// Convert to upper case
						}
						if (locationP->type == LOCATION_array_parameter ||
							locationP->type == LOCATION_array_variable) {
							P[4] = 'P';
						}
						nameP = locationP->nameP;
						if (location_offset != frame_offset) {
							sprintf(buffer, "%s+%d", nameP, frame_offset - location_offset);
							nameP = buffer;
						}
	have_name:
						lth   = strlen(nameP);
						lth1  = (P - numberP);
						if (lth <= lth1) {
							memcpy(numberP, nameP, lth);
							if (lth < lth1) {
								P1 = numberP + lth;
								strcpy(P1, P);
								P = P1;
							}
							break;
						}
						lth0 = numberP - startP;
						lth2 = strlen(P) + 1;
						need = lth0 + lth + lth2;
						if (memory_left < need) {
							memory_left = 1024;
							while (memory_left < need) {
								memory_left <<= 1;
							}
							memory_lth = memory_left;
							memory1P = memoryP = (char *) Xmalloc(memory_lth);
							if (!memoryP) {
								outofmemory();
						}	}
						code1P->m_codeP = memory1P;
						memcpy(memory1P, startP, lth0);
						memory1P += lth0;
						memcpy(memory1P, nameP, lth);
						memory1P += lth;
						strcpy(memory1P, P);
						P            = memory1P;
						memory1P    += lth2;
						Xcheck(memoryP, memory_lth, (memory1P-1));
						memory_left -= need;
						break;
					}
					break;
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					switch (state) {
					case 1:
						numberP      = P;
					case 2:
						frame_offset = 0;
						state        = 3;
					}
					frame_offset = frame_offset * 10 + c - '0';
					break;
				default:
					state = 0;
		}	}	}

		if (g_debug_code) {
			startP = code1P->m_codeP;
			printf("%d: ", (int) (code1P - codesP));
			if (!code1P->m_jumpP) {
				printf("%s\n", startP);
			} else {
				for (P = code1P->m_codeP; *P && *P != ' '; ++P) {
					fputc(*P, stdout);
				}
				printf(" L%d: -> %d\n", (int) (code1P - codesP), (int) (code1P->m_jumpP - codesP));
		}	}
	}
}
#endif

static int
relativeToShort(double value)
{
	assert(value >= 0.0);
	assert(value <= 1.0);
	return (int) ((value - 0.5) * 65534.0);
}

extern FILE *taF;
extern FILE	*tempF;

void
Cfunction::emit_ta(void)
{
	Csource	*sourceP;

	sourceP = m_sourceP;
	if (!sourceP->m_has_clones) {
		sourceP->m_has_clones = 1;
		sourceP->emit_ta();
	}

	fprintf(taF, "$INSTANCE F%p F\n", this);
	fprintf(taF, "contain S%p F%p\n", m_sourceP, this);
	fprintf(tempF, "F%p {label=\"%s\" file=\".\"", this, m_nameP);
	if (m_source_lineno >= 0) {
		fprintf(tempF, " lineno=%d", m_source_lineno);
	}
	fputs("}\n", tempF);
}
	
Cclone *
Cfunction::locate_clone(const codeT *startP, const codeT *endP)
{
	Cclone *cloneP;
	int		start, lth, lth_code;
	char	*nameP;

	for (cloneP = m_clonesP; cloneP; cloneP = cloneP->m_nextP) {
		if (cloneP->m_startP == startP && cloneP->m_endP == endP) {
			return (cloneP);
	}	}
	if (!m_clonesP) {
		emit_ta();
	}
	cloneP = new Cclone(startP, endP);
	cloneP->m_nextP = m_clonesP;
	m_clonesP       = cloneP;

	fprintf(taF, "$INSTANCE C%p C\n", cloneP);
	fprintf(taF, "contain F%p C%p\n", this, cloneP);

	start    = startP - m_sourceP->m_codesP - m_start_code;
	lth      = endP   - startP;
	lth_code = m_end_code - m_start_code;
	if (startP->m_fileP == m_sourceP->m_fileP) {
		nameP = ".";
	} else {
		nameP = startP->m_fileP->m_nameP;
	}
	fprintf(tempF, "C%p {label=\"%d+%d\" file=\"%s\" lineno=%d xrel=%d yrel=%d}\n",
		cloneP,
		start, lth,
		nameP, startP->m_source_lineno,
		relativeToShort(((double) start)/((double) lth_code)),
		relativeToShort(((double) lth)/((double) lth_code))
	);

	return(cloneP);
}
