#ifndef WIN32

//#define TRACE_LOAD_LOCATIONS
//#define TRACE_LOAD

#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>

#include "util.h"
#include "xmalloc.h"
#include "object.h"
#include "label.h"
#include "location.h"
#include "dwarf.h"
#include "file.h"
#include "fileref.h"
#include "code.h"
#include "function.h"
#include "directory.h"
#include "source.h"
#include "read_assembler.h"

#define HASH_SIZE 0x100000

#ifdef DEBUG_HASH
static codeT	*hash_table[HASH_SIZE] = {0};
#endif

static codeT	**hash_tailPP[HASH_SIZE] = {0};

static void
hash_assembler(codeT *codeP)
{
	char		*P;
	int			hash;
	int			c;
	codeT		**hashPP;

	hash = 0;
	P    = codeP->m_codeP;
	if (P) {
		if (*P == 'j') {
			for (; (c = *P) && c != ' '; ++P) {
				hash <<= 1;
				hash  ^= *P;
			}
		} else {
			for (; (c = *P); ++P) {
				hash <<= 1;
				hash  ^= *P;
		}	}
		hash &= (HASH_SIZE - 1);
	}
	
	if ((hashPP = hash_tailPP[hash])) {
		*hashPP = codeP; 
	}
#ifdef DEBUG_HASH
  	  else {
		hash_table[hash] = codeP;
	}
#endif

	hash_tailPP[hash] = &(codeP->m_hashP);
}

extern	int		g_use_frame_address;
extern  long long g_assembler_instructions;
extern	int		g_match_lines;
extern	int		g_max_function_lth;
extern	int		g_read;
extern	int		g_hypertext_cnt;
extern	FILE 	*taF;
extern	FILE	*tempF;

extern int	g_stdin_lineno;

extern labelT	*g_labelsP;

int
Csource::load(char *assemblerP)
{
	static	int		g_labels_cnt = 0;

	char		*atP, *startP;
	int			labels_seen, codes_seen;
	codeT		*codeP, *end_codesP;
	int			code_lth;
	int			*linenosP;
	labelT		*labelP, *string_labelP;
	int			labels_lth;
	int			lth, lth1, lth2, segment, source_lineno;
	char		*debug_abbrevP, *debug_infoP, *debug_strP;
	int			lineno, ret;

	Cfunction	*functionP, **functionsPP;
	Cfileref	*filerefP;
	char		*nameP, *P, *P1, *P2, *absolute_pathP;
	int			number;
	char		c, c1, quote;

	Cdwarf		dwarf;
	int			locations0, locations, max_locations;
	locationT	*locationsP, *locationP;

	Cfile		*fileP, *last_fileP;
	int			last_lineno;


	nameP  = m_fileP->m_nameP;
	ret    = load_assembler(assemblerP);
	if (ret) {
		return(ret);
	}

	// Remove comments from assembler
	// Remove needless blanks

	++g_read;
	quote = 0;
	for (atP = P = startP = m_assemblerP; (c = *atP); ++atP) {
		if (quote) {
			switch (c) {
			case 0:
				fprintf(stderr, "** Line %d: unterminated quote in %s\n", g_stdin_lineno, nameP);
				return -1;
			case '\n':
				fprintf(stderr, "** Line %d: quoted newline character in %s\n", g_stdin_lineno, nameP);
				return -1;
			case '\'':
			case '"':
				if (quote == c) {
					quote = 0;
				}
				break;
			case '\\':
				c = *(++atP);
				switch (c) {
				case 0:
				case '\n':
					// Ignore the backslash
					--atP;
					continue;
				}
				*P++ = '\\';
				break;
			}
		} else {
			switch (c) {
			case '\r':
				if (atP[1] == '\n') {
					continue;
				}
				c = '\n';
				goto end_of_line;
			case ';':
				c = '\n';
			case '\n':
end_of_line:
				if (P > startP && P[-1] == ' ') {
					--P;
				}
				if (P > startP && P[-1] == '\n') {
					continue;
				}
				break;
			case '\t':
				c = ' ';
			case ' ':
				if (P > startP && ((c1 = P[-1]) == ' ' || c1 == ',')) {
					continue;
				}
				break;
			case ',':
				if (P > startP && P[-1] == ' ') {
					--P;
				}
				break;
			case '\\':
				c = *(++atP);
				switch (c) {
				case 0:
				case '\n':
					// Ignore the backslash
					--atP;
					continue;
				}
				*P++ = '\\';
				break;
			case '#':
				while (*(++atP) != '\n' );
				--atP;
				continue;
			case '/':
				if (atP[1] == '*') {
					for (atP += 2; ; ++atP) {
						switch (*atP) {
						case 0:
							atP  -= 2;
							break;
						case '*':
							if (atP[1] == '/') {
								++atP;
								break;
							}
						default:
							continue;
						}
						break;
					}
					continue;
				}
				break;
			case '"':
			case '\'':
				quote = c;
		}	}
		*P++ = c;
	}	
	*P = 0;
	m_assembler_size = P - startP;

	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;

	functionP   = 0;
	functionsPP = &m_functionsP;

	labels_seen = 0;
	codes_seen  = 0;

	// Now count labels, jumps and assembler lines

	for (atP = startP; (c = *atP); atP = strchr(atP, '\n')+1) {
		// Now process this line

		for (; *atP == ' '; ++atP);
		for (P = atP;; ++P) {
			c = *P;
			if (!label_char[(int) c]) {
				if (c == ':') {
					++labels_seen;
					atP = P + 1;
				}
				break;
		}	}
		for (P = atP; *P == ' '; ++P);
		switch (*P) {
		case 0:
			assert(0);
			continue;
		case '.':
		case '\n':
			continue;
		default:
			++codes_seen;
	}	}
	
	allocate_codes(codes_seen);
	codeP      = m_codesP;
	linenosP   = m_code_linenosP;
	end_codesP = codeP + codes_seen;

	if (g_labels_cnt < labels_seen) {
		Xfree(g_labelsP);
		labels_lth = (labels_seen + 1) * sizeof(labelT);
		g_labelsP = (labelT *) Xmalloc(labels_lth);
		if (!g_labelsP) {
			outofmemory();
		}
		g_labels_cnt = labels_seen;
	}

	labelP        = g_labelsP;
	filerefP      = 0;
	source_lineno = 0;
	debug_infoP   = 0;
	debug_abbrevP = 0;
	debug_strP    = 0;
	string_labelP = 0;
	lineno        = 0;
	for (atP = startP; (c = *atP); ) {
		// Now process this line

		for (; *atP == ' '; ++atP);
		for (P = atP;; ++P) {
			c = *P;
			if (!label_char[(int) c]) {
				if (c == ':') {
					Xcheck(g_labelsP, labels_lth, labelP);
					labelP->labelP  = atP;
					*P = 0;
					labelP->lineno  = codeP - m_codesP;
					string_labelP   = labelP;
					labelP->stringP = 0;
					++labelP;
					++P;
					atP = P;
				}
				break;
		}	}
		for (P = atP; *P == ' '; ++P);
		switch (*P) {
		case 0:
			assert(0);
		case '\n':
			++lineno;
			atP = P+1;
			continue;
		case '.':
			++P;
			switch (*P) {
			case 's':	//.s
				if (!strncmp(P, "section .", 9)) {
					P += 9;
					if (!strncmp(P, "debug_info\n", 11)) {
						assert(!debug_infoP);
						atP = debug_infoP = P + 11;
						continue;
					}
					if (!strncmp(P, "debug_abbrev\n", 13)) {
						assert(!debug_abbrevP);
						atP = debug_abbrevP = P + 13;
						continue;
					}
					if (!strncmp(P, "debug_str,", 10)) {
						assert(!debug_strP);
						for (P += 10; *P != '\n'; ++P);
						atP = debug_strP = ++P;
						continue;
				}	}
				if (string_labelP && !strncmp(P, "string ", 7)) {
					for (P += 7; *P == ' '; ++P);
					Xcheck(g_labelsP, labels_lth, string_labelP);
					string_labelP->stringP = P;
					if (*P != '"') {
						P = strchr(P,'\n');
					} else { 
						while ((c = *++P) != '"') {
							if (c == '\\') {
								++P;
						}	}
						++P;
					}
					string_labelP->lth = P - string_labelP->stringP;
					string_labelP      = 0;
				}
				break;
			case 't':	// .t
				if (!strncmp(P, "type ", 5)) {		// .type	
					for (P += 5; *P == ' '; ++P);
					P1 = end_symbol_name(P);
					if (!P1) {
						break;
					}
					P2 = strchr(P1, ',');
					if (!P2) {
						break;
					}
					for (++P2; *P2 == ' '; ++P2);
					if (!strncmp(P2, "@function", 9)) {
						c   = *P1;
						*P1 = 0;
						if (functionP) {
							lth = functionP->m_end_code - functionP->m_start_code;
							if (lth > g_max_function_lth) {
								g_max_function_lth = lth;
						}	}
						functionP = new Cfunction(P, this);
						if (!functionP) {
							outofmemory();
						}
						functionP->m_start_code = codeP - m_codesP;
						functionP->m_end_code   = functionP->m_start_code;
						*functionsPP            = functionP;
						functionsPP             = &(functionP->m_nextP);
						*P1 = c;
					}
				}
				break;
			case 'f':	// .f
				if (!strncmp(P, "file ", 5)) {		// .file
					for (P += 5; *P == ' '; ++P);
					number = strtol(P, &P1, 10);
					if (P == P1) {
						break;
					}
					if (*P1 != ' ') {
						break;
					}
					for (++P1; *P1 == ' '; ++P1);
					if (*P1 != '"') {
						break;
					}
					P = P1 + 1;
					P1 = strchr(P, '"');
					if (!P1) {
						break;
					}
					c   = *P1;
					*P1 = 0;
					absolute_pathP = absolute_path(P);
					*P1 = c;
					filerefP = new Cfileref(number, absolute_pathP);
					if (!filerefP) {
						outofmemory();
					}
					// Add to front so later definitions override
					// earlier ones
					filerefP->m_nextP = m_filerefsP;
					m_filerefsP       = filerefP;
				}
				break;
			case 'l':	// .l
				if (!strncmp(P, "loc ", 4)) {		// .loc
					for (P += 4; *P == ' '; ++P);
					number = strtol(P, &P1, 10);
					if (P == P1) {
						break;
					}
					if (!filerefP || filerefP->m_number != number) {
						filerefP = locate_fileref(number);
						if (!filerefP) {
							assert(0);
					}	}
					for (P = P1; *P == ' '; ++P);
					source_lineno = strtol(P, &P1, 10);
					if (functionP && functionP->m_source_lineno < 0 && filerefP && filerefP->m_fileP == m_fileP) {
						functionP->m_source_lineno = source_lineno;
					}
				}
				break;
			}
			break;
		default:
			string_labelP = 0;
			if (!strncmp(P, "ret\n", 4)) {
				if (functionP) {
					functionP->m_end_code = (codeP - m_codesP) + 1;
			}	}

			if (functionP) {
				memset(codeP, 0, sizeof(codeT));
				codeP->m_functionP     = functionP;
				if (filerefP) {
					codeP->m_fileP     = filerefP->m_fileP;
				}
				codeP->m_source_lineno = source_lineno;
				codeP->m_codeP         = P;
				if (linenosP) {
					*linenosP++ = lineno;
				}
				++codeP;
			}

			for (; *P != '\n'; ++P);
			*P = 0;
			atP = P+1;
			++lineno;
	
			continue;
		}
		atP = strchr(P, '\n');
		assert(atP);
		++atP;
	}
	if (functionP) {
		lth = functionP->m_end_code - functionP->m_start_code;
		if (lth > g_max_function_lth) {
			g_max_function_lth = lth;
	}	}
	Xcheck(g_labelsP, labels_lth, labelP);
	labelP->labelP = 0;
	assert(labelP - g_labelsP == labels_seen);
	m_codes = codeP - m_codesP;
	assert(m_codes <= codes_seen);
	if (linenosP) {
		assert(linenosP - m_code_linenosP == m_codes);
		*linenosP = lineno;
	}
	end_codesP  = codeP;

	for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
		atP = codeP->m_codeP;
		if (*atP != 'j') {
			P = strchr(atP, '$');
			if (P && label_char[(int) *++P] > 1) {
				labelP = find_label(P);
				if (labelP && labelP->stringP) {
					lth  = strlen(labelP->labelP);
					lth1 = labelP->lth;
					if (lth1 <= lth) {
						memcpy(P, labelP->stringP, lth1);
						P += lth1;
						if (lth1 < lth) {
							strcpy(P, P + lth - lth1);
						}
					} else {
						segment = strlen(atP);
						code_lth = segment + lth1 - lth + 1;
						codeP->m_codeP = P1 = (char *) Xmalloc(code_lth);
						if (!P1) {
							outofmemory();
						}
						lth2 = P - atP;
						memcpy(P1, atP, lth2);
						P1 += lth2;
						memcpy(P1, labelP->stringP, lth1);
						P1 += lth1;
						strcpy(P1, P + lth);
						Xcheck(codeP->m_codeP, code_lth, (P1+strlen(P1)));
			}	}	}		
		} else {
			for (++atP; (c = *atP) && c != ' '; ++atP);
			if (!c) {
				assert(0);
				continue;
			}
			for (++atP; (c = *atP) && c == ' '; ++atP);
			if (!c) {
				assert(0);
				continue;
			}
			labelP = find_label(atP);
			if (labelP) {
				// Make jump relative
				// Otherwise this is something like jmp *%eax
				codeP->m_jumpP       = m_codesP + labelP->lineno;
	}	}	}

	if (!g_use_frame_address && debug_abbrevP && debug_infoP) {
		dwarf.load(g_labelsP, debug_abbrevP, debug_infoP, debug_strP);
		codeP         = m_codesP;
		max_locations = 0;
		// Allow this to be decremented and testing less.
		locationsP    = ((locationT *) 0)+1;
		for (functionP = m_functionsP; functionP; functionP = functionP->m_nextP) {
			P         = functionP->m_signatureP;
			P1        = functionP->m_nameP;
			locationP = 0;
#ifdef TRACE_LOAD_LOCATIONS
			fprintf(stderr, "Compute locations for %s\n", P);
#endif
			dwarf.load_locations(P, P1, &locationP, 0 /* Don't load */);
			locations = locations0 = locationP - ((locationT *) 0);
#ifdef TRACE_LOAD_LOCATIONS
			fprintf(stderr, "%d locations\n", locations);
#endif
			if (locations != 0) {
				if (max_locations <= locations) {
					if (!max_locations) {
						max_locations = 128;
					}
					while (max_locations <= locations) {
						max_locations <<= 1;
					}
					locationsP = (locationT *) alloca(sizeof(locationT) * max_locations);
					if (!locationsP) {
						outofmemory();
				}	}
				locationP = locationsP;
#ifdef TRACE_LOAD_LOCATIONS
				fprintf(stderr, "Load locations for %s\n", P);
#endif
				dwarf.load_locations(P, P1, &locationP, 1);
				locations = locationP - locationsP;
#ifdef TRACE_LOAD_LOCATIONS
				fprintf(stderr, "%d locations\n", locations);
#endif
				assert(locations <= locations0);
			}
			functionP->update_names(locations, locationsP, codeP);
	}	}	

	// Do after any name changing
	g_assembler_instructions += m_codes;
	if (!g_match_lines) {
		for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
			hash_assembler(codeP);
		}
	} else {
		last_fileP  = 0;
		last_lineno = 0;
		for (codeP = m_codesP; codeP < end_codesP; ++codeP) {
			if ((fileP = codeP->m_fileP)) {
				if (fileP == last_fileP) {
					if (codeP->m_source_lineno == last_lineno) {
						continue;
					}
				} else {
					last_fileP = fileP;
			}	}
			last_lineno = codeP->m_source_lineno;
			hash_assembler(codeP);
	}	}
#ifdef DEBUG_HASH
	dump_hash();
#endif
	return 0;
}

extern int	g_skip_compile;
extern int	g_unlink;
extern int	g_verbose;
extern int	g_stdin_lineno;
extern char	**g_envPP;

static int
call_cc(char *argv[])
{
	int		ret, pid;
	int		status;
	int 	i;

	if (g_verbose) {
		fprintf(stderr, "%4d: ", g_stdin_lineno);
		for (i = 0; argv[i]; ++i) {
			fprintf(stderr, "%s ", argv[i]);
		}
		fprintf(stderr,"\n");
	}
	
	ret = fork();
	switch (ret) {
	case 0:
		execve(argv[0], argv, g_envPP);
		fprintf(stderr,"** Line %d: Return from execve %s\n", g_stdin_lineno, argv[0]);
		error_exit(1);
	case -1:
		fprintf(stderr,"** Line %d: Fork to cc failed\n", g_stdin_lineno);
		perror("");
		error_exit(2);
	}
	pid = wait(&status);
	if (pid != ret) {
		fprintf(stderr,"** Line %d: Wait for cc failed\n", g_stdin_lineno);
		perror("");
		error_exit(3);
	}
	if (!WIFEXITED(status)) {
		fprintf(stderr,"** Line %d: cc did not terminate normally\n", g_stdin_lineno);
		return(-1);
	}
	return(WEXITSTATUS(status));
}

#define SUFFIX_s 	0
#define SUFFIX_S    1
#define SUFFIX_c 	2
#define SUFFIX_C 	3
#define SUFFIX_cc 	4
#define SUFFIX_cxx	5
#define SUFFIX_cpp	6
#define SUFFIX_cpp1 7
#define SUFFIX_none 8

/* Must agree with SUFFIX_* */

static const char *suffixes[] =
{
	"s",
	"S",
	"c",
	"C",
	"cc",
	"cxx",
	"cpp",
	"c++",
	0
};

static int
process_command(int argc2, char **argv1P)
{
	extern int	g_compiled_ok;
	extern int	g_compiled_bad;

	static char	filename1[1024];
	static char	*compilePP[2048];

	struct stat	source_stat;
	struct stat assembler_stat;

	int			compile;

	char 	*programP, *compileP, *targetP, *assemblerP, *absolute_pathP;
	char	*P, *P1;
	const char	*suffixP;
	int		i, suffix, unlink_me, lth, ret, argc1;
	int		seen_dash_S, seen_dash_E, running_as, skip_compile;
	int		c2;
	Csource	*sourceP;

	/* Find the source and target files */

	seen_dash_S = 0;
	seen_dash_E = 0;
	targetP     = 0;
	assemblerP  = 0;
	compile     = 0;
	running_as  = 0;
	skip_compile= g_skip_compile;
	programP    = argv1P[0];
	lth         = strlen(programP);
	if (lth > 3) {
		if (!strcmp(programP+lth-3, "/as")) {
			running_as = 1;
		} else if (lth > 4 && !strcmp(programP+lth-4, "/gas")) {
			running_as = 1;
	}	}
	
	if (running_as) {
		for (argc1 = i = 1; (P = argv1P[argc1]); ++argc1) {
			if (argc1 >= argc2) {
				fprintf(stderr, "** lineno %d: Can't scan args for %s\n", g_stdin_lineno, programP);
				return(-1);
			}
			if (*P != '-') {	
				if (!strcmp(P, "/dev/null")) {
					return(0);
				}
				compilePP[compile++] = P;
				continue;		// Discard (to add back in later)
			}
			switch(P[1]) {
			case '-':
				if (!strcmp(P,"--defsym")) {
					++argc1;	// Discard two arguments
				}
				continue;
			case 'I':
			case 'o':
				if (!P[2]) {
					++argc1;
				}
			case 'a':
			case 'D':
			case 'f':
			case 'g':
			case 'J':
			case 'K':
			case 'L':
			case 'n':
			case 'R':
			case 'v':
			case 'W':
			case 'w':
			case 'x':
			case 'Z':
				continue;
			}
			fprintf(stderr, "** Line %d: Unknown %s option '%s'\n", g_stdin_lineno, programP, P);
			goto bad;
		}
	} else {
		for (argc1 = i = 1; (P = argv1P[argc1]); ++argc1) {
			if (argc1 >= argc2) {
				fprintf(stderr, "** lineno %d: Can't scan args for %s\n", g_stdin_lineno, programP);
				return(-1);
			}
			if (*P != '-') {	
				if (!strcmp(P, "/dev/null")) {
					return(0);
				}
				compilePP[compile++] = P;
				continue;		// Discard (to add back in later)
			}
			c2 = P[2];
			switch(P[1]) {
			case 'a':
				if (!strcmp(P, "-aux-info")) { 		// Discard 2 args
					++argc1;
					continue;
				}
			case 'B':
			case 'n':
			case 't':
			case 'Y':
				argv1P[i++] = P;
				continue;
			case 'f':
				// Need frame pointers for dwarf
				if (strcmp(P,"-fomit-frame-pointer")) {
					argv1P[i++] = P;
				}
				continue;
			case 'D':
			case 'I':
			case 'U':
				if (!c2) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'b':
				if (!c2) {
					++argc1;						// Discard 2 args
					continue;
				}
				argv1P[i++] = P;
			case 'c':
			case 'C':
			case 'g':
			case 'h':
			case '-':
			case 'M':
			case 'O':
			case 'P':
			case 'Q':
			case 'r':
			case 'v':
			case 'w':
			case 'l':
			case 'L':
				continue;							// Discard
			case 'd':
				if (c2 == 'D' || c2 == 'I' || c2 == 'M' || c2 == 'N') {
					argv1P[i++] = P;
				}
				continue;
			case 'E':
				if (!c2) {
					seen_dash_E = 1;
					continue;
				}
				argv1P[i++] = P;
				continue;
			case 'G':
			case 'm':
				if (!c2) {
					++argc1;
				}
				continue;
			case 'i':
				if (!strcmp(P, "-idirafter")     ||
					!strcmp(P, "-imacros")       ||
					!strcmp(P, "-include")       ||
					!strcmp(P, "-iprefix")       ||
					!strcmp(P, "-iwithprefix")   ||
					!strcmp(P, "-isystem")) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'o':	// <file>
				if (!c2) {
					targetP = argv1P[++argc1];	// Discard parameter
					continue;
				}
				targetP = P + 2;
				continue;
			case 'p':
				if (strcmp(P, "-print")) {		// Not -print
					argv1P[i++] = P;
				} else {
					if (!strcmp(P, "-print-file-name")) {
						return(0);
				}	}
				continue;
			case 'S':
				if (!c2) {
					seen_dash_S = 1;
					continue;	
				}
				break;
			case 's':
				if (!strcmp(P, "-std")) {
					argv1P[i++] = P;
				}
				continue;
			case 'u':
			case 'V':
				if (!c2) {
					argv1P[i++] = P;
					P           = argv1P[++argc1];
				}
				argv1P[i++] = P;
				continue;
			case 'W':
				if (!strcmp(P, "-Wp,")) {
					if (!strcmp(P, "-Wp,-M")) {
						argv1P[i++] = P;
				}	}
				continue;
			case 'x':
				if (c2) {
					argv1P[i++] = P;
					continue;
				}
			case 'X':
				argv1P[i++] = P;
				argv1P[i++] = argv1P[++argc1];
				continue;
			case '#':
				if (!strcmp(P, "-###")) {
					continue;
				}
				break;
			}
			/* If the compiler was not compiling we shouldn't */
			fprintf(stderr, "** Line %d: Unknown compiler option '%s'\n", g_stdin_lineno, P);
			goto bad;
		}
	}

	argc1 = i;

	compilePP[compile] = 0;

	if (seen_dash_S) {
		assemblerP = targetP;
	}

	for (compile = 0; (compileP = compilePP[compile]); ++compile) {
		P1 = strrchr(compileP, '.');
		if (!P1) {
			suffix = SUFFIX_none;
		} else {
			++P1;
			for (suffix= 0;; ++suffix) {
			
				if (!(suffixP = suffixes[suffix])) {
					goto next_command;
				}
				if (!strcmp(P1, suffixP)) {
					break;
		}	}	}
	
		unlink_me  = 0;
		if (suffix == SUFFIX_S && running_as) {
			suffix = SUFFIX_s;
		}
		switch (suffix) {
		case SUFFIX_cxx:
		case SUFFIX_cpp:
		case SUFFIX_cpp1:
		case SUFFIX_c:
		case SUFFIX_C:
		case SUFFIX_cc:
			if (seen_dash_E) {
				goto next_command;
			}
		case SUFFIX_S:
			if (!assemblerP) {
				lth = P1-compileP;
				memcpy(filename1, compileP, lth);
				strcpy(filename1+lth, "s");
				assemblerP = filename1;
			}
			argv1P[argc1++] = compileP;
			argv1P[argc1]   = 0;
			argv1P         -= 4;
			argv1P[0]       = argv1P[4];
			argv1P[1]       = "-o";
			argv1P[2]       = assemblerP;
			argv1P[3]       = "-g";
			if (suffix == SUFFIX_S) {
				argv1P[4]   = "-E";
			} else {
				argv1P[4]   = "-S";
			}
		
			if (g_unlink || skip_compile) {
				if (access(assemblerP, F_OK)) {
					// Looks like file does not exist
					unlink_me    = g_unlink;
					skip_compile = 0;
				} else if (skip_compile) {
					if (!access(compileP, F_OK)) {
						// Looks like the source exists
						if (stat(compileP, &source_stat) ||
                            stat(assemblerP, &assembler_stat) ||
							source_stat.st_mtime >= assembler_stat.st_mtime) {
							skip_compile = 0;
			}	}	}	}
	
			if (!skip_compile) {
				ret = call_cc(argv1P);
				if (ret) {
					++g_compiled_bad;
					fprintf(stderr, "** Line %d: Failed to compile %s\n", g_stdin_lineno, compileP);
					unlink_me = 0;
					goto next_command;
				}
				++g_compiled_ok;
			}
			goto read_assembler;
	
		case SUFFIX_s:
			assemblerP     = compileP;
read_assembler:
			absolute_pathP = absolute_path(compileP);
			sourceP        = new Csource();
			if (!sourceP) {
				outofmemory();
				goto bad;
			}
			sourceP->set_filename(absolute_pathP);
	
			absolute_pathP = absolute_path(assemblerP);
#ifdef TRACE_LOAD
			fprintf(stderr, "Loading %s\n", absolute_pathP);
#endif
			if (sourceP->load(absolute_pathP)) {
#ifdef TRACE_LOAD
				fprintf(stderr, "Load failed\n");
#endif
				goto next_command;
			}
#ifdef TRACE_LOAD
			fprintf(stderr, "Loaded\n");
#endif
	
			if (!unlink_me) {
				break;
			}
	
			unlink_me = 0;
	
			/* Sanity checks follow */
			if (assemblerP != filename1) {
				break;
			} 
			lth = strlen(assemblerP);
			if (lth < 3 || assemblerP[lth-2] != '.' || assemblerP[lth-1] != 's') {
				fprintf(stderr, "Line %d: May not delete %s\n", g_stdin_lineno, assemblerP);
				error_exit(5);
				goto bad;
			}
	
			/* Discard this assembly file when done */
	
			if (unlink(assemblerP)) {
				fprintf(stderr, "Line %d: Can't delete %s\n", g_stdin_lineno, assemblerP);
				perror("");
				break;
			}
			break;
		}
next_command:
		continue;
	}
	return(0);
bad:
	return(-1);
}

void
read_assembler(char *commandP)
{
// Leave room for -g -S -o filename
#define ExtraSlots 4

	static char	*argv1[2048];
	char	**argv1P;
	char	*startP, *endP, *nextP;
	int		i, c;

	argv1P = argv1 + ExtraSlots;
	startP = commandP;
	if (*startP != '"') {
		fprintf(stderr, "** Line %d: Missing cwd start '\"' >%s\n", g_stdin_lineno, startP);
		return;
	}

	for (i = -1; startP; ++i) {
		for (endP = nextP = ++startP; (c = *nextP) != '"'; ++nextP) {
			switch (c) {
			case 0:
				fprintf(stderr, "** Line %d: Missing end '\" >%s'\n", g_stdin_lineno, startP);
				return;
			case '\\':
				c = *(++nextP);
			default:
				*endP++ = c;
		}	}
		*endP = 0;
		if (i < 0) {
			cwdP = startP;
			if (chdir(cwdP)) {
				fprintf(stderr,"** Line %d: Can't change directory to %s\n", g_stdin_lineno, cwdP);
				perror("");
				return;
			}
		} else {
			argv1P[i] = startP;
		}
		startP = strchr(nextP+1, '"');
	}
	if (i < 1) {
		fprintf(stderr, "** Line %d: Missing cmd '\" >%s'\n", g_stdin_lineno, commandP);
		return;
	}
	argv1P[i]   = 0;

	process_command(i, argv1P);
}
#endif

