#define _CRT_SECURE_NO_WARNINGS

#include <time.h>
#include <stdio.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <stdlib.h>
#include <ctype.h>

#include "object.h"
#include "util.h"
#include "directory.h"
#include "ta.h"

#ifdef WIN32
#define fdopen _fdopen
#define fileno _fileno
#define snprintf _snprintf
#endif

extern char	*g_ta_fileP;
extern char *g_html_dirP;

extern FILE *indexF;
extern FILE	*taF;
extern FILE *tempF;

void
ta_header(int argc, char **argv)
{
	char	*P;
	int		i, ret;

	if (!g_ta_fileP) {
		return;
	}
	P = strchr(g_ta_fileP, '/');
	if (!P && g_html_dirP) {
		ret = snprintf(g_filename, FILENAME_MAX, "%s/%s", g_html_dirP, g_ta_fileP);
		if (ret < 0 || FILENAME_MAX <= ret) {
			fprintf(stderr, "ta filename too long\n");
			error_exit(1);
		}
		P = g_filename;
		fprintf(indexF, "<h3>TA Output</h3>\n<p>\n<a href=\"%s\">%s</a>\n<p>\n", g_ta_fileP, g_ta_fileP);
	} else {
		P = g_ta_fileP;
	}
	taF = open_file(P);
	tempF = tmpfile();
	if (!tempF) {
		fprintf(stderr, "Can't create temporary file for ta output\n");
		exit(1);
	}

	fprintf(taF, "// ACD Version " VERSION " Compiled " __DATE__ ":"  __TIME__ );
	for (i = 0; i < argc; ++i) {
		fprintf(taF,"%s ", argv[i]);
	}

	fputs(	"\nSCHEME TUPLE :\n\n"
		  	"$INHERIT D   $ENTITY\n"// Directory
			"$INHERIT S   $ENTITY\n"// Source
			"$INHERIT F   $ENTITY\n"// Function
			"$INHERIT C   $ENTITY\n"// Clone
			"contain  D   D\n" 		// Directory contains Directory
		  	"contain  D   S\n"		// Directory contains Source
		  	"contain  S   F\n"		// Source    contains Functions
			"contain  F   C\n"		// Functions contains Clones
			"R        C   C\n"     	// Relationship of clones
			"\nSCHEME ATTRIBUTE :\n\n"
		  	"$ENTITY {\n"
		  	"   color       = (255 255 255)\n"
          	"   labelcolor  = (  0   0   0)\n"
          	"   class_style = 1\n"
          	"   class_icon  = entity.png\n"
          	"   file\n"
		  	"}\n"
			"D {\n"
                        "   class_label = \"Directory\"\n"
		  	"   color       = (255 255 153)\n"
          	"   labelcolor  = (  0   0   0)\n"
          	"   class_icon  = directory.png\n"
          	"   class_style = 4\n"
		  	"}\n"
			"S {\n"
			"   class_label = \"Source\"\n"
		  	"   color       = (  0 204   0)\n"
          	"   labelcolor  = (  0   0   0)\n"
          	"   class_icon  = source.png\n"
          	"   class_style = 0\n"
		  	"}\n"
		  	"F {\n"
			"   class_label = \"Function\"\n"
			"   color       = (0   255 255)\n"
          	"   class_style = 1\n"
          	"   class_icon  = function.png\n"
          	"   lineno\n"
		  	"}\n"
			"C {\n"
			"   class_label = \"Clone\"\n"
		  	"   color       = (255 255 204)\n"
          	"   labelcolor  = (  0   0   0)\n"
          	"   class_icon  = collection.png\n"
          	"   class_style = 0\n"
		  	"}\n"
			"(R) {\n"
			"   class_label = \"Matches\"\n"
 			"	class_active = 3\n"
 			"	class_visible = 3\n"
			"}\n"
			"\nFACT TUPLE :\n\n"
	, taF);
}

void
ta_trailer(void)
{
	FILE		*inputF;
	Cdirectory	*directoryP;
	int			c;

	if (!taF) {
		return;
	}
	for (directoryP = Cdirectory::g_headP; directoryP; directoryP = directoryP->m_nextP) {
		directoryP->emit_ta();
	}

	fputs("\nFACT ATTRIBUTE :\n\n", taF);

	fflush(tempF);
	inputF =  fdopen(fileno(tempF), "r");
	if (!inputF) {
		fprintf(stderr, "Can't re-read temp file containing ta\n");
		exit(1);
	}
	rewind(inputF);
	for (; (c = getc(inputF)) != EOF; putc(c, taF));
	fputs("\n// End of report\n", taF);
	fclose(taF);
	fclose(inputF);
	fclose(tempF);
}

