#ifdef WIN32
#define _CRT_SECURE_NO_WARNINGS
#endif

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "xmalloc.h"
#include "util.h"

char	g_filename[FILENAME_MAX];

void
error_exit(int code)
{
	fprintf(stderr,"Exit code %d\n", code);
	exit(code);
}

char	label_char[256]    = {0};
char	function_char[256] = {0};

void
init_lookup_chars(void)
{
	int		i;

	for (i = '0'; i <= '9'; ++i) {
		label_char[i]    = 1;
		function_char[i] = 1;
	}
	for (i = 'A'; i <= 'Z'; ++i) {
		label_char[i]    = 2;
		function_char[i] = 2;
	}
	for (i = 'a'; i <= 'z'; ++i) {
		label_char[i]    = 3;
		function_char[i] = 3;
	}
	label_char[(int) '_']    = 4;
	function_char[(int) '_'] = 4;
	label_char[(int) '.']    = 5;
	function_char[(int) '.'] = 5;
	function_char[(int) '$'] = 6;
#ifdef WIN32
	label_char[(int) '$']    = 6;
	label_char[(int) '?']    = 7;
	label_char[(int) '@']    = 8;
#endif
}

char *
end_symbol_name(char *P)
{
	char	*P1;
	int		c;

	c = *P;
	if (c == '_' || isalpha(c)) {
		for (P1 = P; function_char[(int) *P1]; ++P1);
		return(P1);
	}
	return(0);
}

/* Convert the pathP to an absolute path.
 */

char	*cwdP = 0;

char *
absolute_path(char *pathP)
{
	static char	full_path[2048];

	char	*P, *P1;

	P = full_path;
	if (*pathP == '/') {
		/* If the path is an absolute path we are done */
		strcpy(full_path, pathP);
	} else if (!cwdP || cwdP[0] != '/') {
		/* Don't know what the cwd is */
		strcpy(P, pathP);
	} else {
		strcpy(P, cwdP);
		P += strlen(cwdP);
		*P++ = '/';
		strcpy(P, pathP);
	}

	for (P = full_path; (P1 = strchr(P, '.')); ) {
		switch (P1[1]) {
		case '/':
			if (P1 == full_path || P1[-1] == '/') {
				// Erase ./
				P = P1;
				strcpy(P, P+2);
				continue;
			}
			break;
		case '.':
			if (P1[2] == '/' && P1 > full_path+1 && P1[-1] == '/') {
				// Remove <parent>/../
				for (P = P1-2; P != pathP && P[-1] != '/'; --P);
				strcpy(P, P1+3);
				continue;
			}
			break;
		}
		P = P1 + 1;
	}
	return(full_path);
}

void
put_opcode(const char *stringP, FILE *F)
{
	const char 	*P;
	char		c;

	for (P = stringP; (c = *P++); ) {
		switch (c) {
		case ' ':
			return;
		case '>':
			fputs("&gt;", F);
			continue;
		case '<':
			fputs("&lt;", F);
			continue;
		case '&':
			fputs("&amp;", F);
			continue;
		case '\n':
			fputs("\n<br>\n", F);
			continue;
		}
		fputc(c, F);
}	}

void
put_html(const char *stringP, FILE *F)
{
	const char 	*P;
	char		c;

	for (P = stringP; (c = *P++); ) {
		switch (c) {
		case '>':
			fputs("&gt;", F);
			continue;
		case '<':
			fputs("&lt;", F);
			continue;
		case '&':
			fputs("&amp;", F);
			continue;
		case '\n':
			fputs("\n<br>\n", F);
			continue;
		}
		fputc(c, F);
}	}

FILE *
open_file(const char *filenameP)
{
	FILE	*F;

	F = fopen(filenameP, "w");
	if (!F) {
		fprintf(stderr, "Can't open %s\n", filenameP);
		exit(1);
	}
	return(F);
}

int
getline1(char **bufferPP, int *lthP, FILE *fromF)
{
	char	*bufferP, *endP, *P;
	int		buffer_lth;
	int		c, at;

	bufferP    = *bufferPP;
	buffer_lth = *lthP;
	if (!bufferP || !buffer_lth) {
		if (!buffer_lth) {
			*lthP = buffer_lth = 256;
		}
		*bufferPP = bufferP = (char *) Xmalloc(buffer_lth);
		if (!bufferP) {
			outofmemory();
		}
	} 

	endP = bufferP + buffer_lth - 1;
	for (P = bufferP; ;) {
		if (P == endP) {
			at            = (P - bufferP);
			buffer_lth  <<= 1;
			*bufferPP     = bufferP = (char *) Xrealloc(bufferP, buffer_lth);
			if (!bufferP) {
				outofmemory();
			}
			*lthP         = buffer_lth;
			P             = bufferP + at;
			endP          = bufferP + buffer_lth - 1;
		}
		switch (c = getc(fromF)) {
		case EOF:
			if (P == bufferP) {
				return(-1);
			}
		case '\n':
//			*P++ = '\n';
			Xcheck(bufferP, buffer_lth, P);
			*P   = 0;
			return(P - bufferP);
		case '\r':
			continue;
		default:
			Xcheck(bufferP, buffer_lth, P);
			*P++ = c;
}	}	}

char *
dupstring(const char *stringP)
{
	register char	*retP;
	int				string_lth;

	string_lth = strlen(stringP) + 1;
	retP = (char *) Xmalloc(string_lth);
	if (!retP) {
		outofmemory();
	}
	strcpy(retP, stringP);
	return(retP);
}
