#include <sys/types.h>
#include <sys/wait.h>
#include <ctype.h>
#include <assert.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "libiberty.h"
#include "cx.h"

typedef struct {
  char *buffer;
  size_t pos;
  size_t alloc;
} SFILE;

SFILE	input;

static void
parse(char *filenameP, void (*callback)(int lth, char *lineP))
{
	static const char *reserved[] = {
		"if",
		"for",
		"while",
		"do",
		"switch",
		"case",
		"return",
		"sizeof",
		"throw",
		"__attribute__",
		"__mode__",
		0
	};

	int		c, c1, primed, nesting, word_nesting, word_brackets, brackets, lth;
	char	*last_sourceP, *sourceP, *word_sourceP, *functionP, *P, *P1;
	char	*wordP, *end_wordP;
	int		last_lineno, lineno, word_lineno, val;
	const char	**reservedPP, *reservedP;

	char	buffer[256];

	last_sourceP = "";
	last_lineno  = -1;

	lth = sprintf(buffer, "File %s", filenameP);
	callback(lth, buffer);

	wordP     = 0;
	end_wordP = 0;
	primed    = 0;
	functionP = 0;
	nesting   = 0;
	brackets  = 0;

	for (P = input.buffer; (c = *P); ) {
		if (!primed) {
			if (isalnum(c) || c == '_' || (c == ':' && P[1] == ':')) {
				if (end_wordP) {
					goto retreat;
				}
				if (!wordP) {
					if (c >= '0' && c <= '9') {
						wordP = (char *) -1;
					} else {
						wordP         = P;
						end_wordP     = 0;
						word_sourceP  = sourceP;
						word_lineno   = lineno;
						primed        = 0;
						word_brackets = brackets;
					}
					word_nesting = nesting;
				}
				if (c == ':') {
					++P;
				}
				goto advance;
			}
			if (wordP) {
				if (wordP == (char *) -1) {
					wordP = 0;
				} else {
					if (!end_wordP) {
						*P = 0;
						for (reservedPP = reserved; (reservedP = *reservedPP); ++reservedPP) {
							if (!strcmp(wordP, reservedP)) {
								wordP = 0;
								break;
						}	}
						if (wordP) {
							end_wordP = P;
						}
						*P = c;
		}	}	}	}	
	
		switch (c) {
		case '\r':
			if (P[1] == '\n') {
				goto advance;
			}
		case '\n':
			++lineno;
		case ' ':
		case '\t':
			goto advance;
		case '#':
			++P;
			if (*P == ' ') {
				++P;
				val = strtol(P, &P1, 10);
				if (P1 > P) {
					lineno = val;
					P = P1;
					for (;isspace(*P); ++P);
					if (*P == '"') {
						sourceP = ++P;
						for (; (c = *P) && c != '"'; ++P);
						*P = 0;
						if (!strcmp(sourceP, last_sourceP)) {
							sourceP = last_sourceP;
						} 
						*P = c;
			}	}	}
			for (; (c = *P) ; ++P) {
				if (c == '\n') {
					break;
			}	}
			if (c) {
				goto advance;
			}
			continue;
		case '"':
		case '\'':
			for (; (c1 = *++P) ; ) {
				if (c1 == c) {
					break;
				}
				if (c == '\\') {
					++P;
			}	}
			break;
		case '(':
			++brackets;
			if (end_wordP) {
				primed = 1;
				goto advance;
			}
			break;
		case ')':
			--brackets;
			break;
		case '}':
			if (!--nesting) {
				functionP = 0;
			}
		case ';':
			if (!functionP) {
				if (wordP) {
					goto retreat;
				}
				break;
			}
			goto common;
		case '{':
			++nesting;
common:		if (!wordP) {
				break;
			}
			if (primed) {
				if (word_sourceP != last_sourceP) {
					P1 = strchr(word_sourceP, '"');
					if (P1) {
						*P1 = 0;
					}
					lth = sprintf(buffer, "Source %s", word_sourceP);
					callback(lth, buffer);
				
					if (P1) {
						*P1 = '"';
					}
					last_sourceP = word_sourceP;
					last_lineno = -1;
				}
				if (word_lineno != last_lineno) {
					lth = sprintf(buffer, "Line %d", word_lineno);
					callback(lth, buffer);
					last_lineno = word_lineno;
				}
				c1         = *end_wordP;
				*end_wordP = 0;
				if (brackets == word_brackets && c == '{') {
					lth = sprintf(buffer,"Function %s", wordP);
					functionP = wordP;
					nesting = 1;
				} else {
/*
					if (!strcmp(wordP, "Carchive")) {
						printf("%s %s:%d\n", wordP, word_sourceP, word_lineno);
					}
 */
					lth = sprintf(buffer, "Calls %s", wordP);
				}
				callback(lth, buffer);
				*end_wordP = c1;
			}
			goto retreat;
		}
		if (end_wordP && !primed) {
			goto retreat;
		}
advance:
		++P;
		continue;
retreat:
		assert(end_wordP);
		P         = end_wordP;
		sourceP   = word_sourceP;
		lineno    = word_lineno;
		wordP     = 0;
		end_wordP = 0;
		primed    = 0;
		nesting   = word_nesting;
	}
	lth = sprintf(buffer, "End of report");
	callback(lth, buffer);
}

int
cx(char *argv[], void (*callback)(int lth, char *lineP))
{
	char	*P, *filenameP;
	int		pipe1[2];
	int		ret, pid;
	int		status;
	FILE	*F;
	int		i, j, c;

	char	**argv1;

	for (i = 1; argv[i]; ++i);
	argv1 = alloca(sizeof(char *)*i);

	filenameP = 0;
	for (i = j = 1; (P = argv[i]); ++i) {
		if (*P == '-') {
			switch (P[1]) {
			case 'D':
			case 'U':
			case 'I':
				argv1[j++] = P;
			}
			continue;
		}
		argv1[j++] = P;
		filenameP  = P;
	}
	if (!filenameP) {
		fprintf(stderr, "cx: no filename in arguments\n");
		return(-1);
	}
	argv1[j] = 0;

	input.alloc  = 20000;
	input.buffer = xmalloc(input.alloc+1);
	input.pos    = 0;

	if (pipe(pipe1)) {
		fprintf(stderr, "Can't create pipe\n");
		return(-1);
	}

	ret = fork();
	switch (ret) {
	case -1:
		fprintf(stderr, "Can't fork\n");
		return(-1);
	case 0:
		close(pipe1[0]);
		argv1[0] = "/usr/bin/cpp";
 		dup2(pipe1[1] ,fileno(stdout));
		/* The child process */
		execv(argv1[0], argv1);
		fprintf(stderr,"Return from execve %s\n", argv1[0]);
		return(1);
	}

	close(pipe1[1]);
	F = fdopen(pipe1[0], "r");
	if (!F) {
		fprintf(stderr, "Can't read from cpp\n");
		return(-1);
	}

	while ((c = fgetc(F)) != EOF) {
		input.buffer[input.pos] = c;
		if (++input.pos >= input.alloc) {
			input.alloc <<= 1;
			input.buffer = xrealloc(input.buffer, input.alloc + 1);
	}	}
	fclose(F);
	input.buffer[input.pos] = 0;

	if (input.pos) {
		/* If we didn't read anything assume cpp failed */
		parse(filenameP, callback);
	}

	pid = wait(&status);
	if (pid != ret) {
		fprintf(stderr,"Wait for cpp failed\n");
		return(-1);
	}
	if (!WIFEXITED(status)) {
		fprintf(stderr,"cpp did not terminate normally\n");
		return(-1);
	}
	return(WEXITSTATUS(status));
}

