
/* This is a reference to the file the source is to be presumed to be found
 * in, when present.  The number is the number by which this file is to be
 * known in any subsequent .loc commands.
 *
 * For example:
 *
 * Given in the C code the line
 *
 * #line 5 "ABC"
 *
 * the debuggable assembler compiled with -g will contain:
 *
 *  .file 1 "ABC"   // Any reference to 1 means "ABC"
 *  .loc 1 7 0      // Treat as lineno 7 in "ABC"
 *
 */

class Cfile	: public Centity {
public:
	static Cfile	*g_headP;
	static int		g_cnt;

	Cfile			*m_nextP;
	int		 		m_number;

	Cfile(Centity *sourceP, int number, char *filenameP);
	static Cfile *locate(Centity *sourceP, int number);

	virtual objectE	type(void) const;
	virtual void	emit_id(void) const;
	virtual void	print(void) const;
	virtual void	emit_instance(void) const;
	virtual void	emit_attributes(void) const;
};

