#include <stdio.h>

#include "util.h"
#include "object.h"
#include "classmember.h"
#include "directory.h"
#include "archive.h"
#include "source.h"
#include "file.h"
#include "class.h"
#include "variable.h"
#include "function.h"
#include "edge.h"


static int g_massive_check_cnt = 0;

void
sanity_trap(void)
{
	fprintf(stderr, "Massive check %d\n", g_massive_check_cnt);
	error_exit(3);
}

void
sanity_breakpoint(void)
{
	fprintf(stderr, "At sanity breakpoint\n");
}

void
sanity(void)
{
	Cdirectory	*directoryP;
	Carchive	*archiveP;
	Csource		*sourceP;
	Cclass		*classP;
	Cfunction	*functionP;
	Cvariable	*variableP;
	Cedge		*edgeP;
	unsigned int	i, cnt;

	++g_massive_check_cnt;
	if (g_massive_check_cnt == 127460) {
		sanity_breakpoint();
	}

	cnt = 0;
	for (directoryP = Cdirectory::g_headP; directoryP; directoryP = directoryP->m_nextP) {
		++cnt;
	}
	if (cnt != Cdirectory::g_cnt) {
		fprintf(stderr, "!!Warning!! - Lost directories %d seen but %d created\n", cnt, Cdirectory::g_cnt);
		sanity_trap();
	}

	cnt = 0;
	for (archiveP = Carchive::g_headP; archiveP; archiveP = archiveP->m_nextP) {
		++cnt;
	}
	if (cnt != Carchive::g_cnt) {
		fprintf(stderr, "!!Warning!! - Lost archives %d seen but %d created\n", cnt, Carchive::g_cnt);
		sanity_trap();
	}

	cnt = 0;
	for (sourceP = Csource::g_headP; sourceP; sourceP = sourceP->m_nextP) {
		++cnt;
	}
	if (cnt != Csource::g_cnt) {
		fprintf(stderr, "!!Warning!! - Lost sources %d seen but %d created\n", cnt, Csource::g_cnt);
		sanity_trap();
	}

	cnt = 0;
	if ((classP = Cclass::g_headP)) {
		for (; classP; classP = classP->m_nextP) {
			++cnt;
	}	}
	if (cnt != Cclass::g_cnt) {
		fprintf(stderr, "!!Warning!! - Lost classes %d seen but %d created\n", cnt, Cclass::g_cnt);
		sanity_trap();
	}

	cnt = 0;
	for (i = 0; i < HASHSIZE; ++i) {
		for (variableP = Cvariable::g_hash[i]; variableP; variableP = variableP->m_hashP) {
			++cnt;
	}	}
	if (cnt != Cvariable::g_hash_cnt) {
		fprintf(stderr, "!!Warning!! - Lost variables %d seen but %d created\n", cnt, Cvariable::g_hash_cnt);
		sanity_trap();
	}

	cnt = 0;
	for (i = 0; i < HASHSIZE; ++i) {
		for (functionP = Cfunction::g_hash[i]; functionP; functionP = functionP->m_hashP) {
			++cnt;
	}	}
	if (cnt != Cfunction::g_hash_cnt) {
		fprintf(stderr, "!!Warning!! - Lost functions %d seen but %d created\n", cnt, Cfunction::g_hash_cnt);
		sanity_trap();
	}

	cnt = 0;
	for (i = 0; i < HASHSIZE; ++i) {
		for (edgeP = Cedge::g_hash[i]; edgeP; edgeP = edgeP->m_hashP) {
			++cnt;
	}	}
	if (cnt != Cedge::g_hash_cnt) {
		fprintf(stderr, "!!Warning!! - Lost edges %d seen but %d created\n", cnt, Cedge::g_hash_cnt);
		sanity_trap();
	}
}

