#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "file.h"
#include "directory.h"
#include "archive.h"
#include "source.h"

Csource			*Csource::g_headP     = 0;
Csource			*Csource::g_tailP     = 0;
unsigned int	Csource::g_cnt        = 0;

/* Source is preserved in the order visited */

Csource::Csource(char *pathP, Centity *rootP)
{
	Cdirectory		*directoryP;
	const char		*filenameP;

	m_nextP      = 0;
	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;
	++g_cnt;

	m_argsPP   = 0;
	directoryP = (Cdirectory *) Cdirectory::locate(pathP, rootP);
	m_parentP  = directoryP;
	if (directoryP) {
		directoryP->m_child_dir = 2;
	}

	filenameP  = strrchr(pathP, '/');
	if (filenameP) {
		++filenameP;
	} else {
		filenameP = pathP;
	}
	name(filenameP);
}

/* static */ Csource *
Csource::lookup(char *pathP)
{
	int			c, diff;
	char		*filenameP, *dirnameP, *P1;
	const char	*dirname1P;
	Csource		*sourceP;
	Centity		*parentP;

	filenameP = strrchr(pathP, '/');
	if (filenameP) {
		++filenameP;
	} else {
		filenameP = pathP;
	}
	
	for (sourceP = g_headP; sourceP; sourceP = sourceP->m_nextP) {
		if (strcmp(sourceP->m_nameP, filenameP)) {
			// Different source file name
			continue;
		}
		dirnameP = filenameP;
		for (parentP = sourceP->m_parentP;; parentP = parentP->m_parentP) {
			if (!parentP || parentP->type() != directoryE) {
				if (dirnameP == pathP) {
					return(sourceP);
				}
				break;
			}

			if (dirnameP == pathP) {
				break;
			}
			dirname1P = ((Cdirectory *) parentP)->m_nameP;

			P1 = --dirnameP;
			if (P1 != pathP) {
				/* Otherwise P1="/" ie root represented by "" */

				for (dirnameP = P1 - 1; ; --dirnameP) {
					if (*dirnameP == '/') {
						++dirnameP;
						break;
					}
					if (dirnameP == pathP) {
						break;
					}
			}	}
			c    = *P1;
			*P1  = 0;
			diff = strcmp(dirnameP, dirname1P);
			*P1  = c;
			if (diff) {
				// This source is under a different path from the one desired
				break;
	}	}	}

	/* Didn't find if get here */

	return(0);
}

/* static */ Csource *
Csource::locate(char *pathP, Centity *rootP)
{
	Csource		*sourceP;

	sourceP = lookup(pathP);
	if (!sourceP) {
		sourceP = new Csource(pathP, rootP);
		if (!sourceP) {
			outofmemory();
	}	}
	return(sourceP);
}

int
Csource::full_path(char *bufferP) const
{
	int	lth;

	if (m_parentP) {
		lth = m_parentP->full_path(bufferP);
	} else {
		lth = 0;
	}
	strcpy(bufferP+lth, m_nameP);
	lth += strlen(m_nameP);
	return(lth);
}

void
Csource::print(void) const
{
	if (m_parentP) {
		if (m_parentP->type() == directoryE) {
			m_parentP->print();
			fputc('/', stdout);
	}	}
	fputs(m_nameP, stdout);
}

/* virtual */ objectE
Csource::type(void) const
{
	return(sourceE);
}

/* virtual */ void
Csource::emit_id(void) const
{
	fprintf(stdout, "S%u", m_id);
}

/* virtual */ void
Csource::emit_instance(void) const
{
	fputs("$INSTANCE ", stdout);
	emit_id();
	fputs(" S\n", stdout);
}

void
Csource::emit_attributes(void) const
{
	char 	*P, **startPP, **PP;
	char	c;

	emit_id();
	fprintf(stdout, " {label=\"%s\" file=\"./%s\"", m_nameP, m_nameP);

	if ((startPP = m_argsPP)) {
		fputs(" args=(", stdout);
		for (PP = startPP; (P = *PP); ++PP) {
			if (PP != startPP) {
				fputs(", ", stdout);
			}
			fputc('"', stdout);
			for (;;) {
				switch (c = *P++) {
				case 0:
					break;
				case '"':
				case '\\':
					fputc('\\', stdout);
				default:
					fputc(c, stdout);
					continue;
				}
				break;
			}
			fputc('"', stdout);
		}
		fputc(')', stdout);
	}
	fprintf(stdout, "}\n");
}
