#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"
#include "archive.h"

Carchive		*Carchive::g_headP     = 0;
Carchive		*Carchive::g_tailP     = 0;
unsigned int	Carchive::g_cnt        = 0;

/* Archives are preserved in the order visited */

Carchive::Carchive(char *pathP) 
{
	const char *filenameP;

	m_nextP     = 0;
	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;
	++g_cnt;
	m_parentP = Cdirectory::locate(pathP, 0);

	filenameP = strrchr(pathP, '/');
	if (!filenameP) {
		filenameP = pathP;
	} else {
		++filenameP;
	}
	name(filenameP);
}

int
Carchive::full_path(char *bufferP) const
{
	Centity	*parentP;
	int	lth;

	*bufferP = 0;
	if ((parentP = m_parentP)) {
		lth = parentP->full_path(bufferP);
	}
	strcpy(bufferP+lth, m_nameP);
	lth += strlen(m_nameP);
	return(lth);
}

/* virtual */ objectE
Carchive::type(void) const
{
	return(archiveE);
}

/* virtual */ void
Carchive::emit_id(void) const
{
	fprintf(stdout, "A%p", this);
}

/* virtual */ void
Carchive::emit_instance(void) const
{
	fprintf(stdout, "$INSTANCE A%p A\n", this);
}

void
Carchive::emit_attributes(void) const
{
	emit_id();
	fprintf(stdout, " {label=\"%s\" file=\"./%s\"}\n", m_nameP, m_nameP);
}

void
Carchive::print(void) const
{
	fputs(m_nameP, stdout);
}
