#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"
#include "source.h"
#include "file.h"
#include "class.h"
#include "classmember.h"

Cclass			*Cclass::g_headP     = 0;
unsigned int	Cclass::g_cnt        = 0;

Cclass::Cclass(char *nameP)
{
	name(nameP);
	m_parentP = 0;
	m_nextP   = g_headP;
	g_headP   = this;
	++g_cnt;
	m_fileP   = 0;
	m_lineno  = 0;
	m_flags   = 0;
}

void
Cclass::reset(void)
{
	Cclass	*classP;

	for (classP = g_headP; classP; classP = classP->m_nextP) {
		// Hide all classes after a reset
		classP->m_flags |= InvisibleX;
}	}

Cclass *
Cclass::find(char *nameP)
{
	Cclass	*classP;

	for (classP = g_headP; classP; classP = classP->m_nextP) {
		if (!strcmp(classP->m_nameP, nameP)) {
			if (!(classP->m_flags & InvisibleX)) {
				break;
	}	}	}
	return(classP);
}

Cclass *
Cclass::locate(char *nameP)
{
	Cclass	*classP;

	classP = find(nameP);
	if (!classP) {
		classP = new Cclass(nameP);
	}
	return classP;
}

/* virtual */ objectE
Cclass::type(void) const
{
	return(classE);
}

/* virtual */ void
Cclass::emit_id(void) const
{
	fprintf(stdout, "C%p", this);
}

/* virtual */ void
Cclass::emit_edges(void)
{
	fprintf(stdout, "contain C C%p\n", this);
}

/* virtual */ void
Cclass::emit_instance(void) const
{
	fprintf(stdout, "$INSTANCE C%p C\n", this);
}

void
Cclass::emit_attributes(void) const
{
	emit_id();
	fputs(" {", stdout);
	fprintf(stdout, "label=\"%s\"", m_nameP);
	if (m_fileP) {
		fprintf(stdout, " file=\"%s\" lineno=%d", m_fileP->m_nameP, m_lineno);
	}
	fputs("}\n", stdout);
}

/* virtual */ void
Cclass::print(void) const
{
	fprintf(stdout, "%s::", m_nameP);
}
