#include <assert.h>
#include <alloca.h>
#include <string.h>
#include <stdio.h>
#include "util.h"
#include "object.h"
#include "classmember.h"
#include "template.h"
#include "class.h"
#include "signature.h"

/* static */ unsigned int
Cclassmember::hash(const char *nameP)
{
	int		ret  = 0;
	int		c;
	const	char *P;

	for (P = nameP; (c = *P) ; ++P) {
		ret  += c;
		ret <<= 1;
		if (ret & HASHSIZE) {
			ret |= 1;
	}	}
	return(ret & (HASHSIZE-1));
}

/* static */ void
Cclassmember::find_class(char *mangled_nameP, Cclass **classPP, Ctemplate **templatePP)
{
	Csignature	signature;
	Cfragment	*nsP, *csP;
	char		*endP, *namespaceP, *classnameP, *bufferP, *P;
	Cclass		*classP;
	int			c, namespace_lth, classname_lth, lth;

	*classPP = 0;
	if (templatePP) {
		*templatePP = 0;
	}
	endP     = signature.signature(mangled_nameP);
	if (endP) {
		csP = &signature.m_name.m_classname;
		if ((classnameP   = csP->m_value.m_stringP)) {
			classname_lth = csP->m_value.m_lth;
			nsP           = &signature.m_name.m_ns;
			namespaceP    = nsP->m_value.m_stringP;
			if (namespaceP) {
				namespace_lth = nsP->m_value.m_lth;
				lth           = classname_lth + namespace_lth + 2;
				bufferP = P = (char *) alloca(lth + 1);
				strncpy(P, namespaceP, namespace_lth);
				P      += namespace_lth;
				strcpy(P, "::");
				P      += 2;
				strncpy(P, classnameP, classname_lth);
				classnameP    = bufferP;
				classname_lth = lth;
			}
			endP   = classnameP + classname_lth;
			c      = *endP;
			*endP  = 0;
			classP = Cclass::locate(classnameP);
			*endP  = c;
			*classPP = classP;
			if (templatePP) {
				if ((P = signature.m_templateP)) {
					*templatePP = Ctemplate::locate(P);
}	}	}	}	}

Cclassmember::Cclassmember(const char *nameP)
{
	Cclass		*classP;
	Ctemplate	*templateP;

	name(nameP);
	m_fileP   = 0;
	m_lineno  = 0;
	m_parentP = 0;
	m_flags   = 0;
	// Create the class for this member
	Cclassmember::find_class(m_nameP, &classP, &templateP);
}

void
Cclassmember::emit_class(void) const
{
	Cclass		*classP;
	Ctemplate	*templateP;

	if (!(m_flags & AddressesX)) {
		Cclassmember::find_class(m_nameP, &classP, &templateP);
		if (classP) {
			fputs("M ", stdout);
			classP->emit_id();
			fputc(' ', stdout);
			emit_id();
			fputc('\n', stdout);
		}
		if (templateP) {
			fputs("MT ", stdout);
			templateP->emit_id();
			fputc(' ', stdout);
			emit_id();
			fputc('\n', stdout);
}	}	}

