#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"

Cdirectory		*Cdirectory::g_headP     = 0;
Cdirectory		*Cdirectory::g_tailP     = 0;
Cdirectory		*Cdirectory::g_collapseP = 0;
unsigned int	Cdirectory::g_cnt        = 0;

void
Cdirectory0::print(void) const
{
	Cdirectory	*parentP;

	parentP = (Cdirectory *) m_parentP;
	if (parentP) {
		parentP->print();
		fputc('/', stdout);
	}

	if (*m_nameP) {
		fputs(m_nameP, stdout);
	} else {
		fputc('/', stdout);
}	}

Cdirectory::Cdirectory(Centity *parentP, const char *filenameP)
{
	m_nextP     = 0;
	if (!g_headP) {
		g_headP = this;
	} else {
		g_tailP->m_nextP = this;
	}
	g_tailP = this;
	++g_cnt;

	m_parentP   = parentP;
	m_child_dir = 0;
	name(filenameP);
}

/* Find the directory at the bottom of  the directory path pathP, occuring
 * whose root directory occurs under rootP
 */

Centity *
Cdirectory::locate(char *pathP, Centity *rootP)
{
	Centity		*leafP;
	char		*dirnameP;
	char		*endP;
	Cdirectory	*fromP;

	leafP    = rootP;
	dirnameP = pathP;
descend:
	endP = strchr(dirnameP, '/');
	if (!endP) {
		goto done;
	}
	*endP = 0;
	for (fromP = g_headP; fromP; fromP = fromP->m_nextP) {
		if (fromP->m_parentP == leafP  && !strcmp(fromP->m_nameP, dirnameP)) {
			leafP    = fromP;
			*endP    = '/';
			dirnameP = endP+1;
			goto descend;
	}	}

	// Directory not found

	for (;;) {
		leafP = new Cdirectory(leafP, dirnameP);
		*endP    = '/';
		dirnameP = endP+1;
		endP     = strchr(dirnameP, '/');
		if (!endP) {
			break;
		}
		*endP = 0;
	}
done:
	return(leafP);
}

int
Cdirectory::full_path(char *bufferP) const
{
	int	lth;

	if (m_parentP) {
		lth = m_parentP->full_path(bufferP);
	} else {
		lth = 0;
	}
	strcpy(bufferP+lth, m_nameP);
	lth += strlen(m_nameP);
	bufferP[lth++] = '/';
	return(lth);
}

/* virtual */ objectE
Cdirectory::type(void) const
{
	return(directoryE);
}

/* virtual */ void
Cdirectory::emit_id(void) const
{
	fprintf(stdout, "D%p", this);
}

/* virtual */ void
Cdirectory::emit_instance(void) const
{
	fprintf(stdout, "$INSTANCE D%p D\n", this);
}

void
Cdirectory::emit_attributes(void) const
{
	const char *nameP;
	const char *prefixP;

	nameP = m_nameP;
	if (!*m_nameP) {
		nameP = "/";
	}
	if (*nameP == '/') {
		prefixP = "";
	} else {
		prefixP = "./";
	}
	emit_id();
	fprintf(stdout, " {label=\"%s\" file=\"%s%s\"}\n", nameP, prefixP, nameP);
}
