#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "classmember.h"
#include "directory.h"
#include "source.h"
#include "file.h"
#include "function.h"
#include "edge.h"

Cedge			*Cedge::g_hash[HASHSIZE] = {0};
unsigned int	Cedge::g_hash_cnt        = 0;

/*
void
trap_edge(void)
{
	fprintf(stderr,"**Trapped Edge**\n");
}
*/

unsigned int
Cedge::hash(const Centity *fromP, const Cclassmember *toP)
{
	int		ret;

	ret = (int) ((((long) fromP) + ((long) toP)) >> 3);
	return(ret & (HASHSIZE-1));
}

Cedge::Cedge(Centity *fromP, Cclassmember *toP, int lineno, Cfile *fileP)
{
	unsigned int index;

/*
	if (!strcmp(toP->m_nameP, "_ZZ4doitP1AE1k")) {
		trap_edge();
	}
*/
	m_fileP  = fileP;
	m_lineno = lineno;
	m_fromP  = fromP;
	m_toP    = toP;
	m_freq   = 0;
	m_flags  = 0;

	index = hash(fromP, toP);
	m_hashP       = g_hash[index];
	g_hash[index] = this;
	++g_hash_cnt;
}

Cedge *
Cedge::locate(Centity *fromP, Cclassmember *toP, int lineno, Cfile *fileP)
{
	Cedge 			*edgeP;
	unsigned int	index;

	index = hash(fromP, toP);
	for (edgeP = g_hash[index]; edgeP; edgeP = edgeP->m_hashP) {
		if (edgeP->m_fromP == fromP && edgeP->m_toP == toP) {
			return(edgeP);
	}	}
	edgeP = new Cedge(fromP, toP, lineno, fileP);
	if (!edgeP) {
		outofmemory();
	}
	return(edgeP);
}

/* Allow for the fact that the same function signature may occur in multiple
 * files:
 *
 * Make the function being called the one in the same source if present
 */

/* virtual */ objectE
Cedge::type(void) const
{
	return(edgeE);
}

const char *
Cedge::get_type(void) const
{
	const char 	*typeP;
	int			flags;

	flags = m_toP->m_flags;
	if (m_toP->type() == variableE) {
		if (flags & FunctionX) {
			typeP = "CIF";
		} else if (flags & AddressesX) {
			typeP = "UVA";
		} else if (m_flags & UpdateX) {
			if (flags & ExternalX) {
				typeP = "UEV";
			} else if (flags & DynamicX) {
				if (flags & NotParamX) {
					typeP = "ULV";
				} else {
					typeP = "UPV";
				}
			} else if (!(flags & LocalX)) {
				typeP = "UGV";
			} else if (flags & NestedX) {
				typeP = "UFV";
			} else {
				typeP = "USV";
			}
		} else {
			if (flags & ExternalX) {
				typeP = "REV";
			} else if (flags & DynamicX) {
				if (flags & NotParamX) {
					typeP = "RLV";
				} else {
					typeP = "RPV";
				}
			} else if (!(flags & LocalX)) {
				typeP = "RGV";
			} else if (flags & NestedX) {
				typeP = "RFV";
			} else {
				typeP = "RSV";
			}
		}
	} else {
		if (m_flags & VirtualX) {
			typeP = "CVF";
		} else if (flags & ExternalX) {
			typeP = "CEF";
		} else if (!(flags & LocalX)) {
			typeP = "CGF";
		} else {
			typeP = "CLF";
	}	}
	return(typeP);
}

/* virtual */ void
Cedge::emit_id(void) const
{
	fprintf(stdout, "%s ", get_type());
	m_fromP->emit_id();
	fputc(' ', stdout);
	m_toP->emit_id();
}

/* virtual */ void
Cedge::print(void) const
{
	fputc('(', stdout);
	emit_id();
	fputc(')', stdout);
}

void
Cedge::emit_edges(void)
{
	if (!(m_toP->m_flags & IgnoreX)) {
		emit_id();
		fputc('\n', stdout);
	}
}

void
Cedge::emit_attributes(void) const
{
	if (!(m_fromP->m_flags & IgnoreX) && !(m_toP->m_flags & IgnoreX)) {
		print();
		fputs(" {", stdout);

		if (m_fileP) {
			char	*filenameP = m_fileP->m_nameP;
			char 	path_to_me[2048];

			path_to_me[0] = 0;
			m_fromP->full_path(path_to_me);

			// TODO: Improve this logic using ../ etc.
			if (!strcmp(filenameP, path_to_me)) {
				filenameP = ".";
			}

			fprintf(stdout, "file=\"%s\" lineno=%d ", filenameP, m_lineno);
		}
		fprintf(stdout, "freq=%d}\n", m_freq);
}	}
