#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "classmember.h"
#include "class.h"
#include "directory.h"
#include "source.h"
#include "collection.h"
#include "file.h"
#include "function.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

Cfunction		*Cfunction::g_hash[HASHSIZE] = {0};
unsigned int	Cfunction::g_hash_cnt        = 0;

/*
static void
trap_function(void)
{
}
*/

Cfunction::Cfunction(const char *nameP) : Cclassmember(nameP)
{
	int	c;

	m_hashP     = 0;
	m_vtable    = -1;
	if (nameP[0] != '_') {
		m_demangleP = 0;
	} else {
		if (nameP[1] == 'Z' && nameP[2] == 'T' && 
			((c = nameP[3]) == 'h' || c == 'v' || c == 'c')) {
			m_flags |= ThunkX;
		}
		// This is a malloced string
		m_demangleP = cplus_demangle(nameP, DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3);
	}
}

void
Cfunction::reset(void)
{
	int 		i;
	Cfunction	*functionP;

	for (i = 0; i < HASHSIZE; ++i) {
		for (functionP = g_hash[i]; functionP; functionP = functionP->m_hashP) {
			// Hide all functions after a reset
			functionP->m_flags |= InvisibleX;
}	}	}

// Test to see if this reference to a variable might map to a function

Cfunction **
Cfunction::exists(const char *nameP, int flags, const Centity *sourceP)
{
	unsigned int	index;
	Cfunction		**functionPP, **bestPP, *functionP;
	Csource			*parentP;

/*
	if (!strcmp(nameP, "get_value")) {
		trap_function();
	}
*/
	bestPP = 0;
	index  = hash(nameP);
	for (functionPP = g_hash + index; (functionP = *functionPP); functionPP = &(functionP->m_hashP)) {
		if (strcmp(functionP->m_nameP, nameP)) {
			// This function has the wrong name
			continue;
		}
		if (functionP->m_flags & InvisibleX) {
			// This function hidden by a reset
			continue;
		}
		parentP = (Csource *) functionP->m_parentP;
		if (sourceP && sourceP == parentP) {
			// The function in our source is always the preferred one
			bestPP = functionPP;
			break;
		}

		if ((flags & LocalX) || (functionP->m_flags & LocalX)) {
			// If we know the function we are looking for is local
			// we expect it to already be defined to be local in
			// pass1 and thus to have the same parentP as sourceP
			// On the other hand if we know that the function
			// found is local we know we can't see it if its
			// parentP is not the sourceP we are calling it from
			continue;
		}
		if (!(flags & FindX) && parentP && sourceP) {
			// We want to locate the function in sourceP and we know
			// that this function is not in sourceP but in parentP	
			continue;
		}
		bestPP = functionPP;
	}
	if (!bestPP) {
		bestPP = functionPP;
	}
	return bestPP;
}

Cfunction *
Cfunction::locate(char *nameP, int flags, Centity *sourceP)
{
	Cfunction	**bestPP, *functionP, *bestP;

/*
	if (!strcmp(nameP, "get_value")) {
		trap_function();
	}
*/
	bestPP = exists(nameP, flags, sourceP);
	bestP  = *bestPP;

	if (bestP) {
		if (!(flags & FindX) && !bestP->m_parentP && sourceP) {
			/* This function was earlier called from outside our source
			 * by something which didn't know where to find it
			 * Presume we are the location of the called function */

			bestP->m_parentP = sourceP;
		}
		return bestP;
	}

	functionP = new Cfunction(nameP);
	if (!functionP) {
		outofmemory();
	}
	/* Add to end so always return first function declaration seen if
	 * searching for location of the function declaration:
	 *
     * eg. if we are looking for foo() and foo() was in foo.c later
     *     also seen in foo.o return reference to foo.c:foo() in
	 *     preferance to foo.o:foo()
     */
	if (!(flags & FindX) && sourceP) {
		functionP->m_parentP = sourceP;
	}
	*bestPP = functionP;
	++g_hash_cnt;
	return(functionP);
}

void
Cfunction::resolve(void)
{
	Csource 	*sourceP;
	Cfunction	*functionP;
	char		*nameP;
	int			i;

	sourceP = 0;
	for (i = 0; i < HASHSIZE; ++i) {
		for (functionP = g_hash[i]; functionP; functionP = functionP->m_hashP) {

			nameP = functionP->m_nameP;
			if (nameP[0] == '_' && nameP[1] == 'Z' && nameP[2] == 'T') {
				Cclass *classP;

				switch (nameP[3]) {
				case 'h':	// Thunk
				case 'v':	// Thunk
				case 'c':	// Thunk
					// Thunks always are contained under class if the class
					// can be determined
					Cclassmember::find_class(nameP, &classP, 0);
					if (classP) {
						functionP->m_parentP = classP;
			}	}	}

			if (!functionP->m_parentP) {
				if (!sourceP) {
					sourceP    = new Ccollection(":library:", 0);
					if (!sourceP) {
						outofmemory();
					}
				}
				functionP->m_parentP = sourceP;
				functionP->m_flags  |= ExternalX;
}	}	}	}

/* virtual */ objectE
Cfunction::type(void) const
{
	return(functionE);
}

/* virtual */ void
Cfunction::emit_id(void) const
{
	fprintf(stdout, "F%p", this);
}

const char *
Cfunction::get_type(void) const
{
	int			flags;
	const char 	*typeP;

	flags = m_flags;
	if (flags & ThunkX) {
		typeP = "TH";
	} else if (flags & VirtualX) {
		typeP = "VF";
	} else if (flags & LocalX) {
		typeP = "LF";
	} else if (flags & ExternalX) {
		typeP = "EF";
	} else {
		typeP = "GF";
	}
	return(typeP);
}

/* virtual */ void
Cfunction::emit_edges(void)
{
	Cclassmember::emit_edges();
	if (Cclass::g_headP) {
		emit_class();
	}
}
		
/* virtual */ void
Cfunction::emit_instance(void) const
{
	fprintf(stdout, "$INSTANCE F%p %s\n", this, get_type());
/*
	if (!strcmp(m_nameP, "_Z41__static_initialization_and_destruction_0ii") && !strcmp(m_parentP->m_nameP, "as_license.cpp")) {
		trap_function();
	}
*/
}

void
Cfunction::emit_attributes(void) const
{
	const char 	*nameP;
	char		*demangleP;

	emit_id();
	fputs(" {", stdout);

	nameP     = m_nameP;
	demangleP = m_demangleP;
	if (demangleP) {
		fprintf(stdout,"mangle=\"%s\" ", nameP);
		nameP = demangleP;
	}
	fprintf(stdout, "label=\"%s\" ", nameP);
	if (m_vtable != -1) {
		fprintf(stdout, "vtable=%d ", m_vtable);
	}
	if (m_fileP) {
		char	*filenameP = m_fileP->m_nameP;
		char 	path_to_me[2048];

		path_to_me[0] = 0;
		full_path(path_to_me);

		// TODO: Improve this logic using ../ etc.
		if (!strcmp(filenameP, path_to_me)) {
			filenameP = ".";
		}
		fprintf(stdout, "file=\"%s\" lineno=%d", filenameP, m_lineno);
	}

	fputs("}\n", stdout);
}

/* virtual */ void
Cfunction::print(void) const
{
	fputs(m_nameP, stdout);
}
