typedef enum {
	entityE    = 0,	
	directoryE = 1,
	archiveE   = 2,
	sourceE    = 3,
	unitE      = 4,
    fileE      = 5,
	functionE  = 6,
	variableE  = 7,
	edgeE      = 8,
	classE     = 9,
	templateE  = 10
} objectE;

class Cobject {
public:
	static Cobject		*g_emitted_headP;
	static Cobject		*g_emitted_tailP;
	static unsigned int	g_cnt;

	Cobject			*m_emitted_nextP;		/* List in the order emitted */

	Cobject(void);
	virtual ~Cobject(void) {}

	void add_emitted(void);

	virtual void 	emit_id(void) const   = 0;
	virtual objectE	type(void) const      = 0;
	virtual void	print(void) const     = 0;
	virtual void	emit_edges(void)      = 0;
	virtual void	emit_attributes(void) const = 0;
};

#define LocalX 		0x01	/* This variable is initialised			*/
#define NestedX		0x02	/* This variable is inside a function	*/
#define DynamicX	0x04	/* This is a dynamic stack variable		*/
#define NotParamX	0x08	/* This is not a parameter				*/
#define WeakX		0x10	/* This is a weak data variable			*/
#define UsedX		0x20	/* This variable is used				*/
#define InitX 		0x40	/* This local source function/variable	*/
#define OnlistX		0x80	/* Already on the nested list			*/
#define AddressesX	0x100	/* This variable is an address 			*/
#define VariableX	0x200	/* This variable is a variable address	*/
#define FunctionX	0x400	/* This variable is a function address  */
#define VirtualX	0x1000	/* This is a virtual function			*/
#define ThunkX		0x2000	/* This is a thunk					    */
#define ExternalX	0x4000	/* This item is not defined in source	*/
#define IgnoreX		0x10000	/* Don't emit this class member			*/
#define InvisibleX	0x20000	/* This item is now invisible			*/
#define FindX		0x40000	/* Find variable anywhere				*/

class Centity : public Cobject {
public:
	Centity	*m_parentP;
	char	*m_nameP;
	int		m_flags;

	Centity(void);
	virtual ~Centity(void);

	void			name(const char *nameP);
	void			add_class(void) const;
	virtual void	emit_edges(void);
	virtual int		full_path(char *bufferP) const;
};

