class Clth_string {
public:
	int		m_lth;
	char	*m_stringP;
	
	void reset(void) {
		m_lth 	  = 0;
		m_stringP = 0;
	}
	Clth_string(void) { reset(); }

	void dump(FILE *F, const char *prefixP);
	int	 same(const Clth_string *otherP) const;
};

class Cfragment {
public:
	Clth_string	m_type;
	Clth_string	m_value;

	void reset (void) {
		m_type.reset();
		m_value.reset();
	}
	void dump(FILE *F, const char *prefixP);
};

class Cfragments {
public:
	Cfragment	m_ns;
	Cfragment	m_classname;
	Cfragment	m_name;
	Cfragment	m_discriminator;	// Only used for local names
	Cfragment	m_type;
	
	void reset(void) {
		m_ns.reset();
		m_classname.reset();
		m_name.reset();
		m_discriminator.reset();
		m_type.reset();
	}
	void dump(FILE *F, const char *prefixP);
};

class Csignature {
private:

	const char	*m_startP;	// Start of input signature
	Cfragments	*m_nameP;	// Item being loaded else null
	
	void reset(void);
	static void fail(void);
	void saw_ns(char *typeP, int type_lth, char *valueP, int lth);
	void saw_name(char *typeP, int type_lth, char *valueP, int lth);
	void saw_discriminator(char *valueP, int lth);
	void saw_type(char *valueP, int lth);
	static char *end_call_offset(char *startP);
	char *end_source_name(char *startP);
	char *end_operator_name(char *startP);
	char *end_unqualified_name(char *startP);
	static char *end_template_param(char *startP);
	char *end_expr_primary(char *startP);
	char *end_template_arg(char *startP);
	char *end_template_args(char *startP);
	char *end_simple_id(char *startP);
	char *end_base_unresolved_name(char *startP);
	char *end_decltype(char *startP);
	char *end_unresolved_type(char *startP);
	char *end_unresolved_name(char *startP);
	char *end_cv_qualifiers(char *startP);
	char *end_function_param(char *startP);
	char *end_initializer(char *startP);
	char *end_expression(char *startP);
	char *end_substitution(char *startP);
	char *end_name(char *startP);
	char *end_type(char *startP);
	char *end_bare_function_type(char *startP);
	char *end_encoding(char *startP);
	char *end_mangled_name(char *startP);
public:
	Cfragments	m_name;
	Cfragments	m_localname;
	char 		*m_templateP;

	Csignature(void);
	~Csignature(void);

	void dump(FILE *F);

	char *signature(char *startP);
	int	 same_class(const Csignature *signatureP) const;
	int	 same_function_name(const Csignature *signatureP) const;
};

