#include <malloc.h>
#include <stdio.h>
#include "signature.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

int
main(int argc, char **argv)
{
	Csignature	signature;
	char 		buffer[1024];
	char		*demangleP;

	while (gets(buffer)) {
		fprintf(stdout, "mangle=\"%s\"\n", buffer);
		fflush(stdout);
		if (signature.signature(buffer)) {
			printf("signature: ");
			signature.dump(stdout);
			printf("\n");
		} else {
			printf("signature failed\n");
		}
		fflush(stdout);
		demangleP = cplus_demangle(buffer, 
				DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3/*|DMGL_RET_POSTFIX*/);
		if (!demangleP) {
			printf("demangle failed\n");
		} else {
			printf("expand=\"%s\"\n", demangleP);
			free(demangleP);
		}
		fflush(stdout);
	}
	return(0);
}
