#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "util.h"
#include "object.h"
#include "directory.h"
#include "source.h"
#include "file.h"
#include "class.h"
#include "classmember.h"

#define basename FUDGE_BASENAME
#include "demangle.h"
#undef basename

Cclass			*Cclass::g_headP     = 0;
unsigned int	Cclass::g_cnt        = 0;

Cclass::Cclass(char *nameP)
{
	name(nameP);
	m_parentP = 0;
	m_nextP   = g_headP;
	g_headP   = this;
	++g_cnt;
	m_fileP   = 0;
	m_lineno  = 0;
	m_flags   = 0;
}

void
Cclass::reset(void)
{
	Cclass	*classP;

	for (classP = g_headP; classP; classP = classP->m_nextP) {
		// Hide all classes after a reset
		classP->m_flags |= InvisibleX;
}	}

Cclass *
Cclass::find(char *nameP)
{
	Cclass	*classP;

	for (classP = g_headP; classP; classP = classP->m_nextP) {
		if (!strcmp(classP->m_nameP, nameP)) {
			if (!(classP->m_flags & InvisibleX)) {
				break;
	}	}	}
	return(classP);
}

Cclass *
Cclass::locate(char *nameP)
{
	Cclass	*classP;

	classP = find(nameP);
	if (!classP) {
		classP = new Cclass(nameP);
	}
	return classP;
}

/* virtual */ objectE
Cclass::type(void) const
{
	return(classE);
}

/* virtual */ void
Cclass::emit_id(void) const
{
	fprintf(stdout, "C%u", m_id);
}

/* virtual */ void
Cclass::emit_edges(void)
{
	fputs("contain C ", stdout);
	emit_id();
	fputc('\n', stdout);
}

/* virtual */ void
Cclass::emit_instance(void) const
{
	fprintf(stdout, "$INSTANCE C%u C\n", m_id);
}

void
Cclass::emit_attributes(void) const
{
	char	*labelP;
	char	*demangleP;

	emit_id();
	fputs(" {", stdout);

	labelP    = m_nameP;
	demangleP = cplus_demangle(labelP, DMGL_ANSI|DMGL_PARAMS|DMGL_GNU_V3);
	if (demangleP) {
		labelP = demangleP;
	}
	fprintf(stdout, "label=\"%s\"", labelP);
	if (demangleP) {
		free(demangleP);
	}
	if (m_fileP) {
		fprintf(stdout, " file=\"%s\" lineno=%d", m_fileP->m_nameP, m_lineno);
	}
	fputs("}\n", stdout);
}

/* virtual */ void
Cclass::print(void) const
{
	fprintf(stdout, "%s::", m_nameP);
}
