#include <assert.h>
#include <string.h>
#include <stdio.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"

// #define SANITY

Cobject			*Cobject::g_emitted_headP = 0;
Cobject			*Cobject::g_emitted_tailP = 0;
unsigned int	Cobject::g_cnt            = 0;

void
Cobject::add_emitted()
{
	assert(m_emitted_nextP == (Cobject *) -1);
	m_emitted_nextP = 0;
	if (!g_emitted_headP) {
		g_emitted_headP = this;
	} else {
		g_emitted_tailP->m_emitted_nextP = this;
	}
	g_emitted_tailP = this;
	++g_cnt;
}

Cobject::Cobject(void)
{
	static unsigned int id = 0;

#ifdef SANITY
	extern void sanity();

	sanity();
#endif

	m_id            = ++id;
	m_emitted_nextP = (Cobject *) -1;
}

Centity::Centity(void)
{
	m_parentP       = 0;
	m_nameP         = 0;
	m_flags         = 0;
}

void
Centity::name(const char *nameP)
{
	if (m_nameP) {
		Xfree(m_nameP);
		m_nameP = 0;
	}
	if (nameP) {
		m_nameP = (char *) Xmalloc(strlen(nameP) + 1);
		strcpy(m_nameP, nameP);
		return;
	}
}

int
Centity::full_path(char *bufferP) const
{
	int	lth;

	if (m_parentP) {
		lth = m_parentP->full_path(bufferP);
	} else {
		lth = 0;
	}
	return(lth);
}

/* virtual */ void
Centity::emit_edges(void)
{
	if (m_parentP) {
		fputs("contain ", stdout);
		m_parentP->emit_id();
		fputc(' ', stdout);
		emit_id();
		fputc('\n', stdout);
}	}

Centity::~Centity(void)
{
	Xfree(m_nameP);
}
