#include <assert.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>

#include "xmalloc.h"
#include "util.h"
#include "signature_buffer.h"
#include "signature.h"

#define TESTING

int	Csignature_buffer::m_mode  = buffer_unknownE;

Csignature_buffer::Csignature_buffer(void)
{
	m_lth 	  = -1;
	m_max     = 0;
	m_bufferP = 0;
}

Csignature_buffer::~Csignature_buffer(void)
{
	Xfree(m_bufferP);
}

void
Csignature_buffer::invalidate(void)
{
	m_lth = -1;
}

void
Csignature_buffer::append(const char *startP, int lth)
{
	int	new_lth;

	if (!lth) {
		return;
	}
	assert(lth > 0);
	new_lth = m_lth + lth;
	if (m_max <= new_lth) {
		if (!m_max) {
			m_max = 64;
		}
		for (;;) {
			m_max <<= 1;
			if (m_max <= new_lth) {
				continue;
			}
			m_bufferP = (char *) Xrealloc(m_bufferP, m_max);
			break;
	}	}
	memcpy(m_bufferP+m_lth, startP, lth);
	m_lth += lth;
}

void
Csignature_buffer::expand(const Csignature_node *nodeP)
{
	const Csignature_node 	*childP;
	const char				*P, *startP, *endP;

	startP = nodeP->m_startP;
	endP   = nodeP->m_endP;
	childP = nodeP->m_childP;

	switch (nodeP->m_type) {
	case SIGNATURE_substitution:
		if (childP) {
			expand(childP);
		} else {
			append(startP, endP-startP);
		}
		return;
	case SIGNATURE_cv_qualifiers:
		if (m_mode == buffer_classnameE) {
			// Skip the qualifiers
			return;
		}
		break;
	case SIGNATURE_prefix:
		if (m_mode == buffer_function_nameE) {
			// Skip the first prefix seen
			m_mode = buffer_functionE;
			return;
		}
		break;
	case SIGNATURE_source_name:
		if (m_mode == buffer_function_nameE) {
			// permit later prefixes
			m_mode = buffer_functionE;
		}
		break;
	case SIGNATURE_template_args:
		if (m_mode == buffer_templateE) {
			return;
		}
		break;
	case SIGNATURE_template_param:
		if (m_mode == buffer_templateE) {
			int		lth;
			char	number[32];
			char	name[32];

			sprintf(name, "T%ld", nodeP->m_value);
			lth = strlen(name);
			sprintf(number, "%d", lth);
			append(number, strlen(number));
			append(name, lth);
			return;
		}
	default:
		break;
	}
	for (P = startP; childP; childP = childP->m_siblingP) {
		append(P, childP->m_startP-P);
		expand(childP);
		P = childP->m_endP;
	}
	append(P, endP-P);
}

const Csignature_node *
Csignature_buffer::classname_root(const Csignature_node *nodeP)
{
	const Csignature_node	*node1P;
	int						under_type = 0;

	// Rapidly descend left branch
	for (node1P = nodeP; node1P; node1P = node1P->m_childP) {
		switch (node1P->m_type) {
		case SIGNATURE_nested_name:
			if (under_type) {
				return node1P;
			}
			node1P = node1P->m_childP;
			switch (node1P->m_type) {
			case SIGNATURE_template_prefix:
				node1P = node1P->m_childP;
				if (node1P->m_type != SIGNATURE_prefix) {
					break;
				}
			case SIGNATURE_prefix:
				return node1P;
			default:
				break;
			}
			return 0;
		case SIGNATURE_source_name:
			if (under_type) {
				return node1P;
			}
			return 0;
		case SIGNATURE_special_name:
			if (node1P->m_startP[0] == 'T') {
				Csignature_node *nextP;

				// Last child of me.
				for (node1P = node1P->m_childP; (nextP = node1P->m_siblingP); node1P = nextP);
				under_type = 1;
				continue;
			}
			return 0;
		default:
			break;
	}	}
	return 0;
}

// Returns empty string if no classname

char *
Csignature_buffer::get_classname(const Csignature_node *nodeP)
{
	if (m_lth < 0) {
		const Csignature_node *rootP;

		if (m_lth == -2) {
			return 0;
		}
		m_lth     = 0;
		rootP = classname_root(nodeP);
		if (!rootP) {
			m_lth = -2;
			return 0;
		}
		m_mode    = buffer_classnameE;

		if (rootP->m_type != SIGNATURE_nested_name) {
			append("_ZN", 3);
			expand(rootP);
			append("E", 1);
		} else {
			append("_Z", 2);
			expand(rootP);
		}
		append("", 1);
	}
	return m_bufferP;
}

const Csignature_node *
Csignature_buffer::template_root1(const Csignature_node *nodeP)
{
	const Csignature_node	*node1P;

	// Rapidly descend left branch
	for (node1P = nodeP; node1P; node1P = node1P->m_childP) {
		switch (node1P->m_type) {
		case SIGNATURE_nested_name:
			node1P = node1P->m_childP;
			if (node1P->m_type != SIGNATURE_template_prefix) {
				return 0;
			}
		case SIGNATURE_template_prefix:
			return node1P;
		default:
			break;
	}	}
	return 0;
}

const Csignature_node *
Csignature_buffer::template_root2(const Csignature_node *nodeP)
{
	const Csignature_node	*node1P;

	// Rapidly descend left branch
	for (node1P = nodeP; node1P; node1P = node1P->m_childP) {
		switch (node1P->m_type) {
		case SIGNATURE_name:
			return node1P->m_siblingP;
		case SIGNATURE_special_name:
			return(0);
		default:
			break;
	}	}
	return 0;
}

char *
Csignature_buffer::get_template(const Csignature_node *nodeP)
{
	if (m_lth < 0) {
		const Csignature_node *rootP;

		if (m_lth == -2) {
			return(0);
		}

		m_lth = 0;
		rootP = template_root1(nodeP);
		if (!rootP) {
			m_lth = -2;
			return(0);
		}
		m_mode = buffer_templateE;

		append("_ZN", 3);
		expand(rootP);
		append("IEE", 3);
		rootP = template_root2(nodeP);
		if (rootP) {
			expand(rootP);
		}
		append("", 1);
	}
	return m_bufferP;
}
			
const Csignature_node *
Csignature_buffer::function_root(const Csignature_node *nodeP)
{
	const Csignature_node	*node1P, *node2P;

	// Rapidly descend left branch
	for (node1P = nodeP; node1P; node1P = node1P->m_childP) {
		switch (node1P->m_type) {
		case SIGNATURE_name:
			node2P = node1P->m_childP;
			if (node2P->m_type == SIGNATURE_local_name) {
				node2P = node2P->m_childP;
				if (node2P->m_type == SIGNATURE_encoding) {
					return node2P;
			}	}
			break;
		case SIGNATURE_special_name:
			return 0;
		default:
			break;
	}	}
	// Print the entire thing
	return nodeP;
}

char *
Csignature_buffer::get_function1(const Csignature_node *nodeP, buffer_modeE mode)
{
	if (m_lth < 0) {
		const Csignature_node *rootP;

		if (m_lth == -2) {
			return 0;
		}
		m_lth     = 0;
		rootP = function_root(nodeP);
		if (!rootP) {
			m_lth = -2;
			return(0);
		}
		if (rootP != nodeP) {
			// If this is a local variable
			// Print the signature it is contained within
			append("_Z", 2);
		}
		m_mode = mode;
		expand(rootP);
		append("", 1);
	}
	return m_bufferP;
}

char *
Csignature_buffer::get_function(const Csignature_node *nodeP)
{
	return get_function1(nodeP, buffer_functionE);
}

char *
Csignature_buffer::get_function_name(const Csignature_node *nodeP)
{
	return get_function1(nodeP, buffer_function_nameE);
}
