#include "typedef.h"

#include <stdio.h>
#include <string.h>

#include "object.h"
#include "util.h"
#include "directory.h"
#include "code.h"
#include "source.h"
#include "clics_output.h"

extern char	*g_clics_fileP;
extern char *g_html_dirP;

extern FILE *stdoutF;
extern FILE	*clicsF;

void
clics_header(int argc, char **argv)
{
	char	*P;
	int		i;

	if (!g_clics_fileP) {
		return;
	}
	P = strchr(g_clics_fileP, '/');
	if (!P && g_html_dirP) {
		sprintf(g_filename, "%s/%s", g_html_dirP, g_clics_fileP);
		P = g_filename;
		fprintf(stdoutF, "<h3>CLICS Output</h3>\n<p>\n<a href=\"%s\">%s</a>\n<p>\n", g_clics_fileP, g_clics_fileP);
	} else {
		P = g_clics_fileP;
	}
	clicsF = open_file(P);

	fprintf(clicsF, "#ACD Version " VERSION " Compiled " __DATE__ ":"  __TIME__ "\n#");

	for (i = 0; i < argc; ++i) {
		fprintf(clicsF,"%s ", argv[i]);
	}
	fputc('\n', clicsF);
}

void
clics_sources(void)
{
	Csource	*sourceP;

	if (clicsF) {
		fputs("start{files}\n", clicsF);
		for (sourceP = Csource::g_headP; sourceP; sourceP = sourceP->m_nextP) {
			if (!sourceP->m_sourcePP) {
				sourceP->load_source();
			}
			fprintf(clicsF, "%d\t%d\t", sourceP->m_number, sourceP->m_source_lines);
			dump_wchar(sourceP->m_nameP, clicsF);
			fputc('\n', clicsF);
		}
		fputs("end{files}\nstart{clones}\n", clicsF);
}	}

void
clics_trailer(void)
{
	if (clicsF) {
		fputs("end{clones}\n", clicsF);
		fclose(clicsF);
	}
}

