
struct codeS;
class Cfunction;

// Make this the largest negative number
#define JUMP_UNDEFINED ((int) 0x80000000)

typedef union {
	int				offset;
	struct	codeS	*P;
} jumpT;

typedef struct codeS {
	struct codeS	*m_hashP;			// The next candidate same instruction
	Cfunction		*m_functionP;		// The function this code belongs to
	struct codeS	*m_matchP;			// The matching instruction else 0
	u4T				m_pc;				// The program counter
	u4T				m_source_lineno;	// Line number in source code
	u1T				m_pcode;			// Instruction type
	u1T				m_pop;				// Number of arguments popped from stack
	u1T				m_push;				// Number of arguments pushed to stack

	union {
		struct {
			union {
				u2T	u1;
				s2T	s1;
			};
			union {
				u2T	u2;
				s2T	s2;
			};
		} m_short;
		u4T			m_u4;
		s4T			m_s4;
		u4T			*m_tableP;
	};
	jumpT			m_jump;
} codeT;

