#include "typedef.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <stdlib.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "ta.h"
#include "code.h"
#include "clone.h"
#include "source.h"
#include "function.h"

/*
static void trap(void)
{
}
*/

static int
relativeToShort(double value)
{
	assert(value >= 0.0);
	assert(value <= 1.0);
	return (int) ((value - 0.5) * 65534.0);
}

extern FILE *taF;
extern FILE	*tempF;

void
Cfunction::emit_ta(void)
{
	Csource	*sourceP;

	sourceP = m_sourceP;
	if (!sourceP->m_has_clones) {
		sourceP->m_has_clones = 1;
		sourceP->emit_ta();
	}

	fprintf(taF, "$INSTANCE F%p F\n", this);
	fprintf(taF, "contain S%p F%p\n", m_sourceP, this);
	fprintf(tempF, "F%p {label=\"%S\" file=\".\"", this, (wchar_t *) m_nameP);
	fprintf(tempF, " lineno=%d", m_codeP->m_source_lineno);
	fputs("}\n", tempF);
}

Cclone *
Cfunction::locate_clone(const codeT *startP, const codeT *endP)
{
	Cclone *cloneP;
	int		start, lth, lth_code;

	for (cloneP = m_clonesP; cloneP; cloneP = cloneP->m_nextP) {
		if (cloneP->m_startP == startP && cloneP->m_endP == endP) {
			return (cloneP);
	}	}
	if (!m_clonesP) {
		emit_ta();
	}
	cloneP = new Cclone(startP, endP);
	cloneP->m_nextP = m_clonesP;
	m_clonesP       = cloneP;

	fprintf(taF, "$INSTANCE C%p C\n", cloneP);
	fprintf(taF, "contain F%p C%p\n", this, cloneP);

	start    = startP - m_codeP;
	lth      = endP   - startP;
	lth_code = m_code_count - start;
	fprintf(tempF, "C%p {label=\"%d+%d\" file=\".\" lineno=%d xrel=%d yrel=%d}\n",
		cloneP,
		start, lth,
		startP->m_source_lineno,
		relativeToShort(((double) start)/((double) lth_code)),
		relativeToShort(((double) lth)/((double) lth_code))
	);

	return(cloneP);
}
