#include "typedef.h"
#include "opcode.h"

#define OPCODE(A,B,C,D,E, F, G, H)	{A, B, C, D, E, F, G, H}

/* If var == -1 this op code does not use a variable
      var == -2 this op code uses a variable obtained from the code
	  var >=  0 this op code uses this var
 */

const ocodeT opcodes[] = {
                     /* name                flags  var opcode       hash    pop push description */
/*  00 (0x00) */ OPCODE("noop",					0, -3, NOOP,		0x190700, 0, 0, "No-op"),
/*  01 (0x01) */ OPCODE("aconst_null",			0, -3, ACONST_NULL, 0x190701, 0, 1, "Stack ... -> ...,null"),
/*  02 (0x02) */ OPCODE("iconst_m1",			0, -1, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,-1"),
/*  03 (0x03) */ OPCODE("iconst_0",				0,  0, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 0"),
/*  04 (0x04) */ OPCODE("iconst_1",				0,  1, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 1"),
/*  05 (0x05) */ OPCODE("iconst_2",				0,  2, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 2"),
/*  06 (0x06) */ OPCODE("iconst_3",				0,  3, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 3"),
/*  07 (0x07) */ OPCODE("iconst_4",				0,  4, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 4"),
/*  08 (0x08) */ OPCODE("iconst_5",				0,  5, BIPUSH,		0xFFFFFF, 0, 1, "Stack ... -> ...,[int] 5"),
/*  09 (0x09) */ OPCODE("lconst_0",				0,  0, LCONST_0,	0x190702, 0, 2, "Stack ... -> ...,[long] 0.H,L"),
/*  10 (0x0a) */ OPCODE("lconst_1",				0,  1, LCONST_1,	0x190703, 0, 2, "Stack ... -> ...,[long] 1.H,L"),
/*  11 (0x0b) */ OPCODE("fconst_0",				0,	0, FCONST_0,	0x190704, 0, 1, "Stack ... -> ...,[float] 0"),
/*  12 (0x0c) */ OPCODE("fconst_1",				0,  1, FCONST_1,	0x190705, 0, 1, "Stack ... -> ...,[float] 1"),
/*  13 (0x0d) */ OPCODE("fconst_2",				0,  2, FCONST_2,	0x190706, 0, 1, "Stack ... -> ...,[float] 2"),
/*  14 (0x0e) */ OPCODE("dconst_0",				0,  0, DCONST_0,	0x190707, 0, 2, "Stack ... -> ...,[dbl] 0.H,L"),
/*  15 (0x0f) */ OPCODE("dconst_1",				0,  1, DCONST_1,	0x190708, 0, 2, "Stack ... -> ...,[dbl] 1.H,L"),
/*  16 (0x10) */ OPCODE("bipush",			  U1X, -3, BIPUSH,		0x190400, 0, 1, "Stack ... -> ..., (int) [sbyte] u1x"),
/*  17 (0x11) */ OPCODE("sipush",			  U2X, -3, SIPUSH,		0x190500, 0, 1, "Stack ... -> ..., [sshort] arg"),
/*  18 (0x12) */ OPCODE("ldc",			   IX|U1X, -3, LDC,			0x180000, 0, 1, "Stack ... -> ..., const"),
/*  19 (0x13) */ OPCODE("ldc_w",		   IX|U2X, -3, LDC,			0xFFFFFF, 0, 1, "Stack ... -> ..., const"),
/*  20 (0x14) */ OPCODE("ldc2_w",		   IX|U2X, -3, LDC,			0xFFFFFF, 0, 2, "Stack ... -> ..., const.H,L"),
/*  21 (0x15) */ OPCODE("iload",	 IX|WIDEX|U1X, -2, ILOAD,		0x000000, 0, 1, "Stack ... -> ..., [int] var<ix>"),
/*  22 (0x16) */ OPCODE("lload",	 IX|WIDEX|U1X, -2, LLOAD,		0x010000, 0, 2, "Stack ... -> ..., [long] var.H,L"),
/*  23 (0x17) */ OPCODE("fload",	 IX|WIDEX|U1X, -2, FLOAD,		0x020000, 0, 1, "Stack ... -> ..., [float] var<ix>"),
/*  24 (0x18) */ OPCODE("dload",	 IX|WIDEX|U1X, -2, DLOAD,		0x030000, 0, 2, "Stack ... -> ..., [dbl] var<ix>.H,L"),
/*  25 (0x19) */ OPCODE("aload",	 IX|WIDEX|U1X, -2, ALOAD,		0x040000, 0, 1, "Stack ... -> ..., [ref] var<ix>"),
/*  26 (0x1a) */ OPCODE("iload_0",			    0,  0, ILOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [int] var0"),
/*  27 (0x1b) */ OPCODE("iload_1",		        0,  1, ILOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [int] var1"),
/*  28 (0x1c) */ OPCODE("iload_2",			    0,  2, ILOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [int] var2"),
/*  29 (0x1d) */ OPCODE("iload_3",			    0,  3, ILOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [int] var3"),
/*  30 (0x1e) */ OPCODE("lload_0",			    0,  0, LLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [long] var.H,L"),
/*  31 (0x1f) */ OPCODE("lload_1",			    0,  1, LLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [long] var.H,L"),
/*  32 (0x20) */ OPCODE("lload_2",			    0,  2, LLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [long] var.H,L"),
/*  33 (0x21) */ OPCODE("lload_3",			    0,  3, LLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [long] var.H,L"),
/*  34 (0x22) */ OPCODE("fload_0",			    0,  0, FLOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [float] var0"),
/*  35 (0x23) */ OPCODE("fload_1",			    0,  1, FLOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [float] var1"),
/*  36 (0x24) */ OPCODE("fload_2",			    0,  2, FLOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [float] var2"),
/*  37 (0x25) */ OPCODE("fload_3",			    0,  3, FLOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [float] var3"),
/*  38 (0x26) */ OPCODE("dload_0",			    0,  0, DLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [dbl] var0.H,L"),
/*  39 (0x27) */ OPCODE("dload_1",			    0,  1, DLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [dbl] var1.H,L"),
/*  40 (0x28) */ OPCODE("dload_2",			    0,  2, DLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [dbl] var2.H,L"),
/*  41 (0x29) */ OPCODE("dload_3",			    0,  3, DLOAD,		0xFFFFFF, 0, 2, "Stack ... -> ..., [dbl] var3.H,L"),
/*  42 (0x2a) */ OPCODE("aload_0",			    0,  0, ALOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [ref] var<0>"),
/*  43 (0x2b) */ OPCODE("aload_1",			    0,  1, ALOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [ref] var<1>"),
/*  44 (0x2c) */ OPCODE("aload_2",			    0,  2, ALOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [ref] var<2>"),
/*  45 (0x2d) */ OPCODE("aload_3",			    0,  3, ALOAD,		0xFFFFFF, 0, 1, "Stack ... -> ..., [ref] var<3>"),
/*  46 (0x2e) */ OPCODE("iaload",				0, -3, IALOAD,		0x190709, 2, 1, "Stack ..., a, i -> ..., [int] a[i]"),
/*  47 (0x2f) */ OPCODE("laload",				0, -3, LALOAD,		0x19070a, 2, 2, "Stack ..., a, i -> ..., [long] a[i].H,L"),
/*  48 (0x30) */ OPCODE("faload",				0, -3, FALOAD,		0x19070b, 2, 1, "Stack ..., a, i -> ..., [float] a[i]"),
/*  49 (0x31) */ OPCODE("daload",				0, -3, DALOAD,		0x19070c, 2, 2, "Stack ..., a, i -> ..., [dbl] a[i].H,L"),
/*  50 (0x32) */ OPCODE("aaload",				0, -3, AALOAD,		0x19070d, 2, 1, "Stack ..., a, i -> ..., [ref] a[i]"),
/*  51 (0x33) */ OPCODE("baload",				0, -3, BALOAD,		0x19070e, 2, 1, "Stack ..., a, i -> ..., (int) [sbyte] a[i]"),
/*  52 (0x34) */ OPCODE("caload",				0, -3, CALOAD,		0x19070f, 2, 1, "Stack ..., a, i -> ..., [char] a[i]"),
/*  53 (0x35) */ OPCODE("saload",				0, -3, SALOAD,		0x190710, 2, 1, "Stack ..., a, i -> ..., [sshort] a[i]"),
/*  54 (0x36) */ OPCODE("istore",    IX|WIDEX|U1X, -2, ISTORE,		0x050000, 1, 0, "Stack ...,int -> ... & var<ix> = int"),
/*  55 (0x37) */ OPCODE("lstore",    IX|WIDEX|U1X, -2, LSTORE,		0x060000, 2, 0, "Stack ...,long.H,L -> ... & var = long"),
/*  56 (0x38) */ OPCODE("fstore",    IX|WIDEX|U1X, -2, FSTORE,		0x070000, 1, 0, "Stack ...,float -> ... & var<ix> = float"),
/*  57 (0x39) */ OPCODE("dstore",    IX|WIDEX|U1X, -2, DSTORE,		0x080000, 2, 0, "Stack ...,dbl.H,L -> ... & var<ix> = dbl"),
/*  58 (0x3a) */ OPCODE("astore",    IX|WIDEX|U1X, -2, ASTORE,		0x090000, 1, 0, "Stack ...,ref -> ... & var<ix> = ref"),
/*  59 (0x3b) */ OPCODE("istore_0",		        0,  0, ISTORE,		0xFFFFFF, 1, 0, "Stack ...,int -> ... & var0 = int"),
/*  60 (0x3c) */ OPCODE("istore_1",		        0,  1, ISTORE,		0xFFFFFF, 1, 0, "Stack ...,int -> ... & var1 = int"),
/*  61 (0x3d) */ OPCODE("istore_2",				0,  2, ISTORE,		0xFFFFFF, 1, 0, "Stack ...,int -> ... & var2 = int"),
/*  62 (0x3e) */ OPCODE("istore_3",				0,  3, ISTORE,		0xFFFFFF, 1, 0, "Stack ...,int -> ... & var3 = int"),
/*  63 (0x3f) */ OPCODE("lstore_0",				0,  0, LSTORE,		0xFFFFFF, 2, 0, "Stack ...,long.H,L -> ... & var0 = long"),
/*  64 (0x40) */ OPCODE("lstore_1",				0,  1, LSTORE,		0xFFFFFF, 2, 0, "Stack ...,long.H,L -> ... & var1 = long"),
/*  65 (0x41) */ OPCODE("lstore_2",				0,  2, LSTORE,		0xFFFFFF, 2, 0, "Stack ...,long.H,L -> ... & var2 = long"),
/*  66 (0x42) */ OPCODE("lstore_3",				0,  3, LSTORE,		0xFFFFFF, 2, 0, "Stack ...,long.H,L -> ... & var3 = long"),
/*  67 (0x43) */ OPCODE("fstore_0",				0,  0, FSTORE,		0xFFFFFF, 1, 0, "Stack ...,float -> ... & var0 = float"),
/*  68 (0x44) */ OPCODE("fstore_1",				0,  1, FSTORE,		0xFFFFFF, 1, 0, "Stack ...,float -> ... & var1 = float"),
/*  69 (0x45) */ OPCODE("fstore_2",				0,  2, FSTORE,		0xFFFFFF, 1, 0, "Stack ...,float -> ... & var2 = float"),
/*  70 (0x46) */ OPCODE("fstore_3",				0,  3, FSTORE,		0xFFFFFF, 1, 0, "Stack ...,float -> ... & var3 = float"),
/*  71 (0x47) */ OPCODE("dstore_0",				0,  0, DSTORE,		0xFFFFFF, 2, 0, "Stack ...,dbl.H,L -> ... & var0 = dbl"),
/*  72 (0x48) */ OPCODE("dstore_1",				0,  1, DSTORE,		0xFFFFFF, 2, 0, "Stack ...,dbl.H,L -> ... & var1 = dbl"),
/*  73 (0x49) */ OPCODE("dstore_2",				0,  2, DSTORE,		0xFFFFFF, 2, 0, "Stack ...,dbl.H,L -> ... & var2 = dbl"),
/*  74 (0x4a) */ OPCODE("dstore_3",				0,  3, DSTORE,		0xFFFFFF, 2, 0, "Stack ...,dbl.H,L -> ... & var3 = dbl"),
/*  75 (0x4b) */ OPCODE("astore_0",				0,  0, ASTORE,		0xFFFFFF, 1, 0, "Stack ...,ref -> ... & var0 = ref"),
/*  76 (0x4c) */ OPCODE("astore_1",				0,  1, ASTORE,		0xFFFFFF, 1, 0, "Stack ...,ref -> ... & var1 = ref"),
/*  77 (0x4d) */ OPCODE("astore_2",				0,  2, ASTORE,		0xFFFFFF, 1, 0, "Stack ...,ref -> ... & var2 = ref"),
/*  78 (0x4e) */ OPCODE("astore_3",				0,  3, ASTORE,		0xFFFFFF, 1, 0, "Stack ...,ref -> ... & var3 = ref"),
/*  79 (0x4f) */ OPCODE("iastore",				0, -3, IASTORE,		0x190700, 3, 0, "Stack ...,a,i, v -> ... & a[i] = [int] v"),
/*  80 (0x50) */ OPCODE("lastore",				0, -3, LASTORE,		0x190701, 4, 0, "Stack ...,a,i, v.H,L -> ... & a[i] = [long] v"),
/*  81 (0x51) */ OPCODE("fastore",				0, -3, FASTORE,		0x190702, 3, 0, "Stack ...,a,i, v -> ... & a[i] = [float] v"),
/*  82 (0x52) */ OPCODE("dastore",				0, -3, DASTORE,     0x190703, 4, 0, "Stack ...,a,i, v.H,L -> ... & [dbl] a[i] = [dbl] v"),
/*  83 (0x53) */ OPCODE("aastore",				0, -3, AASTORE,		0x190704, 3, 0, "Stack ...,a,i, v -> ... & a[i] = [ref] v"),
/*  84 (0x54) */ OPCODE("bastore",				0, -3, BASTORE,		0x190705, 3, 0, "Stack ...,a,i, (int) v -> ... & a[i] = (int) [sbyte] v"),
/*  85 (0x55) */ OPCODE("castore",				0, -3, CASTORE,		0x190706, 3, 0, "Stack ...,a,i, v -> ... & a[i] = [char] v"),
/*  86 (0x56) */ OPCODE("sastore",				0, -3, SASTORE,		0x190707, 3, 0, "Stack ...,a,i, v -> ... & a[i] = [sshort] v"),
/*  87 (0x57) */ OPCODE("pop",					0, -3, POP,			0x190708, 1, 0, "Stack: ...,x -> ..."),
/*  88 (0x58) */ OPCODE("pop2",					0, -3, POP2,		0x190709, 2, 0, "Stack: ...,x2,x1 -> ..."),
/*  89 (0x59) */ OPCODE("dup",					0, -3, DUP,			0x19070a, 1, 2, "Stack: ...,x -> ...,x, x"),
/*  90 (0x5a) */ OPCODE("dup_x1",				0, -3, DUP_X1,		0x19070b, 2, 3, "Stack ...,x2,x1 -> ...,x1,x2,x1"),
/*  91 (0x5b) */ OPCODE("dup_x2",				0, -3, DUP_X2,		0x19070c, 3, 4, "Stack ...,x3,x2,x1 -> ...,x1,x3,x2,x1"),
/*  92 (0x5c) */ OPCODE("dup2",					0, -3, DUP2,		0x19070d, 2, 4, "Stack: ...,x2,x1 -> ...,x2,x1,x2,x1"),
/*  93 (0x5d) */ OPCODE("dup2_x1",				0, -3, DUP2_X1,		0x19070e, 3, 5, "Stack: ...,x3,x2,x1 -> ...,x2,x1,x3,x2,x1"),
/*  94 (0x5e) */ OPCODE("dup2_x2",				0, -3, DUP2_X2,		0x19070f, 4, 6, "Stack ...,x4,x3,x2,x1 -> ...,x2,x1,x4,x3,x2,x1"),
/*  95 (0x5f) */ OPCODE("swap",					0, -3, SWAP,		0x190710, 2, 2, "Stack ...,x2,x1 -> ...,x1,x2"),
/*  96 (0x60) */ OPCODE("iadd",					0, -3, IADD,		0x190711, 2, 1, "Stack ...,int2,int1 -> ...,(int2+int1)"),
/*  97 (0x61) */ OPCODE("ladd",					0, -3, LADD,		0x190712, 4, 2, "Stack ...,long2.H,L,long1.H.L -> ...,(long2+long1).H,L"),
/*  98 (0x62) */ OPCODE("fadd",					0, -3, FADD,		0x190713, 2, 1, "Stack ...,float2,float1 -> ...,(float2+float1)"),
/*  99 (0x63) */ OPCODE("dadd",					0, -3, DADD,		0x190714, 4, 2, "Stack ...,dbl2.H,L,dbl1.H.L -> ...,(dbl2+dbl1).H,L"),
/* 100 (0x64) */ OPCODE("isub",					0, -3, ISUB,		0x190715, 2, 1, "Stack ...,int2,int1 -> ...,(int2-int1)"),
/* 101 (0x65) */ OPCODE("lsub",					0, -3, LSUB,		0x190716, 4, 2, "Stack ...,long2.H,L,long2.H,L -> ...,(long2-long1).H,L"),
/* 102 (0x66) */ OPCODE("fsub",					0, -3, FSUB,		0x190717, 2, 1, "Stack ...,float2,float1 -> ...,(float2-float1)"			),
/* 103 (0x67) */ OPCODE("dsub",					0, -3, DSUB,		0x190718, 4, 2, "Stack ...,dbl2.H,L,dbl2.H,L -> ...,(dbl2-dbl1).H,L"),
/* 104 (0x68) */ OPCODE("imul",					0, -3, IMUL,		0x190719, 2, 1, "Stack ...,int2,int1 -> ...,(int2*int1)"),
/* 105 (0x69) */ OPCODE("lmul",					0, -3, LMUL,		0x19071a, 4, 2, "Stack ...,long2.H,L,long1.H.L -> ...,(long2*long1).H,L"),
/* 106 (0x6a) */ OPCODE("fmul",					0, -3, FMUL,		0x19071b, 2, 1, "Stack ...,float2,float1 -> ...,(float2*float1)"),
/* 107 (0x6b) */ OPCODE("dmul",					0, -3, DMUL,		0x19071c, 4, 2, "Stack ...,dbl2.H,L,dbl1.H.L -> ...,(dbl2*dbl1).H,L"),
/* 108 (0x6c) */ OPCODE("idiv",					0, -3, IDIV,		0x19071d, 2, 1, "Stack ...,int2,int1 -> ...,(int2/int1)"),
/* 109 (0x6d) */ OPCODE("ldiv",					0, -3, LDIV,		0x19071e, 4, 2, "Stack ...,long2.H,L,long1.H.L -> ...,(long2/long1).H,L"),
/* 110 (0x6e) */ OPCODE("fdiv",					0, -3, FDIV,		0x19071f, 2, 1, "Stack ...,float2,float1 -> ...,(float2/float1)"),
/* 111 (0x6f) */ OPCODE("ddiv",					0, -3, DDIV,		0x190720, 4, 2, "Stack ...,dbl2.H,L,dbl1.H.L -> ...,(dbl2/dbl1).H,L"),
/* 112 (0x70) */ OPCODE("irem",					0, -3, IREM,		0x190721, 2, 1, "Stack ...,int2,int1 -> ...,rem(int2/int1)"),
/* 113 (0x71) */ OPCODE("lrem",					0, -3, LREM,		0x190722, 4, 2, "Stack ...,long2.H,L,long1.H.L -> ...,rem(long2/long1).H,L"),
/* 114 (0x72) */ OPCODE("frem",					0, -3, FREM,		0x190723, 2, 1, "Stack ...,float2,float1 -> ...,rem(float2/float1)"),
/* 115 (0x73) */ OPCODE("drem",					0, -3, DREM,		0x190724, 4, 2, "Stack ...,dbl2.H,L,dbl1.H.L -> ...,rem(dbl2/dbl1).H,L"),
/* 116 (0x74) */ OPCODE("ineg",					0, -3, INEG,		0x190725, 1, 1, "Stack ...,int -> ...,(0-int)"),
/* 117 (0x75) */ OPCODE("lneg",					0, -3, LNEG,		0x190726, 2, 2, "Stack ...,long.H,L -> ...,(0-long).H,L"),
/* 118 (0x76) */ OPCODE("fneg",					0, -3, FNEG,		0x190727, 1, 1, "Stack ...,float -> ...,(0-float)"),
/* 119 (0x77) */ OPCODE("dneg",					0, -3, DNEG,		0x190728, 2, 2, "Stack ...,dbl.H,L -> ...,(0-dbl).H,L"),
/* 120 (0x78) */ OPCODE("ishl",					0, -3, ISHL,		0x190729, 2, 1, "Stack ...,int2,int1 -> ...,(int2<<(int1&0x1F))"),
/* 121 (0x79) */ OPCODE("lshl",					0, -3, LSHL,		0x19072a, 3, 2, "Stack ...,long2.H,L,int1 -> ...,(long2<<(int1&0x3F))"),
/* 122 (0x7a) */ OPCODE("ishr",					0, -3, ISHR,		0x19072b, 2, 1, "Stack ...,int2,int1 -> ...,(signed int2>>(int1&0x1F))"),
/* 123 (0x7b) */ OPCODE("lshr",					0, -3, LSHR,		0x19072c, 3, 2, "Stack ...,long2.H,L,int1 -> ...,(signed long2>>(int1&0x3F)).H,L"),
/* 124 (0x7c) */ OPCODE("iushr",				0, -3, IUSHR,		0x19072d, 2, 1, "Stack ...,int2,int1 -> ...,(unsigned int2>>(int1&0x1F))"),
/* 125 (0x7d) */ OPCODE("lushr",				0, -3, LUSHR,		0x19072e, 3, 2, "Stack ...,long2.H,L,int1 -> ...,(unsigned long2>>(int1&0x3F)).H,L"),
/* 126 (0x7e) */ OPCODE("iand",					0, -3, IAND,		0x19072f, 2, 1, "Stack ...,int2,int1 -> ...,(int2&int1)"),
/* 127 (0x7f) */ OPCODE("land",					0, -3, LAND,		0x190730, 4, 2, "Stack ...,long2.H,L,long1.H,L -> ...,(long2&long1).H,L"),
/* 128 (0x80) */ OPCODE("ior",					0, -3, IOR,			0x190731, 2, 1, "Stack ...,int2,int1 -> ...,(int2|int1)"),
/* 129 (0x81) */ OPCODE("lor",					0, -3, LOR,			0x190732, 4, 2, "Stack ...,long2.H,L,long1.H,L -> ...,(long2|long1).H,L"),
/* 130 (0x82) */ OPCODE("ixor",					0, -3, IXOR,		0x190733, 2, 1, "Stack ...,int2,int1 -> ...,(int2^int1)"),
/* 131 (0x83) */ OPCODE("lxor",					0, -3, LXOR,		0x190734, 4, 2, "Stack ...,long2.H,L,long1.H,L -> ...,(long2^long1).H,L"),
/* 132 (0x84) */ OPCODE("iinc",	     IX|WIDEX|U1X, -3, IINC,		0x170000, 0, 0, "[int] var<ix> += <s1> arg2"),
/* 133 (0x85) */ OPCODE("i2l",					0, -3, I2L,			0x190735, 1, 2, "Stack ...,int -> ...,long.H,L"),
/* 134 (0x86) */ OPCODE("i2f",					0, -3, I2F,			0x190736, 1, 1, "Stack ...,int -> ...,float"),
/* 135 (0x87) */ OPCODE("i2d",					0, -3, I2D,			0x190737, 1, 2, "Stack ...,int -> ...,dbl.H,L"),
/* 136 (0x88) */ OPCODE("l2i",					0, -3, L2I,			0x190738, 2, 1, "Stack ...,long.H,L -> ...,int"),
/* 137 (0x89) */ OPCODE("l2f",					0, -3, L2F,			0x190739, 2, 1, "Stack ...,long.H,L -> ...,float"),
/* 138 (0x8a) */ OPCODE("l2d",					0, -3, L2D,			0x19073a, 2, 2, "Stack ...,long.H,L -> ...,dbl.H,L"),
/* 139 (0x8b) */ OPCODE("f2i",					0, -3, F2I,			0x19073b, 1, 1, "Stack ...,float -> ...,int"),
/* 140 (0x8c) */ OPCODE("f2l",					0, -3, F2L,			0x19073c, 1, 2, "Stack ...,float -> ...,long.H,L"),
/* 141 (0x8d) */ OPCODE("f2d",					0, -3, F2D,			0x19073d, 1, 2, "Stack ...,float -> ...,dbl.H,L"),
/* 142 (0x8e) */ OPCODE("d2i",					0, -3, D2I,			0x19073e, 2, 1, "Stack ...,dbl.H,L -> ...,int"),
/* 143 (0x8f) */ OPCODE("d2l",					0, -3, D2L,			0x19073f, 2, 2, "Stack ...,dbl.H,L -> ...,long.H,L"),
/* 144 (0x90) */ OPCODE("d2f",					0, -3, D2F,			0x190740, 2, 1, "Stack ...,dbl.H,L -> ...,float"),
/* 145 (0x91) */ OPCODE("i2b",					0, -3, I2B,			0x190741, 1, 1, "Stack ...,int -> ...,(signed (int&0xFF))"),
/* 146 (0x92) */ OPCODE("i2c",					0, -3, I2C,			0x190742, 1, 1, "Stack ...,int -> ...,(unsigned (int&0xFFFF))"),
/* 147 (0x93) */ OPCODE("i2s",					0, -3, I2S,			0x190743, 1, 1, "Stack ...,int -> ...,(signed (int&0xFFFF))"),
/* 148 (0x94) */ OPCODE("lcmp",					0, -3, LCMP,		0x190744, 4, 1, "Stack ...,long2.H,L,long1.H,L -> ..., (+1/0/-1 : long2 >|=|< long1)"),
/* 149 (0x95) */ OPCODE("fcmpl",				0, -3, FCMPL,		0x190745, 2, 1, "Stack ...,float2,float1 -> ..., (+1/0/-1=NAN : float2 >|=|< float1)"),
/* 150 (0x96) */ OPCODE("fcmpg",				0, -3, FCMPG,		0x190746, 2, 1, "Stack ...,float2,float1 -> ..., (+1=NAN/0/-1 : float2 >|=|< float1)"),
/* 151 (0x97) */ OPCODE("dcmpl",				0, -3, DCMPL,		0x190747, 4, 1, "Stack ...,dbl2,H,L,dbl1.H,L -> ..., (+1/0/-1=NAN : dbl2 >|=|< dbl1)"),
/* 152 (0x98) */ OPCODE("dcmpg",				0, -3, DCMPG,		0x190748, 4, 1, "Stack ...,dbl2,H,L,dbl1.H,L -> ..., (+1=NAN/0/-1 : dbl2 >|=|< dbl1)"),
/* 153 (0x99) */ OPCODE("ifeq",				  U2X, -3, IFEQ,		0x190000, 1, 0, "Stack ...,int -> ... & if int==0"),
/* 154 (0x9a) */ OPCODE("ifne",				  U2X, -3, IFNE,		0x190001, 1, 0, "Stack ...,int -> ... & if int!=0"),
/* 155 (0x9b) */ OPCODE("iflt",				  U2X, -3, IFLT,		0x190002, 1, 0, "Stack ...,int -> ... & if int<0"),
/* 156 (0x9c) */ OPCODE("ifge",				  U2X, -3, IFGE,		0x190003, 1, 0, "Stack ...,int -> ... & if int>=0"),
/* 157 (0x9d) */ OPCODE("ifgt",				  U2X, -3, IFGT,		0x190004, 1, 0, "Stack ...,int -> ... & if int>0"),
/* 158 (0x9e) */ OPCODE("ifle",				  U2X, -3, IFLE,		0x190005, 1, 0, "Stack ...,int -> ... & if int<=0"),
/* 159 (0x9f) */ OPCODE("if_icmpeq",		  U2X, -3, IF_ICMPEQ,	0x190006, 2, 0, "Stack ...,int2,int1 -> ... & if int2==int1"),
/* 160 (0xa0) */ OPCODE("if_icmpne",		  U2X, -3, IF_ICMPNE,	0x190007, 2, 0, "Stack ...,int2,int1 -> ... & if int2!=int1"),
/* 161 (0xa1) */ OPCODE("if_icmplt",		  U2X, -3, IF_ICMPLT,	0x190008, 2, 0, "Stack ...,int2,int1 -> ... & if int2<int1"),
/* 162 (0xa2) */ OPCODE("if_icmpge",		  U2X, -3, IF_ICMPGE,	0x190009, 2, 0, "Stack ...,int2,int1 -> ... & if int2>=int1"),
/* 163 (0xa3) */ OPCODE("if_icmpgt",		  U2X, -3, IF_ICMPGT,	0x19000a, 2, 0, "Stack ...,int2,int1 -> ... & if int2>int1"),
/* 164 (0xa4) */ OPCODE("if_icmple",		  U2X, -3, IF_ICMPLE,	0x19000b, 2, 0, "Stack ...,int2,int1 -> ... & if int2<=int1"),
/* 165 (0xa5) */ OPCODE("if_acmpeq",		  U2X, -3, IF_ACMPEQ,	0x19000c, 2, 0, "Stack ...,ref2,ref1 -> ... & if ref2==ref1"),
/* 166 (0xa6) */ OPCODE("if_acmpne",		  U2X, -3, IF_ACMPNE,	0x19000d, 2, 0, "Stack ...,ref2,ref1 -> ... & if ref2!=ref1"),
/* 167 (0xa7) */ OPCODE("goto ",			  U2X, -3, GOTO,		0x19000e, 0, 0, "goto pc+<s2>"),
/* 168 (0xa8) */ OPCODE("jsr",				  U2X, -2, JSR,			0x19000f, 0, 1, "Stack ... -> ..., returnAddress &"),
/* 169 (0xa9) */ OPCODE("ret",		 IX|WIDEX|U1X, -2, RET,			0x190749, 0, 0, "Go to address in var"),
/* 170 (0xaa) */ OPCODE("tableswitch",	        0, -3, TABLESWITCH, 0x19074a, 1, 0, "Stack ..., index -> ... & branch"),
/* 171 (0xab) */ OPCODE("lookupswitch",	        0, -3, LOOKUPSWITCH,0x19074b, 1, 0, "Stack ..., key -> ... & branch"),
/* 172 (0xac) */ OPCODE("ireturn",				0, -3, IRETURN,		0x19074c, 1, -1,"Stack ...,int -> [empty] & return int to caller"),
/* 173 (0xad) */ OPCODE("lreturn",				0, -3, LRETURN,		0x19074d, 2, -1,"Stack ...,long.H,L -> [empty] & return long to caller"),
/* 174 (0xae) */ OPCODE("freturn",				0, -3, FRETURN,		0x19074e, 1, -1,"Stack ...,float -> [empty] & return float to caller"),
/* 175 (0xaf) */ OPCODE("dreturn",				0, -3, DRETURN,		0x19074f, 2, -1,"Stack ...,dbl.H,L -> [empty] & return dbl to caller"),
/* 176 (0xb0) */ OPCODE("areturn",				0, -3, ARETURN,		0x190750, 1, -1,"Stack ...,ref -> [empty] & return ref to caller"),
/* 177 (0xb1) */ OPCODE("return",				0, -3, RETURN,		0x190751, 0, -1,"Stack ... -> [empty] & return to caller"),
/* 178 (0xb2) */ OPCODE("getstatic",	   IX|U2X, -3, GETSTATIC,	0x0a0000, 0, 1,"Stack ... -> ...,val[H,L] where static Field has val"),
/* 179 (0xb3) */ OPCODE("putstatic",	   IX|U2X, -3, PUTSTATIC,	0x0b0000, 1, 0, "Stack ..., val[H,L] -> ... & static Field=val"),
/* 180 (0xb4) */ OPCODE("getfield",		   IX|U2X, -3, GETFIELD,	0x0c0000, 1, 1,"Stack ...,ref -> ...,val[H,L] where ref.Field<ix> has val"),
/* 181 (0xb5) */ OPCODE("putfield",		   IX|U2X, -3, PUTFIELD,	0x0d0000, 2, 0, "Stack ..., ref, val[H,L] -> ... & ref.Field<ix>=val"),
/* 182 (0xb6) */ OPCODE("invokevirtual",   IX|U2X, -3, INVOKEVIRTUAL,0x0e0000,1, 0, "Stack ...,ref [,arg1 , arg2 ...] -> ... & Function invoked"),
/* 183 (0xb7) */ OPCODE("invokespecial",   IX|U2X, -3, INVOKESPECIAL,0x0f0000,1, 0, "Stack ...,ref [,arg1 , arg2 ...] -> ... & Function invoked"),
/* 184 (0xb8) */ OPCODE("invokestatic",	   IX|U2X, -3, INVOKESTATIC,0x100000, 0, 0, "Stack ..., [,arg1 , arg2 ...] -> ... & Function invoked"),
/* 185 (0xb9) */ OPCODE("invokeinterface", IX|U2X, -3, INVOKEINTERFACE,0x110000,1,0,"Stack ...,ref [,arg1 , arg2 ...] -> ... & Interface invoked with args"),
/* 186 (0xba) */ OPCODE("xxxunusedxxx1",		0, -3, OP186,		0xFFFFFF, 0, 0, 0),
/* 187 (0xbb) */ OPCODE("new",			   IX|U2X, -3, NEW,			0x120000, 0, 1, "Stack ... -> ...,ref"),
/* 188 (0xbc) */ OPCODE("newarray",		   IX|U1X, -3, NEWARRAY,	0x190600, 1, 1, "Stack ...,[int] size -> ...,ref array[size]"),
/* 189 (0xbd) */ OPCODE("anewarray",	   IX|U2X, -3, ANEWARRAY,	0x130000, 1, 1, "Stack ...,[int] size -> ..., ref new array<ix>[size]"),
/* 190 (0xbe) */ OPCODE("arraylength",			0, -3, ARRAYLENGTH, 0x190752, 1, 1, "Stack ...,ref array -> ...,array.length"),
/* 191 (0xbf) */ OPCODE("athrow",				0, -3, ATHROW,		0x190753, 1, -2,"Stack ...,Throwable ref -> [undefined] & throw"),
/* 192 (0xc0) */ OPCODE("checkcast",	   IX|U2X, -3, CHECKCAST,	0x140000, 1, 1, "Stack ...,ref -> ...,ref & throw if not castable to class<ix>"),
/* 193 (0xc1) */ OPCODE("instanceof",	   IX|U2X, -3, INSTANCEOF,	0x150000, 1, 1, "Stack ...,ref -> ...,(1 if ref instanceof<ix> else 0)"),
/* 194 (0xc2) */ OPCODE("monitorenter",			0, -3, MONITORENTER,0x190754, 1, 0, "Stack ..., ref -> ... & exclusive access to ref"),
/* 195 (0xc3) */ OPCODE("monitorexit",			0, -3, MONITOREXIT, 0x190755, 1, 0, "Stack ..., ref -> ... & release lock on ref"),
/* 196 (0xc4) */ OPCODE("wide",					0, -3, WIDE,		0xFFFFFF, 0, 0, "Treat next instruction as having wider argument"),
/* 197 (0xc5) */ OPCODE("multianewarray",  IX|U2X, -3, MULTIANEWARRAY,0x160000,0,1,"Stack ...,d1,d2,...dn -> array[d1][d2]...[dn] where n=arg2"),
/* 198 (0xc6) */ OPCODE("ifnull",			  U2X, -3, IFNULL,		0x190010, 1, 0, "Stack ...,ref -> ... & if ref==null"),
/* 199 (0xc7) */ OPCODE("ifnonnull",		  U2X, -3, IFNOTNULL,	0x190011, 1, 0, "Stack ...,ref -> ... & if ref!=null"),
/* 200 (0xc8) */ OPCODE("goto_w",			  U4X, -3, GOTO,		0xFFFFFF, 0, 0, "goto pc+<s4>"),
/* 201 (0xc9) */ OPCODE("jsr_w",			  U4X, -3, JSR,			0xFFFFFF, 0, 1, "Stack ... -> ..., returnAddress &"),
/* 202 (0xca) */ OPCODE("breakpoint",		    0, -3, BREAKPOINT,	0x190756, 0, 0, 0),	/* Reserved opcodes start here */	
/* 203 (0xcb) */ OPCODE("?203?",		 INVALIDX, -3, OP203,		0xFFFFFF, 0, 0, 0),
/* 204 (0xcc) */ OPCODE("?204?",		 INVALIDX, -3, OP204,		0xFFFFFF, 0, 0, 0),
/* 205 (0xcd) */ OPCODE("?205?",		 INVALIDX, -3, OP205,		0xFFFFFF, 0, 0, 0),
/* 206 (0xce) */ OPCODE("?206?",		 INVALIDX, -3, OP206,		0xFFFFFF, 0, 0, 0),
/* 207 (0xcf) */ OPCODE("?207?",	     INVALIDX, -3, OP207,		0xFFFFFF, 0, 0, 0),
/* 208 (0xd0) */ OPCODE("?208?",	     INVALIDX, -3, OP208,		0xFFFFFF, 0, 0, 0),
/* 209 (0xd1) */ OPCODE("ret_w",	          U2X, -2, RET_W,		0x190012, 0, 0, "Go to return address in var<ix>"),
/* 210 (0xd2) */ OPCODE("?210?",	     INVALIDX, -3, OP210,		0xFFFFFF, 0, 0, 0),
/* 211 (0xd3) */ OPCODE("?211?",	     INVALIDX, -3, OP211,		0xFFFFFF, 0, 0, 0),
/* 212 (0xd4) */ OPCODE("?212?",	     INVALIDX, -3, OP212,		0xFFFFFF, 0, 0, 0),
/* 213 (0xd5) */ OPCODE("?213?",	     INVALIDX, -3, OP213,		0xFFFFFF, 0, 0, 0),
/* 214 (0xd6) */ OPCODE("?214?",	     INVALIDX, -3, OP214,		0xFFFFFF, 0, 0, 0),
/* 215 (0xd7) */ OPCODE("?215?",	     INVALIDX, -3, OP215,		0xFFFFFF, 0, 0, 0),
/* 216 (0xd8) */ OPCODE("?216?",	     INVALIDX, -3, OP216,		0xFFFFFF, 0, 0, 0),
/* 217 (0xd9) */ OPCODE("?217?",	     INVALIDX, -3, OP217,		0xFFFFFF, 0, 0, 0),
/* 218 (0xda) */ OPCODE("?218?",	     INVALIDX, -3, OP218,		0xFFFFFF, 0, 0, 0),
/* 219 (0xdb) */ OPCODE("?219?",	     INVALIDX, -3, OP219,		0xFFFFFF, 0, 0, 0),
/* 220 (0xdc) */ OPCODE("?220?",	     INVALIDX, -3, OP220,		0xFFFFFF, 0, 0, 0),
/* 221 (0xdd) */ OPCODE("?221?",	     INVALIDX, -3, OP221,		0xFFFFFF, 0, 0, 0),
/* 222 (0xde) */ OPCODE("?222?",	     INVALIDX, -3, OP222,		0xFFFFFF, 0, 0, 0),
/* 223 (0xdf) */ OPCODE("?223?",	     INVALIDX, -3, OP223,		0xFFFFFF, 0, 0, 0),
/* 224 (0xe0) */ OPCODE("?224?",	     INVALIDX, -3, OP224,		0xFFFFFF, 0, 0, 0),
/* 225 (0xe1) */ OPCODE("?225?",	     INVALIDX, -3, OP225,		0xFFFFFF, 0, 0, 0),
/* 226 (0xe2) */ OPCODE("?226?",	     INVALIDX, -3, OP226,		0xFFFFFF, 0, 0, 0),
/* 227 (0xe3) */ OPCODE("?227?",	     INVALIDX, -3, OP227,		0xFFFFFF, 0, 0, 0),
/* 228 (0xe4) */ OPCODE("?228?",	     INVALIDX, -3, OP228,		0xFFFFFF, 0, 0, 0),
/* 229 (0xe5) */ OPCODE("?229?",	     INVALIDX, -3, OP229,		0xFFFFFF, 0, 0, 0),
/* 230 (0xe6) */ OPCODE("?230?",	     INVALIDX, -3, OP230,		0xFFFFFF, 0, 0, 0),
/* 231 (0xe7) */ OPCODE("?231?",	     INVALIDX, -3, OP231,		0xFFFFFF, 0, 0, 0),
/* 232 (0xe8) */ OPCODE("?232?",	     INVALIDX, -3, OP232,		0xFFFFFF, 0, 0, 0),
/* 233 (0xe9) */ OPCODE("?233?",	     INVALIDX, -3, OP233,		0xFFFFFF, 0, 0, 0),
/* 234 (0xea) */ OPCODE("?234?",	     INVALIDX, -3, OP234,		0xFFFFFF, 0, 0, 0),
/* 235 (0xeb) */ OPCODE("?235?",	     INVALIDX, -3, OP235,		0xFFFFFF, 0, 0, 0),
/* 236 (0xec) */ OPCODE("?236?",	     INVALIDX, -3, OP236,		0xFFFFFF, 0, 0, 0),
/* 237 (0xed) */ OPCODE("?237?",	     INVALIDX, -3, OP237,		0xFFFFFF, 0, 0, 0),
/* 238 (0xee) */ OPCODE("?238?",	     INVALIDX, -3, OP238,		0xFFFFFF, 0, 0, 0),
/* 239 (0xef) */ OPCODE("?239?",	     INVALIDX, -3, OP239,		0xFFFFFF, 0, 0, 0),
/* 240 (0xf0) */ OPCODE("?240?",	     INVALIDX, -3, OP240,		0xFFFFFF, 0, 0, 0),
/* 241 (0xf1) */ OPCODE("?241?",	     INVALIDX, -3, OP241,		0xFFFFFF, 0, 0, 0),
/* 242 (0xf2) */ OPCODE("?242?",	     INVALIDX, -3, OP242,		0xFFFFFF, 0, 0, 0),
/* 243 (0xf3) */ OPCODE("?243?",	     INVALIDX, -3, OP243,		0xFFFFFF, 0, 0, 0),
/* 244 (0xf4) */ OPCODE("?244?",	     INVALIDX, -3, OP244,		0xFFFFFF, 0, 0, 0),
/* 245 (0xf5) */ OPCODE("?245?",	     INVALIDX, -3, OP245,		0xFFFFFF, 0, 0, 0),
/* 246 (0xf6) */ OPCODE("?246?",	     INVALIDX, -3, OP246,		0xFFFFFF, 0, 0, 0),
/* 247 (0xf7) */ OPCODE("?247?",	     INVALIDX, -3, OP247,		0xFFFFFF, 0, 0, 0),
/* 248 (0xf8) */ OPCODE("?248?",	     INVALIDX, -3, OP248,		0xFFFFFF, 0, 0, 0),
/* 249 (0xf9) */ OPCODE("?249?",	     INVALIDX, -3, OP249,		0xFFFFFF, 0, 0, 0),
/* 250 (0xfa) */ OPCODE("} try",	     INVALIDX, -3, TRY_END,	    0x190756, 0, 0, 0),
/* 251 (0xfb) */ OPCODE("catch",	     INVALIDX, -3, TRY_LABEL,	0x190757, 0, -2, 0),
/* 252 (0xfc) */ OPCODE("default",		 INVALIDX, -3, DEFAULT,		0x190013, 0, 0, 0),
/* 253 (0xfd) */ OPCODE("try {",		 INVALIDX, -3, TRY_START,	0x190758, 0, 0, 0),
/* 254 (0xfe) */ OPCODE("impdep1",	 	 INVALIDX, -3, IMPDEP1,		0x190759, 0, 0, 0),
/* 255 (0xff) */ OPCODE("impdep2",	   	 INVALIDX, -3, IMPDEP2,		0x19075a, 0, 0, 0)
};
