#include "typedef.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <search.h>

#include "xmalloc.h"
#include "util.h"
#include "object.h"
#include "opcode.h"
#include "code.h"
#include "source.h"
#include "sort.h"

int		Csort::g_labels_count = 0;
int		Csort::g_labels_max   = 0;
labelT	*Csort::g_labelsP     = 0;	

void	
Csort::clear_sort(void)
{
	g_labels_count = 0;
}

void
Csort::append_exception(int method, const exceptionT *exceptionP)
{
	labelT	*labelP;

	if (g_labels_count+2 >= g_labels_max) {
		if (!g_labels_max) {
			g_labels_max = 4096;
			g_labelsP    = (labelT *) Xmalloc(g_labels_max * sizeof(labelT));
			if (!g_labelsP) {
				outofmemory();
			}
		} else {
			int		size  = g_labels_max * sizeof(labelT);
			labelT	*newP = (labelT *) Xmalloc(size << 1);
			if (!newP) {
				outofmemory();
			}
			memcpy(newP, g_labelsP, size);
			Xfree((void **) &g_labelsP);
			g_labelsP = newP;
			g_labels_max <<= 1;
	}	}

	labelP = g_labelsP + g_labels_count;
	labelP->method     = method;
	labelP->to         = exceptionP->m_start_pc;
	labelP->from       = exceptionP->m_end_pc;
	labelP->exceptionP = exceptionP;
	labelP->pcode      = TRY_START;

	++labelP;
	labelP->method     = method;
	labelP->to         = exceptionP->m_end_pc;
	labelP->from       = exceptionP->m_start_pc;
	labelP->exceptionP = exceptionP;
	labelP->pcode      = TRY_END;

	++labelP;
	labelP->method     = method;
	labelP->to         = exceptionP->m_handler_pc;
	labelP->from       = exceptionP->m_start_pc;
	labelP->exceptionP = exceptionP;
	labelP->pcode      = TRY_LABEL;

	g_labels_count    += 3;
}

/*
	< 0 P1 less than P2
      0 P1 equals    P2
    > 0 P1 greater   P2
 */

static int
label_compare(const void *P1, const void *P2)
{
	u4T		to1, to2, from1, from2;
	pcodeE	pcode;
	int	diff;

	diff    = ((labelT *) P1)->method - ((labelT *) P2)->method;
	if (diff) {
		return diff;
	}

	to1   = ((labelT *) P1)->to;
	to2   = ((labelT *) P2)->to;
	diff  = (int) to1 - (int) to2;

	if (diff) {
		// to1 occurs before to2 if to1 is smaller
		return (diff);
	}

	pcode   = ((labelT *) P1)->pcode;
	diff    = pcode  - ((labelT *) P2)->pcode;
	if (diff) {
		return diff;
	}

	switch (pcode) {
	case TRY_START:
	case TRY_LABEL:
		from1 = ((labelT *) P1)->from;
		from2 = ((labelT *) P2)->from;

		// A try start appears earlier if its from (end range) is larger
		diff  = from2 - from1;
		if (diff) {
			break;
		}
		diff  = ((labelT *) P1)->exceptionP->m_catch_typeP - ((labelT *) P2)->exceptionP->m_catch_typeP;
		break;
	case TRY_END:
		from1 = ((labelT *) P1)->from;
		from2 = ((labelT *) P2)->from;

		// A try end appears earlier if its from (end range) is larger
		diff  = from2 - from1;
		if (diff) {
			break;
		}
		diff = ((labelT *) P2)->exceptionP->m_catch_typeP - ((labelT *) P1)->exceptionP->m_catch_typeP;
		break;
	default:
		assert(0);
	}
	return (diff);
}

void
Csort::sort(void)
{
	qsort(g_labelsP, g_labels_count, sizeof(labelT), label_compare);
}

