
// http://java.sun.com/docs/books/vmspec/2nd-edition/html/ClassFile.doc.html

typedef enum {
	CONSTANT_Null               =  0,	// An unused constant_pool entry
	CONSTANT_Utf8               =  1,
	CONSTANT_Integer            =  3,
	CONSTANT_Float              =  4,
	CONSTANT_Long               =  5,
	CONSTANT_Double             =  6,
	CONSTANT_Class              =  7,
	CONSTANT_String             =  8,
	CONSTANT_Fieldref           =  9,
	CONSTANT_Methodref          = 10,
	CONSTANT_InterfaceMethodref = 11,
	CONSTANT_NameAndType        = 12
} constantE;

typedef struct {
	constantE			tag;
	union {
		struct {
			u2T			index1;
			u2T			index2;
		} ref;
		u1T				byte;
		u2T			 	*stringP;
		int				ival;
		float			fval;
		long long		lval;
		double			dval;
		u4T				u4val;
		u8T				u8val;
	} u;
} cp_infoT;

/* Access bits */

#define ACC_PUBLIC			0x0001
#define ACC_PRIVATE			0x0002
#define ACC_PROTECTED		0x0004
#define	ACC_STATIC			0x0008
#define ACC_FINAL			0x0010
#define ACC_SYNCHRONIZED	0x0020
#define ACC_VOLATILE		0x0040
#define ACC_TRANSIENT		0x0080
#define ACC_NATIVE			0x0100
#define ACC_INTERFACE		0x0200
#define ACC_ABSTRACT		0x0400
#define ACC_STRICT			0x0800

typedef struct {
	u2T				m_inner_class_info_index;
	u2T				m_outer_class_info_index;
	u2T				m_inner_class_name_index;
	u2T				m_inner_class_access_flags;
} innerclassT;

typedef struct {
	u2T				m_class_index;
	u2T				m_method_index;
} enclosingMethodT;

#define SyntheticX	0x01
#define DeprecatedX	0x02
#define ConstantX	0x04
#define ProcessedX	0x08

typedef struct {
	u2T				m_access_flags;
	u2T				m_name_index;
	u2T				m_descriptor_index;
	u2T				m_constant_index;			// 0 if not a constant (check final in access_flags to decide if constant)
	u4T				m_flags;
} field_infoT;

/* start_pc, end_pc 

	The values of the two items start_pc and end_pc indicate the ranges in the code array at which the exception handler is 
	active. The value of start_pc must be a valid index into the code array of the opcode of an instruction. 
	The value of end_pc either must be a valid index into the code array of the opcode of an instruction or must be equal to 
	code_length, the length of the code array. The value of start_pc must be less than the value of end_pc. 
	The start_pc is inclusive and end_pc is exclusive; that is, the exception handler must be active while the program counter 
	is within the interval [start_pc, end_pc).4

  handler_pc 

	The value of the handler_pc item indicates the start of the exception handler. The value of the item must be a valid index 
	into the code array and must be the index of the opcode of an instruction.

  catch_type 

	If the value of the catch_type item is nonzero, it must be a valid index into the constant_pool table. The constant_pool 
	entry at that index must be a CONSTANT_Class_info (4.4.1) structure representing a class of exceptions that this exception 
	handler is designated to catch. This class must be the class Throwable or one of its subclasses. The exception handler will 
	be called only if the thrown exception is an instance of the given class or one of its subclasses.

	If the value of the catch_type item is zero, this exception handler is called for all exceptions. This is used to implement 
	finally (see Section 7.13, "Compiling finally").
*/

typedef struct {
	u2T	m_start_pc;	// Exception active if pc >= m_start_pc && pc < m_end_pc
	u2T m_end_pc;
	u2T m_handler_pc;
	u2T *m_catch_typeP;
} exceptionT;

typedef struct {
	u2T	m_start_pc;		// The first pc that is at this line_number
	u2T	m_line_number;	// The line number of this pc
} linenumberT;

/*
	The LocalVariableTable attribute has the following format:


    LocalVariableTable_attribute {
    	u2 attribute_name_index;
    	u4 attribute_length;
    	u2 local_variable_table_length;
    	{  u2 start_pc;
    	    u2 length;
    	    u2 name_index;
    	    u2 descriptor_index;
    	    u2 index;
    	} local_variable_table[local_variable_table_length];
    }	

	The items of the LocalVariableTable_attribute structure are as follows: 

	attribute_name_index 
	The value of the attribute_name_index item must be a valid index into the constant_pool table. 
	The constant_pool entry at that index must be a CONSTANT_Utf8_info (4.4.7) structure representing the 
	string "LocalVariableTable".

	attribute_length 
	The value of the attribute_length item indicates the length of the attribute, excluding the initial six bytes.

	local_variable_table_length 
	The value of the local_variable_table_length item indicates the number of entries in the local_variable_table array.

	local_variable_table[] 
	Each entry in the local_variable_table array indicates a range of code array offsets within which a local variable 
	has a value. It also indicates the index into the local variable array of the current frame at which that local variable 
	can be found. Each entry must contain the following five items:

		start_pc, length 
		The given local variable must have a value at indices into the code array in the interval [start_pc, start_pc+length], 
		that is, between start_pc and start_pc+length inclusive. The value of start_pc must be a valid index into the code array 
		of this Code attribute and must be the index of the opcode of an instruction. Either the value of start_pc+length must 
		be a valid index into the code array of this Code attribute and be the index of the opcode of an instruction, or it must 
		be the first index beyond the end of that code array.

		name_index, descriptor_index 
		The value of the name_index item must be a valid index into the constant_pool table. The constant_pool entry at that 
		index must contain a CONSTANT_Utf8_info (4.4.7) structure representing a valid local variable name stored as a simple 
		name (2.7.1).
		The value of the descriptor_index item must be a valid index into the constant_pool table. The constant_pool entry at 
		that index must contain a CONSTANT_Utf8_info (4.4.7) structure representing a field descriptor (4.3.2) encoding the 
		type of a local variable in the source program. 

		index 
		The given local variable must be at index in the local variable array of the current frame. If the local variable at 
		index is of type double or long, it occupies both index and index+1.
*/
typedef struct {
	u2T	m_start_pc;
	u2T	m_end_pc;
    u2T *m_nameP;
    u2T *m_descriptorP;
    u2T m_index;
} localvariableT;

typedef struct {
	u2T	*m_nameP;
	u2T	*m_descriptorP;
	u4T	m_number;
} varT;

typedef struct {
	u2T	*m_nameP;
	u2T	*m_descriptorP;
	u4T	m_number;
	s4T	m_s4;
} iincT;

typedef struct {
	u2T	*m_classnameP;
} classrefT;

typedef struct {
	u2T	*m_classnameP;
	u4T	m_dimensions;
} arrayrefT;

typedef struct {
	u2T	*m_classnameP;
	u2T	*m_nameP;
	u2T	*m_descriptorP;
} fieldrefT; 

typedef struct {
	u2T	*m_classnameP;
	u2T	*m_nameP;
	u2T	*m_descriptorP;
} methodrefT; 

typedef struct {
	u2T	*m_classnameP;
	u2T	*m_nameP;
	u2T	*m_descriptorP;
	u4T	m_args;
} interfacerefT; 

class Cdirectory;
class Cfunction;

class Csource : public Cobject {
public:
	static Csource	*g_hash[HASHSIZE];
	static Csource	*g_headP;
	static Csource	**g_tailPP;

	Csource			*m_hashP;
	Csource			*m_nextP;

	char			*m_filenameP;			// Name of the file actually read
	u2T				*m_nameP;
	int				m_number;				// Used for outputting in CLICS format
	Cdirectory		*m_parentP;				// Directory containing this source
	int				m_source_lines;			// Lines in source file
	char			**m_sourcePP;			// Array of lines in source
	
	u2T				m_minor_version;
	u2T				m_major_version;
    u2T				m_access_flags;
    u2T 			m_this_class;
    u2T				m_super_class;			// The class this class extends
	u2T				m_source_name;			// The name of this source file

    u2T				m_constant_pool_count;
    u2T				m_interfaces_count;
    u2T				m_fields_count;
    u2T 			m_functions_count;
	u2T				m_innerclasses_count;

    cp_infoT  		*m_constant_poolP;
    u2T   	  		*m_interfacesP;
    field_infoT  	*m_fieldsP;
    Cfunction	 	*m_functionsP;
	innerclassT		*m_innerclassesP;
	enclosingMethodT m_enclosingMethod;		// The method this class defined in ??
	int				m_dimensions;
	u4T				m_flags;
	int				m_hypertext_cnt;
	int				m_has_clones;			// 0 if no clones under this


	static u4T		hash(const u2T *nameP);
	static void		chain(Csource *classP);
	static Csource	*locate1(u2T *nameP);
	static Csource	*locate(u2T *nameP);

	Csource(void);
	Csource(const u2T *nameP);

	u2T				*get_Utf8(int index) const;
	u2T				*get_classname(int index) const;

	void			showline(int lineno) const;
	void			load_source(void);

	int				load_constant_pool(const char *filenameP, int load);
	int				load_tables(int load);

	void			dump_Utf8(int index) const;
	void			dump_descriptor(const u2T *descriptorP, Cfunction *methodP, int isStatic) const;
	void			dump_pcode(Cfunction *methodP, codeT *pcodeP) const;
	void			emit_ta(void) const;
};

extern int	readclassfile(char *pathP, Csource *classP);
extern void pseudo_source(void);
