#include "typedef.h"

#include <stdio.h>
#include <string.h>
#include <wchar.h>

#include "xmalloc.h"
#include "stringcache.h"
#include "util.h"

typedef struct cacheS {
	struct cacheS	*nextP;
	u2T				*stringP;
} cacheT;

static cacheT	*hashtable[0x4000] = {0};

static cacheT	*leftP = 0;
static int		left   = 0;

// All identical strings passed through stringCache will have the same resulting address

u2T *
stringCache(u2T *stringP)
{
	const u2T	*P;
	u4T			hash;
	cacheT		*cacheP;
	u2T			c;

	hash = 0;
	for (P = stringP; (c = *P); ++P) {
		hash ^= c;
	}
	hash &= 0x3FFF;
	for (cacheP = hashtable[hash]; cacheP; cacheP = cacheP->nextP) {
		if (!U2cmp(stringP, cacheP->stringP)) {
			return cacheP->stringP;
	}	}
	if (left == 0) {
		left  = 2048;
		leftP = (cacheT *) Xmalloc(sizeof(cacheT) * 2048);
		if (!leftP) {
			outofmemory();
	}	}
	cacheP = leftP + --left;
	cacheP->nextP   = hashtable[hash];
	cacheP->stringP = stringP;
	hashtable[hash] = cacheP;
	return stringP;
}
