// #define TRACK_DOWN_MALLOC_PROBLEM

#include "typedef.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"
#include "xmalloc.h"

char	g_filename[2048];

extern FILE	*stdoutF;

#ifdef TRACK_DOWN_MALLOC_PROBLEM
#include <crtdbg.h>
#endif

void
error_exit(int code)
{
	fprintf(stderr,"Exit code %d\n", code);
	exit(code);
}

FILE *
open_file(const char *filenameP)
{
	FILE	*F;

	F = fopen(filenameP, "w");
	if (!F) {
		fprintf(stderr, "Can't open %s\n", filenameP);
		exit(1);
	}
	return(F);
}

u4T
unicodelth(const u2T *stringP)
{
	register	const u2T	*P  = stringP;

	for (;*P; ++P);
	return (P - stringP);
}

u2T *
unicoderchr(u2T *stringP, u2T find)
{
	register u2T *P;
	register u2T *retP;
	register u2T c;

	retP = 0;
	for (P = stringP; (c = *P); ++P) {
		if (c == find) {
			retP = P;
	}	}
	return(retP);
}

u2T *
unicodechr(u2T *stringP, u2T find)
{
	register u2T *P;
	register u2T c;

	for (P = stringP; (c = *P); ++P) {
		if (c == find) {
			return(P);
	}	}
	return(0);
}

// Copy an asci string to unicode

u2T *
unicodecpy1(u2T *string1P, const char *string2P)
{
	register		  u2T	*P1 = string1P;
	register	const char	*P2 = string2P;

	while ((*P1++ = *P2++));
	return P1;
}

// Copy a unicode string to unicode

u2T *
unicodecpy(u2T *string1P, const u2T *string2P)
{
	register		  u2T	*P1 = string1P;
	register	const u2T	*P2 = string2P;

	while ((*P1++ = *P2++));
	return P1;
}

void
unicodencpy(u2T *toP, const u2T *fromP, int lth)
{
	memcpy(toP, fromP, sizeof(u2T) *lth);
	toP[lth] = 0;
}

u2T *
unicodedup1(const char *stringP)
{
	register	u2T			*retP;
	size_t		lth;

	lth = strlen(stringP);
	retP = (u2T *) Xmalloc((lth+1) * sizeof(u2T));
	if (!retP) {
		outofmemory();
	}
	unicodecpy1(retP, stringP);
	return(retP);
}

u2T *
unicodedup(const u2T *stringP)
{
	register u2T *retP;
	int			 lth;

	lth = unicodelth(stringP);
	retP = (u2T *) Xmalloc((lth+1) * sizeof(u2T));
	if (!retP) {
		outofmemory();
	}
	unicodecpy(retP, stringP);
	return(retP);
}

int 
unicodecmp(const u2T *string1P, const u2T *string2P)
{
	register	const u2T	*P1 = string1P;
	register	const u2T	*P2 = string2P;
	register 	u2T			c1;
	register 	u2T			c2;

	for (;;) {
		if (!(c1 = *P1)) {
			if (!*P2) {
				return(0);
			}
			return(1);
		}
		if (!(c2 = *P2)) {
			return(1);
		}
		if (c1 != c2) {
			return(1);
		}
		++P1;
		++P2;
}	}

void
dumpUnicode(const u2T *stringP)
{
	const register u2T *P;
	u2T					c;

	// Under g++ sizeof(wchar_t) == 4 : YUK
	// Worse fputwc returns an error about being unable to seek when attempting
	// to write a unicode character.  For the present fall back on simply
	// emitting ascii characters, hoping that this is ok.
	// N.B. This is not a problem under windows

	for (P = stringP; ; ++P) {
		switch (c = *P) {
		case 0:
			return;
		case '\n':
			c = 'n';
			break;
		case '\t':
			c = 't';
			break;
		case '\f':
			c = 'f';
			break;
		case '\r':
			c = 'r';
			break;
		case 27:	/* Esc */
			c = 'e';
			break;
		case 127:	/* Delete */
			c = 'd';
			break;
		case '\\':
		case '"':
			break;
		case '>':
			fputs("&gt;", stdoutF);
			continue;
		case '<':
			fputs("&lt;", stdoutF);
			continue;
		case '&':
			fputs("&amp;", stdoutF);
			continue;
		default:
			if (c > 255) {
				fprintf(stdoutF, "\\u%04x", c);
			} else {
				fputc(c, stdoutF);
			}
			continue;
		}
		fputc('\\', stdoutF);
		fputc(c, stdoutF);
	}
}

void
dump_wchar(const u2T *stringP, FILE *F)
{
	const register u2T 	*P;
	u2T					c;

	if (stringP) {
		for (P = stringP; (c = *P); ++P) {
#ifdef WIN32
			fputwc(c, F);
#else
			fputc(c, F);
#endif
	}	}
}

void
dumpString(const char *stringP)
{
	const register char *P;
	char				c;

	if (!stringP) {
		return;
	}
	for (P = stringP; ; ++P) {
		switch (c = *P) {
		case 0:
			return;
		case '\n':
			c = 'n';
			break;
		case '\t':
			c = 't';
			break;
		case '\f':
			c = 'f';
			break;
		case '\r':
			c = 'r';
			break;
		case 27:	/* Esc */
			c = 'e';
			break;
		case 127:	/* Delete */
			c = 'd';
			break;
		case '\\':
		case '"':
			break;
		case '>':
			fputs("&gt;", stdoutF);
			continue;
		case '<':
			fputs("&lt;", stdoutF);
			continue;
		case '&':
			fputs("&amp;", stdoutF);
			continue;
		default:
			fputc(c, stdoutF);
			continue;
		}
		fputc('\\', stdoutF);
		fputc(c, stdoutF);
	}
}

void
dump_access(u2T	access)
{
	static const char *accessName[] = {
		/* 0x0001 */	"public ",			// ACC_PUBLIC 0x0001 Visible to everyone  Class, Method, Variable 
		/* 0x0002 */	"private ",			// ACC_PRIVATE 0x0002 Visible only to the defining class  Method, Variable 
		/* 0x0004 */	"protected ",		// ACC_PROTECTED 0x0004 Visible to subclasses  Method, Variable 
		/* 0x0008 */	"static ",			// ACC_STATIC 0x0008 Variable or method is static  Method, Variable
		/* 0x0010 */	"final ",			// ACC_FINAL 0x0010 No further subclassing, overriding, or assignment after initialization Class, Method, Variable 
		/* 0x0020 */	"synchronized ",	// ACC_SYNCHRONIZED 0x0020 Wrap use in monitor lock Method 
		/* 0x0040 */	"volatile ",		// ACC_VOLATILE 0x0040 Can't cache Variable 
		/* 0x0080 */	"transient ",		// ACC_TRANSIENT 0x0080 Not to be written or read by a persistent object manager  Variable
		/* 0x0100 */	"native ",			// ACC_NATIVE 0x0100 Implemented in a language other than Java Method 
		/* 0x0200 */	"interface ",		// ACC_INTERFACE 0x0200 Is an interface  Class 
		/* 0x0400 */	"abstract ",		// ACC_ABSTRACT 0x0400 No body provided  Class, Method 
		/* 0x0800 */	"strict ",			// ACC_STRICT 0x0800 Declared strictfp; floating-point mode is FP-strict 
		/* 0x1000 */	"synthetic ",		// ACC_SYNTHETIC
		/* 0x2000 */	"annotation ",		// ACC_ANNOTATION
		/* 0x4000 */	"enum ",			// ACC_ENUM	
		/* 0x8000 */	"0x8000 "
	};
	int	mask, i;

	for (i = 15, mask = 0x8000; mask; --i, mask >>= 1) {
		if (access & mask) {
			fputs(accessName[i], stdoutF);
	}	}
}

void
dump_classname(const u2T *classnameP)
{
	const u2T	*P;
	u2T			c;

	for (P = classnameP; (c = *P) ; ++P) {
		if (c == '/') {
			c = '.';
		}
		fputc(c, stdoutF);
	}
}

void
count_parameters(const u2T *descriptorP, u1T *parametersP, u1T *returnsP)
{
	const u2T	*P;
	u2T			c;
	int			parameters;
	int			returns;
	
	for (P = descriptorP; (c = *P++) != '('; ) {
		if (!c) {
			assert(0);
			return;
	}	}

	for (parameters = 0; ; ++P) {
		switch (*P) {
		case 0:
			assert(0);
			return;
		case '[':	// Array of
			continue;
		case ')':
			switch (P[1]) {
			case 'J':	// Long
			case 'D':	// Double
				returns = 2;
				break;
			case 'V':	// Void
				returns = 0;
				break;
			default:
				returns = 1;
			}
			*parametersP += parameters;
			*returnsP    += returns;
			return;
		case 'J':	// Long
		case 'D':	// Double precision
			if (P[-1] != '[') {
				++parameters;
			}
			break;
		case 'L':	// Class name
			while ((c = *++P) && c != ';');
		case 'B':	// byte
		case 'C':	// unicode char
		case 'F':	// float
		case 'I':	// int
		case 'S':	// signed short
		case 'Z':	// boolean
			break;
		default:
			assert(0);
			return;
		}
		++parameters;
}	}	

void
deslash(u2T	*stringP)
{
	u2T	*P;

	for (P = stringP; ; ++P) {
		switch (*P) {
		case '/':
			*P = '.';
			break;
		case 0:
			return;
}	}	}


