#include "typedef.h"

#include <malloc.h>
#include <stdio.h>

#include "xmalloc.h"
#include "util.h"

void
outofmemory(void)
{
	fprintf(stderr, "Out of memory\n");
	error_exit(4);
}

#ifdef TEST_MALLOC

#include <assert.h>
#include <string.h>

unsigned int g_memory = 0;

typedef struct {
	char		*trailerP;
	char		*fileP;
	int			lineno;
	int			marker;
} headerT;

#define MARKER 654321
#define TRAILER "xmalloc"

void *
xmalloc2(unsigned int size, char *fileP, int lineno)
{
	headerT	*headerP;

	assert(size >= 0);
	headerP = (headerT *) malloc(sizeof(headerT) + size + 8);
	if (!headerP) {
		return(0);
	}
	g_memory         += size;
	headerP->fileP    = fileP;
	headerP->lineno   = lineno;
	headerP->trailerP = (char *) (headerP+1) + size;
	headerP->marker   = MARKER;
	strcpy(headerP->trailerP, TRAILER);
	return(headerP+1);
}

void *
xrealloc2(void *oldP, unsigned int size, char *fileP, int lineno)
{
	headerT	*headerP;

	assert(size >= 0);
	if (!oldP) {
		headerP = (headerT *) oldP;
	} else {
		headerP   = ((headerT *) oldP)-1;
		g_memory -= headerP->trailerP - (char *) oldP;
		if (headerP->marker != MARKER) {
			fprintf(stderr, "xrealloc2: marker corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		if (strcmp(headerP->trailerP, TRAILER)) {
			fprintf(stderr, "xrealloc2: trailer corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		strcpy(headerP->trailerP, "bad1");
	}

	headerP = (headerT *) realloc(headerP, sizeof(headerT) + size + 8);
	if (!headerP) {
		return(0);
	}
	g_memoryP        += size;
	headerP->fileP    = fileP;
	headerP->lineno   = lineno;
	headerP->trailerP = (char *) (headerP+1) + size;
	headerP->marker   = MARKER;
	strcpy(headerP->trailerP, TRAILER);
	return(headerP+1);
}

void
xfree2(void *oldP)
{
	headerT	*headerP;

	if (oldP) {
		headerP = ((headerT *) oldP) - 1;
		if (headerP->marker != MARKER) {
			fprintf(stderr, "xfree2: marker corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		if (strcmp(headerP->trailerP, TRAILER)) {
			fprintf(stderr, "xrealloc2: trailer corrupt %s:%d\n", headerP->fileP, headerP->lineno);
			assert(0);
			error_exit(5);
		}
		strcpy(headerP->trailerP, "bad2");
		g_memory -= headerP->trailerP - (char *) oldP;
		free(headerP);
}	}

#else

void *
xmalloc1(unsigned int size)
{
#ifdef TRACK_DOWN_MALLOC_PROBLEM
	static int		initialised_crt = 0;

	if (!initialised_crt) {
		printf("Performing exhaustive checking of memory heap\n");
		initialised_crt = 1;
		_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDOUT );
		_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDOUT );
		_CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_FILE );
		_CrtSetReportFile( _CRT_ASSERT, _CRTDBG_FILE_STDOUT );
		// Get current flag
		int tmpFlag = _CrtSetDbgFlag( _CRTDBG_REPORT_FLAG );

		// Turn on leak-checking bit
		tmpFlag |= _CRTDBG_LEAK_CHECK_DF;
	//	tmpFlag |= _CRTDBG_CHECK_CRT_DF;
		tmpFlag |= _CRTDBG_CHECK_ALWAYS_DF;

		// Set flag to the new value
		_CrtSetDbgFlag( tmpFlag );
	}
	if (!_CrtCheckMemory()) {
		assert(0);
	}
#endif
	void *P;

	P = malloc(size);
	return(P);
}

void *
xrealloc1(void *oldP, unsigned int size)
{
	void *P;

	P = realloc(oldP, size);
	return(P);
}

void
xfree1(void *oldP)
{
	free(oldP);
}

#endif
