/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.interp.ParseException;
import ca.uwaterloo.cs.jgrok.interp.ScriptUnitNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TokenMgrError;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.util.History;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LineInterp {
    private Timing timing;
    private History history;
    private boolean keepHistory = true;
    private StringBuffer buffer;

    public LineInterp() {
        Interp.instance();
        this.history = new History();
        this.buffer = new StringBuffer();
    }

    public LineInterp(boolean keepHistory) {
        Interp.instance();
        this.history = new History();
        this.buffer = new StringBuffer();
        this.keepHistory = keepHistory;
    }

    public History getHistory() {
        return this.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(Env env, String line) {
        if (env == null) {
            return;
        }
        ScriptUnitNode unit = env.getMainUnit();
        try {
            SyntaxTreeNode node;
            line = line.trim();
            if (line.startsWith("%") || line.startsWith("//")) {
                line = "";
            }
            if (line.endsWith("\\")) {
                while (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                    line = line.trim();
                }
                if (line.length() > 0) {
                    this.buffer.append(" ");
                    this.buffer.append(line);
                }
                return;
            }
            if (line.length() > 0) {
                this.buffer.append(" ");
                this.buffer.append(line);
            }
            if (this.buffer.length() == 0) {
                return;
            }
            if (this.keepHistory) {
                this.history.add(this.buffer.toString());
            }
            ByteArrayInputStream byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
            Interp.ReInit(byteStream);
            try {
                node = Interp.Statement();
            }
            catch (ParseException e) {
                byteStream.close();
                byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
                Interp.ReInit(byteStream);
                node = Interp.Expression();
            }
            if (unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                }
                this.timing.start();
            }
            Value value = node.evaluate(env);
            if (node instanceof ExpressionNode) {
                value.print(env.out);
            }
            if (unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                } else {
                    this.timing.stop();
                    env.out.println("time:");
                    env.out.println("\t" + this.timing.getTime());
                }
            }
            if (unit.isEchoOn()) {
                env.out.println(Env.promptText + node.toString());
            }
            byteStream.close();
            byteStream = null;
            this.buffer.delete(0, this.buffer.length());
        }
        catch (IOException e) {
            env.out.println("Exception: " + e.getMessage());
        }
        catch (TokenMgrError e) {
            env.out.println("Exception: " + e.getMessage());
        }
        catch (ParseException e) {
            env.out.println("Exception: unable to parse " + this.buffer);
        }
        catch (EvaluationException e) {
            env.out.println("Exception: " + e.getMessage());
        }
        finally {
            this.buffer.delete(0, this.buffer.length());
        }
    }
}

