/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok;

import ca.uwaterloo.cs.jgrok.Shell;
import ca.uwaterloo.cs.jgrok.Version;
import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.File;
import java.io.FileNotFoundException;

public class Main {
    private Env env = new Env();

    public void shell() {
        this.env.out.println(Version.authorsAndCopyright());
        Shell sh = new Shell();
        sh.shellEvaluate();
    }

    public void debug(String[] args) {
        this.env.out.println(Version.authorsAndCopyright());
        Shell sh = new Shell();
        sh.debugEvaluate(args);
        System.exit(0);
    }

    public void exeFile(String[] args) {
        Timing timing = new Timing();
        timing.start();
        File file = new File(args[0]);
        try {
            Interp interp = new Interp(file);
            interp.fileEvaluate(this.env, args);
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: File \"" + file + "\" not found!");
        }
        timing.stop();
        try {
            String showTiming = System.getProperty("timing");
            if (showTiming != null && showTiming.equalsIgnoreCase("true")) {
                System.out.println("Total time = " + timing.getTime());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        Main program = new Main();
        if (args.length == 0) {
            program.shell();
        } else if (args[0].equals("-debug")) {
            if (args.length == 1) {
                program.shell();
            } else {
                String[] debugArgs = new String[args.length - 1];
                System.arraycopy(args, 1, debugArgs, 0, args.length - 1);
                program.debug(debugArgs);
            }
        } else {
            program.exeFile(args);
        }
    }
}

