/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok;

import ca.uwaterloo.cs.jgrok.ShellCompleter;
import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.interp.ParseException;
import ca.uwaterloo.cs.jgrok.interp.QdbCode;
import ca.uwaterloo.cs.jgrok.interp.ScriptUnitNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TokenMgrError;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;

public class Shell {
    private Env env;
    private Timing timing;
    private Interp interp;
    private StringBuffer buffer;
    private ByteArrayInputStream byteStream;
    private Value value;
    private ScriptUnitNode unit;
    private SyntaxTreeNode node;

    Shell() {
    }

    void debugEvaluate(String[] args) {
        this.initEnv(args);
        try {
            this.unit.debugEvaluate(this.env, 1);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(0);
        }
        if (this.initReadline()) {
            block11: while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = Readline.readline(Env.promptText)) == null) {
                            continue;
                        }
                        if (this.isKeyword(line)) {
                            this.qdbHelp(line);
                            continue;
                        }
                        int code = QdbCode.get(line);
                        if (code >= 0) {
                            try {
                                this.unit.debugEvaluate(this.env, code);
                                continue block11;
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage());
                                System.exit(0);
                                continue;
                            }
                        }
                        this.evaluate(line);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.env.out.println("Exception: " + e.getMessage());
                    continue;
                }
                catch (IOException eof) {
                }
                break;
            }
        } else {
            InputStreamReader reader = new InputStreamReader(this.env.in);
            BufferedReader bufReader = new BufferedReader(reader);
            while (true) {
                this.env.out.print(Env.promptText);
                try {
                    String line = bufReader.readLine();
                    if (line == null) {
                        this.env.out.println();
                        continue;
                    }
                    if (this.isKeyword(line)) {
                        this.qdbHelp(line);
                        continue;
                    }
                    int code = QdbCode.get(line);
                    if (code >= 0) {
                        try {
                            this.unit.debugEvaluate(this.env, code);
                        }
                        catch (Exception e) {
                            System.err.println(e.getMessage());
                            System.exit(0);
                        }
                        continue;
                    }
                    this.evaluate(line);
                }
                catch (IOException e) {}
            }
        }
        this.env.out.println();
        Readline.cleanup();
        this.freeEnv();
    }

    void shellEvaluate() {
        this.initEnv();
        if (this.initReadline()) {
            while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = Readline.readline(Env.promptText)) == null || this.isKeyword(line)) {
                            continue;
                        }
                        this.evaluate(line);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.env.out.println("Exception: " + e.getMessage());
                    continue;
                }
                catch (IOException eof) {
                }
                break;
            }
        } else {
            InputStreamReader reader = new InputStreamReader(this.env.in);
            BufferedReader bufReader = new BufferedReader(reader);
            while (true) {
                this.env.out.print(Env.promptText);
                try {
                    String line = bufReader.readLine();
                    if (line == null) {
                        this.env.out.println();
                        continue;
                    }
                    if (this.isKeyword(line)) continue;
                    this.evaluate(line);
                }
                catch (IOException e) {}
            }
        }
        this.env.out.println();
        Readline.cleanup();
        this.freeEnv();
    }

    private void initEnv(String[] args) {
        this.env = new Env();
        File file = new File(args[0]);
        try {
            this.interp = new Interp(file);
            this.unit = this.interp.parse();
            if (this.unit == null) {
                System.exit(0);
            }
            this.env.setMainUnit(this.unit);
            this.env.pushScope(this.unit);
            Variable var = new Variable(this.unit, "$#", new Value(args.length - 1));
            this.unit.addVariable(var);
            for (int i = 0; i < args.length; ++i) {
                var = new Variable(this.unit, "$" + i, new Value(args[i]));
                this.unit.addVariable(var);
            }
            this.timing = null;
            this.buffer = new StringBuffer();
        }
        catch (FileNotFoundException ex) {
            System.err.println("No such a file " + file + " exists");
            System.exit(0);
        }
    }

    private void initEnv() {
        this.env = new Env();
        this.unit = new ScriptUnitNode();
        this.env.setMainUnit(this.unit);
        this.env.pushScope(this.unit);
        this.timing = null;
        this.interp = new Interp();
        this.buffer = new StringBuffer();
    }

    private void freeEnv() {
        this.env.popScope();
    }

    private boolean initReadline() {
        try {
            Readline.load(ReadlineLibrary.GnuReadline);
        }
        catch (UnsatisfiedLinkError ignore_readline) {
            try {
                Readline.load(ReadlineLibrary.Editline);
            }
            catch (UnsatisfiedLinkError ignore_editline) {
                System.err.println("Unable to load readline lib. Using stdin.");
            }
        }
        Readline.initReadline("jGrok Shell");
        Readline.parseAndBind("\"\\e[18~\":        \"Function key F7\"");
        Readline.parseAndBind("\"\\e[19~\":        \"Function key F8\"");
        try {
            Readline.setWordBreakCharacters(" \t;");
        }
        catch (UnsupportedEncodingException enc) {
            System.err.println("Unable to set word break characters");
            return false;
        }
        Readline.setCompleter(new ShellCompleter());
        return true;
    }

    private boolean isKeyword(String line) {
        return line.equals("?") || line.equals("help") || line.equals("print") || line.equals("delete");
    }

    private void qdbHelp(String line) {
        if (line.equals("?") || line.equals("help")) {
            System.out.println("qdb:");
            System.out.println("    x - Continue to finish");
            System.out.println("    c - Continue to next pause");
            System.out.println("    l - Display next statement");
            System.out.println("    n - Execute next statement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(String line) {
        try {
            line = line.trim();
            if (line.startsWith("%") || line.startsWith("//")) {
                line = "";
            }
            if (line.endsWith("\\")) {
                while (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                    line = line.trim();
                }
                if (line.length() > 0) {
                    this.buffer.append(" ");
                    this.buffer.append(line);
                }
                return;
            }
            if (line.length() > 0) {
                this.buffer.append(" ");
                this.buffer.append(line);
            }
            if (this.buffer.length() == 0) {
                return;
            }
            this.byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
            Interp.ReInit(this.byteStream);
            try {
                this.node = Interp.Statement();
            }
            catch (ParseException e) {
                this.byteStream.close();
                this.byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes());
                Interp.ReInit(this.byteStream);
                this.node = Interp.Expression();
            }
            if (this.unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                }
                this.timing.start();
            }
            if (this.unit.isEchoOn()) {
                this.env.out.println(Env.promptText + this.node.toString());
            }
            this.value = this.node.evaluate(this.env);
            if (this.node instanceof ExpressionNode) {
                this.value.print(this.env.out);
            }
            if (this.unit.isTimeOn()) {
                if (this.timing == null) {
                    this.timing = new Timing();
                } else {
                    this.timing.stop();
                    this.env.out.println("time:");
                    this.env.out.println("\t" + this.timing.getTime());
                }
            }
            this.byteStream.close();
            this.byteStream = null;
            this.buffer.delete(0, this.buffer.length());
        }
        catch (IOException e) {
            this.env.out.println("Exception: " + e.getMessage());
        }
        catch (TokenMgrError e) {
            this.env.out.println("Exception: " + e.getMessage());
        }
        catch (ParseException e) {
            this.env.out.println("Exception: unable to parse " + this.buffer);
        }
        catch (EvaluationException e) {
            this.env.out.println("Exception: " + e.getMessage());
        }
        finally {
            this.buffer.delete(0, this.buffer.length());
        }
    }
}

