/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.env;

import ca.uwaterloo.cs.jgrok.interp.Type;
import ca.uwaterloo.cs.jgrok.interp.Value;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Clazz {
    public static boolean isJavaPrimitive(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Character.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Boolean.TYPE;
    }

    public static boolean isJGrokPrimitive(Class<?> clazz) {
        if (clazz == String.class) {
            return true;
        }
        return Clazz.isJavaPrimitive(clazz);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<Object> clazz = null;
        if (className != null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (className.equals("void")) {
                    clazz = Void.TYPE;
                }
                if (className.equals("int")) {
                    clazz = Integer.TYPE;
                }
                if (className.equals("float")) {
                    clazz = Float.TYPE;
                }
                if (className.equals("string")) {
                    clazz = String.class;
                }
                if (className.equals("String")) {
                    clazz = String.class;
                }
                if (className.equals("boolean")) {
                    clazz = Boolean.TYPE;
                }
                if (className.equals("double")) {
                    clazz = Double.TYPE;
                }
                if (className.equals("short")) {
                    clazz = Short.TYPE;
                }
                if (className.equals("long")) {
                    clazz = Long.TYPE;
                }
                if (className.equals("byte")) {
                    clazz = Byte.TYPE;
                }
                if (className.equals("...")) {
                    clazz = null;
                }
                throw new ClassNotFoundException(className);
            }
        }
        return clazz;
    }

    public static Object forValue(String type, String value) throws ClassNotFoundException, InstantiationException {
        return Clazz.forValue(Clazz.forName(type), value);
    }

    public static Object forValue(Class<?> clazz, String value) throws InstantiationException {
        Object obj = null;
        if (clazz != null) {
            if (clazz.equals(Void.TYPE)) {
                obj = value;
            } else if (clazz.equals(Integer.TYPE)) {
                obj = Integer.parseInt(value);
            } else if (clazz.equals(Float.TYPE)) {
                obj = Float.valueOf(Float.parseFloat(value));
            } else if (clazz.equals(Boolean.TYPE)) {
                obj = Boolean.parseBoolean(value);
            } else if (clazz.equals(Double.TYPE)) {
                obj = Double.parseDouble(value);
            } else if (clazz.equals(Short.TYPE)) {
                obj = Short.parseShort(value);
            } else if (clazz.equals(Long.TYPE)) {
                obj = Long.parseLong(value);
            } else if (clazz.equals(Byte.TYPE)) {
                obj = Byte.parseByte(value);
            } else if (clazz.equals(String.class)) {
                obj = value;
            } else {
                try {
                    obj = clazz.getConstructor(String.class).newInstance(value);
                }
                catch (Exception e) {
                    throw new InstantiationException(e.getMessage());
                }
            }
        } else {
            obj = value;
        }
        return obj;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method[] methods;
        int distOld = 1000;
        Method specific = null;
        Class<?>[] paramTypes = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers()) || (paramTypes = method.getParameterTypes()).length != argTypes.length) continue;
            int distNew = Type.distanceTo(argTypes, paramTypes);
            if (distNew >= 0) {
                if (specific == null) {
                    specific = method;
                    distOld = distNew;
                } else if (distNew < distOld) {
                    specific = method;
                    distOld = distNew;
                }
            }
            if (distNew == 0) break;
        }
        return specific;
    }

    public static Method getStaticMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        Method[] methods;
        int distOld = 1000;
        Method specific = null;
        Class<?>[] paramTypes = null;
        for (Method method : methods = clazz.getMethods()) {
            int mod;
            if (!method.getName().equals(methodName) || !Modifier.isPublic(mod = method.getModifiers()) || !Modifier.isStatic(mod) || (paramTypes = method.getParameterTypes()).length != argTypes.length) continue;
            int distNew = Type.distanceTo(argTypes, paramTypes);
            if (distNew >= 0) {
                if (specific == null) {
                    specific = method;
                    distOld = distNew;
                } else if (distNew < distOld) {
                    specific = method;
                    distOld = distNew;
                }
            }
            if (distNew == 0) break;
        }
        return specific;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] argTypes) {
        Constructor<?>[] constructors;
        int distOld = 1000;
        Constructor<?> specific = null;
        Class<?>[] paramTypes = null;
        for (Constructor<?> c : constructors = clazz.getConstructors()) {
            if (!Modifier.isPublic(c.getModifiers()) || (paramTypes = c.getParameterTypes()).length != argTypes.length) continue;
            int distNew = Type.distanceTo(argTypes, paramTypes);
            if (distNew >= 0) {
                if (specific == null) {
                    specific = c;
                    distOld = distNew;
                } else if (distNew < distOld) {
                    specific = c;
                    distOld = distNew;
                }
            }
            if (distNew == 0) break;
        }
        return specific;
    }

    public static Object newInstance(String className) throws ClassNotFoundException, InstantiationException {
        if (className == null) {
            return null;
        }
        try {
            Class<?> defClass = Class.forName(className);
            return defClass.newInstance();
        }
        catch (ClassNotFoundException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new InstantiationException(e2.getMessage());
        }
    }

    public static Object newInstance(Class<?> clazz) throws InstantiationException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public static Object newInstance(Class<?> clazz, Object[] args) throws NoSuchMethodException, InstantiationException {
        try {
            Class[] paramTypes = null;
            if (args != null) {
                paramTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    paramTypes[i] = args[i].getClass();
                }
            }
            Constructor<?> c = clazz.getConstructor(paramTypes);
            return c.newInstance(args);
        }
        catch (NoSuchMethodException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new InstantiationException(e2.getMessage());
        }
    }

    public static Object newInstance(Class<?> clazz, Value[] args) throws NoSuchMethodException, InstantiationException {
        try {
            Object[] objs = null;
            Class[] paramTypes = null;
            if (args != null) {
                objs = new Object[args.length];
                paramTypes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    objs[i] = args[i].objectValue();
                    paramTypes[i] = args[i].getType();
                }
            } else {
                objs = new Object[]{};
            }
            Constructor<?> c = clazz.getConstructor(paramTypes);
            return c.newInstance(objs);
        }
        catch (NoSuchMethodException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new InstantiationException(e2.getMessage());
        }
    }
}

