/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.env;

import ca.uwaterloo.cs.jgrok.env.Tracing;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.ScriptUnitNode;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.FunctionLib;
import ca.uwaterloo.cs.jgrok.lib.FunctionLibManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;

public class Env {
    public InputStream in = System.in;
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    public static String promptText = ">> ";
    private ArrayList<Scope> scopes = new ArrayList(10);
    private ScriptUnitNode mainUnit;
    private Tracing trcUtility = new Tracing();

    public Tracing getTracing() {
        return this.trcUtility;
    }

    public ScriptUnitNode getMainUnit() {
        return this.mainUnit;
    }

    public void setMainUnit(ScriptUnitNode unit) {
        this.mainUnit = unit;
    }

    public void removeAllScopes() {
        this.scopes.clear();
    }

    public Scope popScope() {
        return this.scopes.remove(this.scopes.size() - 1);
    }

    public void pushScope(Scope scp) {
        this.scopes.add(scp);
    }

    public Scope peepScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    public ScriptUnitNode traceScriptUnit() {
        Scope scp = this.peepScope();
        if (scp instanceof ScriptUnitNode) {
            return (ScriptUnitNode)scp;
        }
        while (scp != null) {
            if (!((scp = scp.getParent()) instanceof ScriptUnitNode)) continue;
            return (ScriptUnitNode)scp;
        }
        return null;
    }

    public Variable lookup(String name) throws LookupException {
        Variable var = null;
        LookupException lex = null;
        int i = this.scopes.size();
        while (--i >= 0) {
            Scope scp = this.scopes.get(i);
            try {
                var = scp.lookup(name);
                return var;
            }
            catch (LookupException e) {
                if (lex != null) continue;
                lex = e;
            }
        }
        if (lex != null) {
            throw lex;
        }
        return var;
    }

    public Function lookupFunction(String functionName) throws LookupException {
        Function aFunction = FunctionLibManager.getRootLib().find(functionName);
        if (aFunction != null) {
            return aFunction;
        }
        throw new LookupException("function " + functionName);
    }

    public Function lookupFunction(String libName, String functionName) throws LookupException {
        Function aFunction;
        FunctionLib lib = FunctionLibManager.findLib(libName);
        if (lib != null && (aFunction = lib.find(functionName)) != null) {
            return aFunction;
        }
        throw new LookupException("function " + libName + "." + functionName);
    }

    public static boolean isReservedWord(String name) {
        if (name.equals("class") || name.equals("JGrok")) {
            return true;
        }
        return name.equals("int") || name.equals("long") || name.equals("byte") || name.equals("short") || name.equals("float") || name.equals("double") || name.equals("boolean");
    }
}

