/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.env;

import ca.uwaterloo.cs.jgrok.env.TracingEvent;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class Tracing {
    public InputStream in = System.in;
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private boolean enabled = false;
    private Hashtable<String, TracingEvent> evtMap = new Hashtable();

    public void clearEvents() {
        this.evtMap.clear();
    }

    public Enumeration<TracingEvent> elements() {
        return this.evtMap.elements();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setState(String state) {
        if (state == null) {
            this.setEnabled(false);
        } else if (state.equalsIgnoreCase("off")) {
            this.setEnabled(false);
        } else if (state.equalsIgnoreCase("on")) {
            this.setEnabled(true);
        } else {
            throw new IllegalArgumentException("state");
        }
    }

    public String getState() {
        return this.enabled ? "on" : "off";
    }

    public TracingEvent get(String eventName) {
        if (eventName == null) {
            return null;
        }
        String key = eventName.toLowerCase();
        return this.evtMap.get(key);
    }

    public boolean add(TracingEvent event) {
        String key;
        boolean ret = false;
        if (event != null && !this.evtMap.containsKey(key = event.getName().toLowerCase())) {
            this.evtMap.put(key, event);
            ret = true;
        }
        return ret;
    }

    public boolean remove(TracingEvent event) {
        String key;
        boolean ret = false;
        if (event != null && this.evtMap.containsKey(key = event.getName().toLowerCase())) {
            this.evtMap.remove(key);
            ret = true;
        }
        return ret;
    }

    public boolean traceOn(String eventName) {
        if (this.isEnabled()) {
            if (eventName == null) {
                return false;
            }
            String key = eventName.toLowerCase();
            return this.evtMap.containsKey(key) && this.evtMap.get(key).isEnabled();
        }
        return false;
    }

    public boolean traceOn(TracingEvent event) {
        if (this.isEnabled()) {
            String key = event.getName().toLowerCase();
            return this.evtMap.containsKey(key) && this.evtMap.get(key).isEnabled();
        }
        return false;
    }

    public void printMessage(String eventName, String message) {
        if (this.traceOn(eventName)) {
            this.out.print(message);
        }
    }

    public void printError(String eventName, String message) {
        if (this.traceOn(eventName)) {
            this.err.print(message);
        }
    }

    public void printMessage(PrintStream ps, String eventName, String message) {
        if (this.traceOn(eventName)) {
            ps.print(message);
        }
    }
}

