/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleList;

public class CompositeID {
    public static NodeSet getEnclosingIDs(NodeSet set) {
        NodeSet result = new NodeSet();
        if (set == null || set.size() == 0) {
            return result;
        }
        set.trySort(0);
        TupleList t_l = set.data;
        NodeSet comIDs = IDManager.getAllCompositeIDs();
        int count = comIDs.size();
        for (int i = 0; i < count; ++i) {
            int comID = comIDs.data.get(i).get(0);
            int[] sonIDs = IDManager.parse(comID);
            for (int k = 0; k < sonIDs.length; ++k) {
                int aID = sonIDs[k];
                if (BinarySearch.search(t_l, aID, 0) > -1) {
                    result.add(comID);
                }
                if (!IDManager.isComposite(aID)) continue;
                CompositeID.furtherDown(result, t_l, aID);
            }
        }
        return result;
    }

    private static void furtherDown(NodeSet result, TupleList t_l, int comID) {
        int[] sonIDs = IDManager.parse(comID);
        for (int k = 0; k < sonIDs.length; ++k) {
            int aID = sonIDs[k];
            if (BinarySearch.search(t_l, aID, 0) > -1) {
                result.add(comID);
            }
            if (!IDManager.isComposite(aID)) continue;
            CompositeID.furtherDown(result, t_l, aID);
        }
    }
}

