/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.SpecialOperation;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import java.util.ArrayList;

public class ConceptEngine {
    TupleList data = new TupleList();
    TupleList shadow = new TupleList();
    EdgeSet hasFeature = new EdgeSet();
    EdgeSet curFeature;
    EdgeSet allConcepts;

    public void compute(EdgeSet hasFeature) {
        if (this.hasFeature != hasFeature) {
            this.hasFeature = hasFeature;
            EdgeSet c1 = new EdgeSet(100);
            EdgeSet c2 = new EdgeSet(100);
            this.initialize1();
            this.computeConcepts(c1);
            this.initialize2();
            this.computeConcepts(c2);
            c2 = AlgebraOperation.inverse(c2);
            this.allConcepts = AlgebraOperation.union(c1, c2);
        }
    }

    public EdgeSet getConcepts() {
        return this.allConcepts;
    }

    private void initialize1() {
        if (this.hasFeature == null || this.hasFeature.size() == 0) {
            this.data = new TupleList();
            this.shadow = new TupleList();
            this.curFeature = new EdgeSet();
            this.allConcepts = new EdgeSet();
            return;
        }
        this.curFeature = this.hasFeature;
        this.allConcepts = new EdgeSet();
        int count = this.curFeature.size();
        TupleList tList = this.curFeature.getTupleList();
        this.data = new TupleList(count);
        int[] elems = new int[3];
        for (int i = 0; i < count; ++i) {
            Tuple t = tList.get(i);
            elems[0] = t.getDom();
            elems[1] = t.getRng();
            elems[2] = 0;
            this.data.add(TupleFactory.create(elems));
        }
        this.shadow = new TupleList(count);
        RadixSorter.sort(this.data, 1, this.shadow);
        this.data = new TupleList(count);
        RadixSorter.sort(this.shadow, 0, this.data);
    }

    private void initialize2() {
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            Tuple t = this.data.get(i);
            int tmpValue = t.get(0);
            t.set(0, t.get(1));
            t.set(1, tmpValue);
        }
        this.shadow = this.data;
        this.data = new TupleList(count);
        RadixSorter.sort(this.shadow, 0, this.data);
        this.curFeature = AlgebraOperation.inverse(this.curFeature);
    }

    private void computeConcepts(EdgeSet concepts) {
        EdgeSet tmpConcepts = SpecialOperation.basket(this.curFeature);
        tmpConcepts = AlgebraOperation.inverse(tmpConcepts);
        tmpConcepts = SpecialOperation.basket(tmpConcepts);
        tmpConcepts = AlgebraOperation.inverse(tmpConcepts);
        int count = tmpConcepts.size();
        TupleList tList = tmpConcepts.getTupleList();
        for (int i = 0; i < count; ++i) {
            Tuple t = tList.get(i);
            int extent = t.getDom();
            int intent = t.getRng();
            int[] objects = IDManager.parse(extent);
            int[] features = IDManager.parse(intent);
            for (int j = 0; j < features.length; ++j) {
                for (int pos = BinarySearch.search(this.shadow, features[j], 1); pos < this.shadow.size() && this.shadow.get(pos).get(1) == features[j]; ++pos) {
                    this.shadow.get(pos).set(2, 1);
                }
            }
            int[] cObjs = this.collectObjects(features.length);
            if (objects.length == cObjs.length) {
                concepts.add(t);
                continue;
            }
            extent = IDManager.getID(cObjs);
            concepts.add(extent, intent);
        }
    }

    private int[] collectObjects(int outDeg) {
        ArrayList<Integer> aList = new ArrayList<Integer>(5);
        int count = this.data.size();
        if (count > 0) {
            Tuple t = this.data.get(0);
            int deg = 0;
            int obj = t.getDom();
            if (t.get(2) == 1) {
                ++deg;
                t.set(2, 0);
            }
            for (int i = 1; i < count; ++i) {
                t = this.data.get(i);
                int next = t.getDom();
                if (obj == next) {
                    if (t.get(2) != 1) continue;
                    ++deg;
                    t.set(2, 0);
                    continue;
                }
                if (deg == outDeg) {
                    aList.add(new Integer(obj));
                }
                deg = 0;
                obj = next;
                if (t.get(2) != 1) continue;
                ++deg;
                t.set(2, 0);
            }
            if (deg == outDeg) {
                aList.add(new Integer(obj));
            }
        }
        int[] objs = new int[aList.size()];
        for (int i = 0; i < aList.size(); ++i) {
            objs[i] = (Integer)aList.get(i);
        }
        return objs;
    }
}

