/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.Edge;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.Tuple4Edge;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleListFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import java.io.PrintWriter;

public class EdgeSet
extends TupleSet {
    public EdgeSet() {
        this.data = TupleListFactory.newEdgeList();
    }

    public EdgeSet(String name) {
        super(name);
        this.data = TupleListFactory.newEdgeList();
    }

    public EdgeSet(int capacity) {
        this.data = TupleListFactory.newEdgeList(capacity);
    }

    public void add(String fr, String to) {
        int dom = IDManager.getID(fr);
        int rng = IDManager.getID(to);
        this.data.add(new Tuple4Edge(dom, rng));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public void add(int fr, int to) {
        this.data.add(new Tuple4Edge(fr, to));
        this.sortLevel = -1;
        this.flags = 0;
    }

    public int getAttributeID(int nodeID) {
        this.trySort(0);
        int ind = BinarySearch.search(this.data, nodeID, 0);
        if (ind < 0) {
            return -1;
        }
        return this.data.get(ind).getRng();
    }

    public String getAttribute(int nodeID) {
        this.trySort(0);
        int ind = BinarySearch.search(this.data, nodeID, 0);
        if (ind < 0) {
            return null;
        }
        return IDManager.get(this.data.get(ind).getRng());
    }

    public Edge[] getAllEdges() {
        int count = this.data.size();
        Edge[] edges = new Edge[count];
        for (int i = 0; i < count; ++i) {
            Tuple tup = this.data.get(i);
            edges[i] = new Edge(tup.getDom(), tup.getRng());
        }
        return edges;
    }

    @Override
    public TupleSet newSet() {
        return new EdgeSet();
    }

    public void printRSF(PrintWriter writer) {
        super.printRSF(this.getName(), writer);
    }

    @Override
    protected void sort() {
        this.trySort(2);
    }

    @Override
    protected void sortDom() {
        this.trySort(0);
    }

    @Override
    protected void sortRng() {
        this.trySort(1);
    }

    @Override
    protected void trySort(int level) {
        int domCol = 0;
        int rngCol = 1;
        switch (level) {
            case 0: {
                if (this.sortLevel < 0) {
                    TupleList t_l = TupleListFactory.newEdgeList(this.data.size());
                    RadixSorter.sort(this.data, domCol, t_l);
                    this.data.setList(t_l.getList());
                    this.sortLevel = 0;
                    break;
                }
                if (this.sortLevel != 1) break;
                TupleList t_l = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, domCol, t_l);
                this.data.setList(t_l.getList());
                this.sortLevel = 2;
                break;
            }
            case 1: {
                if (this.sortLevel == 1) break;
                TupleList t_l = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, rngCol, t_l);
                this.data.setList(t_l.getList());
                this.sortLevel = 1;
                break;
            }
            case 2: {
                if (this.sortLevel == 1) {
                    TupleList t_l = TupleListFactory.newEdgeList(this.data.size());
                    RadixSorter.sort(this.data, domCol, t_l);
                    this.data.setList(t_l.getList());
                    this.sortLevel = 2;
                    break;
                }
                if (this.sortLevel >= 1) break;
                TupleList shadow = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(this.data, rngCol, shadow);
                TupleList t_l = TupleListFactory.newEdgeList(this.data.size());
                RadixSorter.sort(shadow, domCol, t_l);
                this.data.setList(t_l.getList());
                this.sortLevel = 2;
                break;
            }
            default: {
                if (level < 0) {
                    this.trySort(0);
                }
                if (level <= 2) break;
                this.trySort(2);
            }
        }
    }

    protected TupleList shadow() {
        TupleList shadow;
        if (this.sortLevel < 0) {
            this.trySort(1);
            shadow = new TupleList(this.size());
            shadow.getList().addAll(this.data.getList());
        } else if (this.sortLevel == 1) {
            shadow = new TupleList(this.size());
            shadow.getList().addAll(this.data.getList());
        } else {
            shadow = new TupleList(this.size());
            RadixSorter.sort(this.data, 1, shadow);
        }
        return shadow;
    }
}

