/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;

public class EdgeTree {
    private Tree nodeTree;
    private EdgeSet contain;

    public EdgeTree(EdgeSet contain) {
        this.contain = contain;
    }

    private void init(EdgeSet myContain) {
        this.nodeTree = new Tree(myContain);
        this.nodeTree.setLevels();
    }

    private int findCommonAncestor(int dom, int rng) {
        int i;
        if (dom == rng) {
            return this.nodeTree.getParent(dom);
        }
        Tree.Entry domEntry = this.nodeTree.getEntry(dom);
        Tree.Entry rngEntry = this.nodeTree.getEntry(rng);
        int node1 = dom;
        int node2 = rng;
        int domLevel = domEntry.level;
        int rngLevel = rngEntry.level;
        int count = 0;
        if (domLevel > rngLevel) {
            count = domLevel - rngLevel;
            for (i = 0; i < count; ++i) {
                node1 = this.nodeTree.getParent(node1);
            }
        } else if (domLevel < rngLevel) {
            count = rngLevel - domLevel;
            for (i = 0; i < count; ++i) {
                node2 = this.nodeTree.getParent(node2);
            }
        }
        while (node1 > -1 || node2 > -1) {
            if (node1 == node2) {
                return node1;
            }
            node1 = this.nodeTree.getParent(node1);
            node2 = this.nodeTree.getParent(node2);
        }
        return -1;
    }

    private int computeDistance(int dom, int rng) {
        int i;
        if (dom == rng) {
            return 0;
        }
        Tree.Entry domEntry = this.nodeTree.getEntry(dom);
        Tree.Entry rngEntry = this.nodeTree.getEntry(rng);
        int node1 = dom;
        int node2 = rng;
        int domLevel = domEntry.level;
        int rngLevel = rngEntry.level;
        int count = 0;
        if (domLevel > rngLevel) {
            count = domLevel - rngLevel;
            for (i = 0; i < count; ++i) {
                node1 = this.nodeTree.getParent(node1);
            }
        } else if (domLevel < rngLevel) {
            count = rngLevel - domLevel;
            for (i = 0; i < count; ++i) {
                node2 = this.nodeTree.getParent(node2);
            }
        }
        int distance = count;
        while ((node1 > -1 || node2 > -1) && node1 != node2) {
            node1 = this.nodeTree.getParent(node1);
            node2 = this.nodeTree.getParent(node2);
            distance += 2;
        }
        return distance;
    }

    public EdgeSet getEdgeTree(EdgeSet edges) {
        int top;
        boolean fake;
        NodeSet dom = AlgebraOperation.domainOf(this.contain);
        NodeSet rng = AlgebraOperation.rangeOf(this.contain);
        NodeSet ent = AlgebraOperation.entityOf(this.contain);
        NodeSet source = AlgebraOperation.difference(dom, rng);
        if (source.size() == 0) {
            return new EdgeSet();
        }
        EdgeSet usefulEdges = AlgebraOperation.composition(ent, edges);
        usefulEdges = AlgebraOperation.composition(usefulEdges, ent);
        EdgeSet myContain = this.contain;
        if (source.size() > 1) {
            fake = true;
            top = IDManager.getID(0, 0, 0);
            myContain = AlgebraOperation.crossProduct(NodeSet.singleton(top), source);
            myContain = AlgebraOperation.union(this.contain, myContain);
        } else {
            fake = false;
            top = source.getTupleList().get(0).getDom();
        }
        this.init(myContain);
        TupleList tlist = usefulEdges.data;
        EdgeSet edgeContain = new EdgeSet();
        for (int i = 0; i < tlist.size(); ++i) {
            Tuple t = tlist.get(i);
            int node = IDManager.getID(t.getDom(), t.getRng());
            int nodeParent = this.findCommonAncestor(t.getDom(), t.getRng());
            if (fake && nodeParent == top || nodeParent <= -1) continue;
            edgeContain.add(nodeParent, node);
            node = nodeParent;
            while (node != top && (nodeParent = this.nodeTree.getParent(node)) > -1) {
                edgeContain.add(nodeParent, node);
                node = nodeParent;
            }
        }
        edgeContain.removeDuplicates();
        return edgeContain;
    }

    public EdgeSet getEdgeDistance(EdgeSet edges) {
        NodeSet dom = AlgebraOperation.domainOf(this.contain);
        NodeSet rng = AlgebraOperation.rangeOf(this.contain);
        NodeSet ent = AlgebraOperation.entityOf(this.contain);
        NodeSet source = AlgebraOperation.difference(dom, rng);
        if (source.size() == 0) {
            return new EdgeSet();
        }
        EdgeSet usefulEdges = AlgebraOperation.composition(ent, edges);
        usefulEdges = AlgebraOperation.composition(usefulEdges, ent);
        EdgeSet myContain = this.contain;
        if (source.size() > 1) {
            int top = IDManager.getID(0, 0, 0);
            myContain = AlgebraOperation.crossProduct(NodeSet.singleton(top), source);
            myContain = AlgebraOperation.union(this.contain, myContain);
        }
        this.init(myContain);
        TupleList tlist = usefulEdges.data;
        EdgeSet edgeDistance = new EdgeSet();
        for (int i = 0; i < tlist.size(); ++i) {
            Tuple t = tlist.get(i);
            int edge = IDManager.getID(t.getDom(), t.getRng());
            int distance = this.computeDistance(t.getDom(), t.getRng());
            edgeDistance.add(edge, IDManager.getID(distance + ""));
        }
        edgeDistance.removeDuplicates();
        return edgeDistance;
    }
}

