/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.fb;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Factbase {
    private String name;
    private String type;
    private Hashtable<String, TupleSet> table;

    public Factbase() {
        this(null);
    }

    public Factbase(String name) {
        this.name = name;
        this.table = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasSet(String name) {
        return this.table.containsKey(name);
    }

    public Enumeration<TupleSet> allSets() {
        return this.table.elements();
    }

    public void remove(String name) {
        this.table.remove(name);
    }

    public TupleSet getSet(String name) {
        return this.table.get(name);
    }

    public void addSet(TupleSet tSet) {
        if (tSet != null) {
            this.table.put(tSet.getName(), tSet);
        }
    }

    public NodeSet getNodeSet(String name) {
        return (NodeSet)this.table.get(name);
    }

    public EdgeSet getEdgeSet(String name) {
        return (EdgeSet)this.table.get(name);
    }

    public Enumeration<NodeSet> allNodeSets() {
        Vector<NodeSet> list = new Vector<NodeSet>();
        Enumeration<TupleSet> enm = this.table.elements();
        while (enm.hasMoreElements()) {
            TupleSet set = enm.nextElement();
            if (!(set instanceof NodeSet)) continue;
            list.add((NodeSet)set);
        }
        return list.elements();
    }

    public Enumeration<EdgeSet> allEdgeSets() {
        Vector<EdgeSet> list = new Vector<EdgeSet>();
        Enumeration<TupleSet> enm = this.table.elements();
        while (enm.hasMoreElements()) {
            TupleSet set = enm.nextElement();
            if (!(set instanceof EdgeSet)) continue;
            list.add((EdgeSet)set);
        }
        return list.elements();
    }

    public void print(OutputStream out) throws IOException {
        Enumeration<TupleSet> enm = this.allSets();
        while (enm.hasMoreElements()) {
            TupleSet set = enm.nextElement();
            set.print(out);
        }
    }
}

